using namespace std;

#include <iostream>
#include "Connection.cpp"
#include "Attribute.cpp"

class Attr_LengthOfConnection : public Attribute
{
        public:
         double calculateDistance(Connection, Connection);
	 Attr_LengthOfConnection (double);
};


// This is going to return 1 if the lengths of the connections are within 5%
// and .5 if the lengths of the connections are >5% but <10%
// An alternative classification method would be to make 3 categories:
// short connections, medium connections, and long connections, and if
// con1 and con2 are in the same category return a favorable score,
// otherwise adjust accordingly.
double Attr_LengthOfConnection::calculateDistance(Connection con1, Connection con2)
{
	if((con1.length_of_connection - con2.length_of_connection)/con1.length_of_connection <.05 ||
	   (con1.length_of_connection - con2.length_of_connection)/con2.length_of_connection <.05)
	{
		return 1;
	}
	else if((con1.length_of_connection - con2.length_of_connection)/con1.length_of_connection <.1 ||
		(con1.length_of_connection - con2.length_of_connection)/con2.length_of_connection <.1)
	{
		return .5;
	}
	else
	{
		return 0;
	}
}

Attr_LengthOfConnection::Attr_LengthOfConnection(double w)
{
	weight = w;
}
