/* Use, modification, and distribution are subject to the Boost Software 
License, Version 1.0. (See accompanying file LICENSE_1.0.txt or copy at 
www.boost.org/LICENSE_1.0.txt) */

import java.io.*;
import java.net.*;

/**
 * Contains the static method get, which downloads a url and returns an 
 * InputStream to it.
 * @author Mike Ottum
 * @version 11/18/2003
 */
public class WebStream
{
    private InputStream stream;
    private URLConnection url_connection;
    private URL url;
    private boolean validtype=true;
    class FetchThread extends Thread
    {
	// calls the URL.openStream method
	public void run() {
	    try {
		url_connection = url.openConnection();
	    } catch (IOException ioe) {
		url_connection = null;
	    }
	}
    }
    
    class CheckTypeThread extends Thread
    {
	// checks the type of the page
	public void run() {
	    if(!checkType(url_connection.getHeaderField("content-type"))) {
		validtype = false;
	    }
	}
    }					

    class DownloadThread extends Thread
    {
	// downloads the url
	public void run() {
	    try {
		stream = url_connection.getInputStream();
	    } catch (IOException ioe) {
		stream = null;
	    }
	}
    }

    private boolean checkType(String type)
    {
	if(type == null) return false;
	if(type.startsWith("text/html") ||
	   type.startsWith("text/plain")) {
	    return true;
	}
	else return false;
    }

    private InputStream getStream(String pageURL)
    {
	long t1, t2, tFetchStart, tempTime, time;
	final int TIMEOUT = 10000;
	if(!Limiter.parse(pageURL)) {
	    return null;
	}
	try {
	    url = new URL(pageURL);
	    FetchThread thread = new FetchThread();
	    thread.start();
	    tFetchStart = System.currentTimeMillis();
	    while(thread.isAlive()) 
		// loop until the thread 
		{
		    tempTime = System.currentTimeMillis();
		    if(tempTime - tFetchStart >= TIMEOUT) {
			time = tempTime - tFetchStart;
			thread.interrupt();
			System.err.println("TimeOut on " + pageURL + " " + time + " ms");
			stream = null;
			break;
		    }
		    try {
			Thread.sleep(10);
		    } catch(InterruptedException ie) {}
		}
	    if(url_connection == null) return null;
	    // check content-type
	    
	    CheckTypeThread cthread = new CheckTypeThread();
	    cthread.start();
	    tFetchStart = System.currentTimeMillis();
	    while (cthread.isAlive()) {
		tempTime = System.currentTimeMillis();
		if(tempTime - tFetchStart >= TIMEOUT) {
		    time = tempTime - tFetchStart;
		    cthread.interrupt();
		    System.err.println("TimeOut on " + pageURL + " " + time + " ms");
    		    stream = null;
		    break;
		}
		try {
		    Thread.sleep(10);
		} catch(InterruptedException ie) {}
	    }
	    if (validtype == false) {
		return null;
	    }

	    DownloadThread dthread = new DownloadThread();
	    dthread.start();
	    tFetchStart = System.currentTimeMillis();
	    while(dthread.isAlive()) 
		// loop until the thread 
		{
		    tempTime = System.currentTimeMillis();
		    if(tempTime - tFetchStart >= TIMEOUT) {
			time = tempTime - tFetchStart;
			dthread.interrupt();
			System.err.println("TimeOut on " + pageURL + " " + time + " ms");
			stream = null;
			break;
		    }
		    try {
			Thread.sleep(10);
		    } catch(InterruptedException ie) {}
		}
	    //System.out.println("TestTime4:"+ (System.currentTimeMillis()-temptime2));
	} catch (Exception e) {
	    return null;
	}
	return stream;
    }

    /**
     * Downloads data from a given URL and returns the InputStream.  
     * Supports timeouts on both opening a connection and downloading the data.
     * @param pageURL The URL of the object to retrieve.
     * @return An InputStream containing the data.
     */
    public static InputStream get(String pageURL)
    {
	WebStream w = new WebStream();
	return w.getStream(pageURL);
    }

    public static void main(String [] args)
    {
	if(args.length > 0) {
	    InputStream stream = WebStream.get(args[0]);
	    if(stream != null)
		System.out.println("Success!");
	    else
		System.out.println("Failure.");
	}
	else {
	    System.err.println("Usage: java WebStream <url>");
	}
    }
}
