import java.sql.*;

class BatchStatement
{
    private static final int DEFAULT_MAX_BATCH_SIZE = 50;
    private Statement stmt;
    private int count;
    private int max_batch_size;
    
    public BatchStatement(Statement s)
    {
	stmt = s;
	count = 0;
	max_batch_size = DEFAULT_MAX_BATCH_SIZE;
    }

    public BatchStatement(Statement s, int max)
    {
	stmt = s;
	count = 0;
	max_batch_size = max;
    }

    public int batchSize() {
	return count;
    }

    public void addBatch(String s) throws SQLException
    {
	stmt.addBatch(s);
	count++;
	if(count > max_batch_size) {
	    executeBatch();
	}
    }
    
    public void executeBatch() throws SQLException
    {
	stmt.executeBatch();
	count = 0;
    }
}
