/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.table;

import com.sun.javafx.scene.control.skin.NestedTableColumnHeader;
import com.sun.javafx.scene.control.skin.TableColumnHeader;
import com.sun.javafx.scene.control.skin.TableViewSkin;
import impl.org.controlsfx.table.ColumnFilter;
import impl.org.controlsfx.table.MappedList;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.geometry.Insets;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;

public final class FilterPanel<T>
extends Pane {
    private final ColumnFilter<T> columnFilter;
    private final ListView<CheckItem> checkListView = new ListView();
    private final FilteredList<CheckItem> filterList;
    private static final String promptText = "Search...";
    private final TextField searchBox = new TextField();
    private volatile boolean searchMode = false;

    FilterPanel(ColumnFilter<T> columnFilter) {
        this.columnFilter = columnFilter;
        VBox vBox = new VBox();
        vBox.setPadding(new Insets(3.0));
        this.searchBox.setPromptText(promptText);
        this.searchBox.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        vBox.getChildren().add((Object)this.searchBox);
        Function<ColumnFilter.FilterValue, CheckItem> newCheckItemFx = v -> {
            CheckItem chkItem = new CheckItem((ColumnFilter.FilterValue)v);
            chkItem.checkBox.selectedProperty().setValue(Boolean.valueOf(true));
            return chkItem;
        };
        this.filterList = new FilteredList((ObservableList)new SortedList(new MappedList<CheckItem, ColumnFilter.FilterValue>((ObservableList<ColumnFilter.FilterValue>)new SortedList(this.columnFilter.getFilterValues(), (Comparator)new FilterValueComparator()), newCheckItemFx)), t -> true);
        this.checkListView.setItems(this.filterList);
        vBox.getChildren().add(this.checkListView);
        HBox bttnBox = new HBox();
        Button applyBttn = new Button("APPLY");
        HBox.setHgrow((Node)bttnBox, (Priority)Priority.ALWAYS);
        applyBttn.setOnAction(e -> {
            if (this.searchMode) {
                this.filterList.forEach(v -> ((CheckItem)v).filterValue.getSelectedProperty().setValue(Boolean.valueOf(true)));
                columnFilter.getFilterValues().stream().filter(v -> !this.filterList.stream().filter(fl -> ((CheckItem)fl).filterValue.equals(v)).findAny().isPresent()).forEach(v -> v.getSelectedProperty().setValue(Boolean.valueOf(false)));
                this.resetSearchFilter();
            }
            columnFilter.applyFilter();
        });
        bttnBox.getChildren().add((Object)applyBttn);
        Button clearButton = new Button("RESET");
        HBox.setHgrow((Node)clearButton, (Priority)Priority.ALWAYS);
        clearButton.setOnAction(e -> {
            columnFilter.resetAllFilters();
            this.filterList.setPredicate(v -> true);
        });
        bttnBox.getChildren().add((Object)clearButton);
        Button clearAllButton = new Button("RESET ALL");
        HBox.setHgrow((Node)clearAllButton, (Priority)Priority.ALWAYS);
        clearAllButton.setOnAction(e -> columnFilter.resetAllFilters());
        bttnBox.getChildren().add((Object)clearAllButton);
        vBox.getChildren().add((Object)bttnBox);
        this.getChildren().add((Object)vBox);
    }

    public void resetSearchFilter() {
        this.filterList.setPredicate(t -> true);
        this.searchBox.clear();
    }

    public static <T> CustomMenuItem getInMenuItem(ColumnFilter<T> columnFilter) {
        FilterPanel<T> filterPanel = new FilterPanel<T>(columnFilter);
        CustomMenuItem menuItem = new CustomMenuItem();
        super.initializeListeners();
        menuItem.contentProperty().set(filterPanel);
        columnFilter.getTableFilter().getTableView().skinProperty().addListener((w, o, n) -> {
            if (n instanceof TableViewSkin) {
                TableViewSkin skin = (TableViewSkin)n;
                FilterPanel.checkChangeContextMenu(skin, columnFilter.getTableColumn());
            }
        });
        menuItem.setHideOnClick(false);
        return menuItem;
    }

    private void initializeListeners() {
        this.searchBox.textProperty().addListener(l -> {
            this.searchMode = !this.searchBox.getText().isEmpty();
            this.filterList.setPredicate(val -> this.searchBox.getText().isEmpty() || ((CheckItem)val).filterValue.toString().contains(this.searchBox.getText()));
        });
    }

    private static void checkChangeContextMenu(TableViewSkin<?> skin, TableColumn<?, ?> column) {
        NestedTableColumnHeader header = skin.getTableHeaderRow().getRootHeader();
        header.getColumnHeaders().addListener(obs -> FilterPanel.changeContextMenu(header, column));
        FilterPanel.changeContextMenu(header, column);
    }

    private static void changeContextMenu(NestedTableColumnHeader header, TableColumn<?, ?> column) {
        TableColumnHeader headerSkin = FilterPanel.scan(column, (TableColumnHeader)header);
        if (headerSkin != null) {
            headerSkin.setOnContextMenuRequested(ev -> {
                ContextMenu cMenu = column.getContextMenu();
                if (cMenu != null) {
                    cMenu.show((Node)headerSkin, Side.BOTTOM, 5.0, 5.0);
                }
                ev.consume();
            });
        }
    }

    private static TableColumnHeader scan(TableColumn<?, ?> search, TableColumnHeader header) {
        if (search.equals((Object)header.getTableColumn())) {
            return header;
        }
        if (header instanceof NestedTableColumnHeader) {
            NestedTableColumnHeader parent = (NestedTableColumnHeader)header;
            for (int i = 0; i < parent.getColumnHeaders().size(); ++i) {
                TableColumnHeader result = FilterPanel.scan(search, (TableColumnHeader)parent.getColumnHeaders().get(i));
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private static final class FilterValueComparator
    implements Comparator<ColumnFilter.FilterValue> {
        private FilterValueComparator() {
        }

        @Override
        public int compare(ColumnFilter.FilterValue first, ColumnFilter.FilterValue second) {
            if (first.getInScopeProperty().get() && !second.getInScopeProperty().get()) {
                return 1;
            }
            int compare = first.getValueProperty().getValue().toString().compareTo(second.getValueProperty().getValue().toString());
            if (compare > 0) {
                return 1;
            }
            if (compare < 0) {
                return -1;
            }
            return 0;
        }
    }

    private static final class CheckItem
    extends HBox {
        private final CheckBox checkBox = new CheckBox();
        private final Label label = new Label();
        private final ColumnFilter.FilterValue filterValue;

        CheckItem(ColumnFilter.FilterValue filterValue) {
            this.filterValue = filterValue;
            this.label.setText((String)Optional.ofNullable(filterValue.getValueProperty()).map(ObservableValue::getValue).map(Object::toString).orElse(null));
            filterValue.getInScopeProperty().addListener(v -> this.label.textFillProperty().set((Object)(filterValue.getInScopeProperty().get() ? Color.BLACK : Color.LIGHTGRAY)));
            this.checkBox.selectedProperty().bindBidirectional((Property)filterValue.getSelectedProperty());
            this.getChildren().addAll((Object[])new Node[]{this.checkBox, this.label});
        }
    }
}

