/*
 * Decompiled with CFR 0.152.
 */
package org.loadui.testfx.utils;

import java.awt.MouseInfo;
import java.awt.Point;
import org.loadui.testfx.utils.FXTestUtils;

public class UserInputDetector
implements Runnable {
    public static final UserInputDetector instance = new UserInputDetector();
    private volatile boolean wasTilted = false;
    private volatile Thread testThread;
    private volatile Point lastPoint = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            UserInputDetector userInputDetector = this;
            synchronized (userInputDetector) {
                Point currentPoint = MouseInfo.getPointerInfo().getLocation();
                if (this.lastPoint != null) {
                    this.assertPointsAreEqual(currentPoint, this.lastPoint);
                }
                this.lastPoint = currentPoint;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void assertPointsAreEqual(Point p1, Point p2) {
        if (!UserInputDetector.equals(p1, p2, 3)) {
            this.userInputDetected();
        }
    }

    private static boolean equals(Point p1, Point p2, int errorMargin) {
        return Math.abs(p2.getX() - p1.getX()) < (double)errorMargin && Math.abs(p2.getY() - p1.getY()) < (double)errorMargin;
    }

    public synchronized void reset() {
        this.lastPoint = null;
    }

    private void userInputDetected() {
        System.out.println("[TestFX] User mouse movement detected. Aborting test.");
        this.wasTilted = true;
        this.testThread.stop();
        FXTestUtils.releaseButtons();
    }

    public void setTestThread(Thread testThread) {
        this.testThread = testThread;
    }

    public boolean hasDetectedUserInput() {
        return this.wasTilted;
    }

    static {
        Thread t = new Thread(instance);
        t.setDaemon(true);
        t.start();
    }
}

