/*
 * Decompiled with CFR 0.152.
 */
package sshpractice;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.OutputStream;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class UserAuthPubKey {
    public static void main(String[] arg) {
        try {
            JSch jsch = new JSch();
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Choose your privatekey(ex. ~/.ssh/id_dsa)");
            chooser.setFileHidingEnabled(false);
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                System.out.println("You chose " + chooser.getSelectedFile().getAbsolutePath() + ".");
                jsch.addIdentity(chooser.getSelectedFile().getAbsolutePath());
            }
            String host = null;
            host = arg.length > 0 ? arg[0] : JOptionPane.showInputDialog("Enter username@hostname", (Object)(System.getProperty("user.name") + "@localhost"));
            String user = host.substring(0, host.indexOf(64));
            host = host.substring(host.indexOf(64) + 1);
            Session session = jsch.getSession(user, host, 22);
            MyUserInfo ui = new MyUserInfo();
            session.setUserInfo((UserInfo)ui);
            session.connect();
            Channel channel = session.openChannel("shell");
            channel.setInputStream(System.in);
            channel.setOutputStream((OutputStream)System.out);
            channel.connect();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static class MyUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        String passphrase;
        JTextField passphraseField = new JPasswordField(20);
        final GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        private Container panel;

        public String getPassword() {
            return null;
        }

        public boolean promptYesNo(String str) {
            Object[] options = new Object[]{"yes", "no"};
            int foo = JOptionPane.showOptionDialog(null, str, "Warning", -1, 2, null, options, options[0]);
            return foo == 0;
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public boolean promptPassphrase(String message) {
            Object[] ob = new Object[]{this.passphraseField};
            int result = JOptionPane.showConfirmDialog(null, ob, message, 2);
            if (result == 0) {
                this.passphrase = this.passphraseField.getText();
                return true;
            }
            return false;
        }

        public boolean promptPassword(String message) {
            return true;
        }

        public void showMessage(String message) {
            JOptionPane.showMessageDialog(null, message);
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            this.panel = new JPanel();
            this.panel.setLayout(new GridBagLayout());
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbc.gridx = 0;
            this.panel.add((Component)new JLabel(instruction), this.gbc);
            ++this.gbc.gridy;
            this.gbc.gridwidth = -1;
            JTextField[] texts = new JTextField[prompt.length];
            for (int i = 0; i < prompt.length; ++i) {
                this.gbc.fill = 0;
                this.gbc.gridx = 0;
                this.gbc.weightx = 1.0;
                this.panel.add((Component)new JLabel(prompt[i]), this.gbc);
                this.gbc.gridx = 1;
                this.gbc.fill = 2;
                this.gbc.weighty = 1.0;
                texts[i] = echo[i] ? new JTextField(20) : new JPasswordField(20);
                this.panel.add((Component)texts[i], this.gbc);
                ++this.gbc.gridy;
            }
            if (JOptionPane.showConfirmDialog(null, this.panel, destination + ": " + name, 2, 3) == 0) {
                String[] response = new String[prompt.length];
                for (int i = 0; i < prompt.length; ++i) {
                    response[i] = texts[i].getText();
                }
                return response;
            }
            return null;
        }
    }
}

