/*
 * Decompiled with CFR 0.152.
 */
package elegit.treefx;

import elegit.Main;
import elegit.treefx.Cell;
import elegit.treefx.TreeGraph;
import elegit.treefx.TreeGraphModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import javafx.application.Platform;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;

public class TreeLayout {
    public static int H_SPACING = 30;
    public static int V_SPACING = 65;
    public static int H_PAD = 10;
    public static int V_PAD = 25;
    public static boolean movingCells;
    public static boolean commitSortTopological;

    public static Task getTreeLayoutTask(final TreeGraph g) {
        return new Task<Void>(){
            private List<Cell> allCells;
            private List<Integer> minRowUsedInCol;
            private List<Integer> movedCells;
            private boolean isInitialSetupFinished;

            protected Void call() throws Exception {
                try {
                    TreeGraphModel treeGraphModel = g.treeGraphModel;
                    this.isInitialSetupFinished = treeGraphModel.isInitialSetupFinished;
                    this.allCells = treeGraphModel.allCells;
                    if (commitSortTopological) {
                        TreeLayout.topologicalSortListOfCells(this.allCells);
                    } else {
                        TreeLayout.sortListOfCells(this.allCells);
                    }
                    this.minRowUsedInCol = new ArrayList<Integer>();
                    this.movedCells = new ArrayList<Integer>();
                    for (int i = this.allCells.size() - 1; i >= 0; --i) {
                        this.computeCellPosition(i);
                    }
                    MoveCellService mover = new MoveCellService(this.allCells);
                    Pane cellLayer = g.getCellLayerPane();
                    ScrollPane sp = g.getScrollPane();
                    SimpleDoubleProperty viewportY = new SimpleDoubleProperty(0.0);
                    SimpleDoubleProperty viewportX = new SimpleDoubleProperty(0.0);
                    ProgressBar progressBar = new ProgressBar();
                    Text loadingCommits = new Text("Loading commits ");
                    loadingCommits.setFont(new Font(14.0));
                    VBox loading = new VBox(new Node[]{loadingCommits, progressBar});
                    loading.setPickOnBounds(false);
                    loading.setAlignment(Pos.CENTER);
                    loading.setSpacing(5.0);
                    loading.layoutYProperty().bind((ObservableValue)viewportY);
                    loading.layoutXProperty().bind((ObservableValue)viewportX);
                    loading.setRotationAxis(Rotate.X_AXIS);
                    loading.setRotate(180.0);
                    if (Platform.isFxApplicationThread()) {
                        cellLayer.getChildren().add((Object)loading);
                    } else {
                        Platform.runLater(() -> cellLayer.getChildren().add((Object)loading));
                    }
                    sp.vvalueProperty().addListener((observable, oldValue, newValue) -> viewportY.set(cellLayer.getLayoutBounds().getHeight() - ((Double)newValue * cellLayer.getLayoutBounds().getHeight() + (0.5 - (Double)newValue) * sp.getViewportBounds().getHeight())));
                    sp.viewportBoundsProperty().addListener((observable, oldValue, newValue) -> {
                        viewportX.set(sp.getViewportBounds().getWidth() - loading.getWidth() - 35.0);
                        viewportY.set(cellLayer.getLayoutBounds().getHeight() - (sp.getVvalue() * cellLayer.getLayoutBounds().getHeight() + (0.5 - sp.getVvalue()) * sp.getViewportBounds().getHeight()));
                    });
                    mover.setOnSucceeded(event1 -> {
                        if (!Main.isAppClosed && movingCells && mover.currentCell < this.allCells.size() - 1) {
                            mover.setCurrentCell(mover.currentCell + 10);
                            progressBar.setProgress((double)mover.percent.get() / 100.0);
                            mover.restart();
                        } else {
                            treeGraphModel.isInitialSetupFinished = true;
                            loadingCommits.setVisible(false);
                            progressBar.setVisible(false);
                        }
                    });
                    mover.reset();
                    mover.start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }

            private void computeCellPosition(int cellPosition) {
                block1: {
                    Cell parent;
                    if (this.movedCells.contains(cellPosition)) {
                        return;
                    }
                    Cell c = this.allCells.get(this.allCells.size() - 1 - cellPosition);
                    this.setCellPosition(c, TreeLayout.getColumnOfCellInRow(this.minRowUsedInCol, cellPosition), cellPosition);
                    List<Cell> list = c.getCellParents();
                    list.sort((c1, c2) -> Long.compare(c1.getTime(), c2.getTime()));
                    Iterator<Cell> iterator = list.iterator();
                    if (!iterator.hasNext() || (parent = iterator.next()).getTime() > c.getTime() || this.allCells.indexOf((Object)parent) < 0) break block1;
                    this.computeCellPosition(this.allCells.size() - 1 - this.allCells.indexOf((Object)parent));
                }
            }

            private void setCellPosition(Cell c, int x, int y) {
                boolean willCellMove;
                int oldColumnLocation = c.columnLocationProperty.get();
                int oldRowLocation = c.rowLocationProperty.get();
                c.columnLocationProperty.set(x);
                c.rowLocationProperty.set(y);
                boolean hasCellMoved = oldColumnLocation >= 0 && oldRowLocation >= 0;
                boolean bl = willCellMove = oldColumnLocation != x || oldRowLocation != y;
                if (x >= this.minRowUsedInCol.size()) {
                    this.minRowUsedInCol.add(y);
                } else {
                    this.minRowUsedInCol.set(x, y);
                }
                c.setAnimate(this.isInitialSetupFinished && willCellMove);
                c.setUseParentAsSource(!hasCellMoved);
                this.movedCells.add(y);
            }
        };
    }

    public static void sortListOfCells(List<Cell> cellsToSort) {
        cellsToSort.sort((c1, c2) -> {
            int i = Long.compare(c2.getTime(), c1.getTime());
            if (i == 0) {
                if (c2.getCellChildren().contains(c1)) {
                    return -1;
                }
                if (c1.getCellChildren().contains(c2)) {
                    return 1;
                }
            }
            return i;
        });
    }

    public static void topologicalSortListOfCells(List<Cell> cellsToSort) {
        HashMap<String, Integer> visitCount = new HashMap<String, Integer>();
        Comparator comparator = (cell1, cell2) -> Long.valueOf(cell2.getTime()).compareTo(cell1.getTime());
        PriorityQueue<Cell> pq = new PriorityQueue<Cell>(10, comparator);
        for (Cell cell : cellsToSort) {
            if (cell.getCellChildren().size() != 0) continue;
            pq.add(cell);
        }
        int originalSize = cellsToSort.size();
        cellsToSort.clear();
        while (!pq.isEmpty()) {
            Cell current = (Cell)((Object)pq.poll());
            cellsToSort.add(current);
            for (Cell parent : current.getCellParents()) {
                String parentId = parent.getCellId();
                visitCount.put(parentId, 1 + visitCount.getOrDefault(parentId, 0));
                int maxPossibleVisits = parent.getCellChildren().size();
                if ((Integer)visitCount.get(parentId) != maxPossibleVisits) continue;
                pq.add(parent);
            }
        }
        assert (originalSize == cellsToSort.size());
    }

    private static int getColumnOfCellInRow(List<Integer> minRowUsedInCol, int cellRow) {
        int col;
        for (col = 0; minRowUsedInCol.size() > col && cellRow > minRowUsedInCol.get(col); ++col) {
        }
        return col;
    }

    public static void moveCell(final Cell c) {
        Platform.runLater((Runnable)new Task<Void>(){

            protected Void call() {
                boolean animate = c.getAnimate();
                boolean useParentPosAsSource = c.getUseParentAsSource();
                if (animate && useParentPosAsSource && c.getCellParents().size() > 0) {
                    double px = c.getCellParents().get((int)0).columnLocationProperty.get() * H_SPACING + H_PAD;
                    double py = c.getCellParents().get((int)0).rowLocationProperty.get() * V_SPACING + V_PAD;
                    c.moveTo(px, py, false, false);
                }
                double x = c.columnLocationProperty.get() * H_SPACING + H_PAD;
                double y = c.rowLocationProperty.get() * V_SPACING + V_PAD;
                c.moveTo(x, y, animate, animate && useParentPosAsSource);
                return null;
            }
        });
    }

    public static synchronized void stopMovingCells() {
        movingCells = false;
    }

    static {
        commitSortTopological = true;
    }

    public static class MoveCellService
    extends Service {
        private int currentCell;
        private int max;
        private List<Cell> allCellsSortedByTime;
        private IntegerProperty percent;

        public MoveCellService(List<Cell> allCellsSortedByTime) {
            this.allCellsSortedByTime = allCellsSortedByTime;
            this.max = allCellsSortedByTime.size() - 1;
            this.percent = new SimpleIntegerProperty(0);
            this.currentCell = 0;
            movingCells = true;
        }

        public void setCurrentCell(int currentCell) {
            this.currentCell = currentCell;
        }

        protected synchronized Task createTask() {
            return new Task(){

                protected Object call() throws Exception {
                    try {
                        for (int i = currentCell; i < currentCell + 10; ++i) {
                            if (i > allCellsSortedByTime.size() - 1) {
                                percent.set(100);
                                return null;
                            }
                            TreeLayout.moveCell((Cell)((Object)allCellsSortedByTime.get(i)));
                            if (!((double)i * 100.0 / (double)max > (double)percent.get()) || percent.get() >= 100) continue;
                            percent.set(i * 100 / max);
                        }
                        this.succeeded();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            };
        }
    }
}

