/*
 * Decompiled with CFR 0.152.
 */
package elegit.treefx;

import elegit.RefHelper;
import elegit.treefx.Cell;
import elegit.treefx.CellShape;
import elegit.treefx.Edge;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.control.ContextMenu;

public class TreeGraphModel {
    List<Cell> allCells;
    List<Cell> addedCells;
    List<Cell> removedCells;
    List<Edge> allEdges;
    List<Edge> addedEdges;
    List<Edge> removedEdges;
    public Map<String, Cell> cellMap;
    IntegerProperty numCellsProperty;
    public boolean isInitialSetupFinished;
    private List<Cell> cellsWithNonDefaultShapesOrLabels;

    public TreeGraphModel() {
        this.clear();
        this.numCellsProperty = new SimpleIntegerProperty();
        this.isInitialSetupFinished = false;
        this.cellsWithNonDefaultShapesOrLabels = new ArrayList<Cell>();
    }

    public void clear() {
        this.allCells = new ArrayList<Cell>();
        this.addedCells = new ArrayList<Cell>();
        this.removedCells = new ArrayList<Cell>();
        this.allEdges = new ArrayList<Edge>();
        this.addedEdges = new ArrayList<Edge>();
        this.removedEdges = new ArrayList<Edge>();
        this.cellMap = new HashMap<String, Cell>();
    }

    public List<String> getCellIDs() {
        return new ArrayList<String>(this.cellMap.keySet());
    }

    public boolean containsID(String id) {
        return this.cellMap.containsKey(id);
    }

    public List<Cell> getAddedCells() {
        return this.addedCells;
    }

    public List<Cell> getRemovedCells() {
        return this.removedCells;
    }

    public List<Edge> getAddedEdges() {
        return this.addedEdges;
    }

    public List<Edge> getRemovedEdges() {
        ArrayList<String> removedMap = new ArrayList<String>();
        for (Cell c : this.removedCells) {
            removedMap.add(c.getCellId());
        }
        ArrayList<Edge> oldRemoved = new ArrayList<Edge>();
        for (Edge e : this.removedEdges) {
            oldRemoved.add(e);
        }
        for (Edge e : oldRemoved) {
            if (!this.cellMap.containsKey(e.getSource().getCellId()) || !removedMap.contains(e.getSource().getCellId()) || !this.cellMap.containsKey(e.getTarget().getCellId()) || removedMap.contains(e.getTarget().getCellId())) continue;
            this.addEdge(e.getSource().getCellId(), e.getTarget().getCellId());
        }
        return this.removedEdges;
    }

    public void addCell(String newId, long time, String displayLabel, List<RefHelper> refs, ContextMenu contextMenu, List<String> parentIds, Cell.CellType type) {
        Cell cell;
        ArrayList<Cell> parents = new ArrayList<Cell>();
        for (String parentId : parentIds) {
            parents.add(this.cellMap.get(parentId));
        }
        switch (type) {
            case LOCAL: {
                cell = new Cell(newId, time, parents, Cell.CellType.LOCAL);
                break;
            }
            case REMOTE: {
                cell = new Cell(newId, time, parents, Cell.CellType.REMOTE);
                break;
            }
            default: {
                cell = new Cell(newId, time, parents, Cell.CellType.BOTH);
            }
        }
        this.setCellLabels(cell, displayLabel, refs);
        cell.setContextMenu(contextMenu);
        this.addCell(cell);
        for (String parentId : parentIds) {
            this.addEdge(parentId, newId);
        }
    }

    private void addCell(Cell cell) {
        if (this.cellMap.containsKey(cell.getCellId())) {
            Cell oldCell = this.cellMap.remove(cell.getCellId());
            for (Cell p : cell.getCellParents()) {
                p.removeCellChild(oldCell);
            }
            this.removedCells.add(oldCell);
            this.removeEdges(oldCell);
        }
        this.addedCells.add(cell);
        this.cellMap.put(cell.getCellId(), cell);
    }

    public void addEdge(String sourceId, String targetId) {
        Cell sourceCell = this.cellMap.get(sourceId);
        Cell targetCell = this.cellMap.get(targetId);
        this.addEdge(sourceCell, targetCell);
    }

    public void addEdge(Cell source, Cell target) {
        Edge edge = new Edge(source, target);
        source.edges.add(edge);
        target.edges.add(edge);
        this.addedEdges.add(edge);
    }

    public void removeCell(String id) {
        Cell cell = this.cellMap.get(id);
        if (cell != null && this.cellMap.containsKey(cell.getCellId())) {
            Cell oldCell = this.cellMap.remove(cell.getCellId());
            for (Cell p : cell.getCellParents()) {
                p.removeCellChild(oldCell);
            }
            this.removedCells.add(oldCell);
            this.removeEdges(oldCell);
        }
    }

    private void removeEdges(Cell cell) {
        ArrayList<Edge> oldEdges = new ArrayList<Edge>();
        for (Edge e : cell.edges) {
            oldEdges.add(e);
        }
        for (Edge e : oldEdges) {
            this.removedEdges.add(e);
            e.getTarget().edges.remove((Object)e);
            e.getSource().edges.remove((Object)e);
        }
    }

    public void setCellLabels(String cellId, String label, List<RefHelper> refs) {
        this.setCellLabels(this.cellMap.get(cellId), label, refs);
    }

    private void setCellLabels(Cell cell, String label, List<RefHelper> refs) {
        cell.setLabels(label, refs);
        if (refs.size() > 0) {
            this.cellsWithNonDefaultShapesOrLabels.add(cell);
        }
    }

    public void setCurrentCellLabels(String cellId, List<String> refs) {
        this.setCurrentCellLabels(this.cellMap.get(cellId), refs);
    }

    public void setCurrentCellLabels(Cell cell, List<String> refs) {
        cell.setCurrentLabels(refs);
    }

    public void setLabelMenus(String cellId, Map<RefHelper, ContextMenu> menuMap) {
        this.cellMap.get(cellId).setLabelMenus(menuMap);
    }

    public void setRemoteBranchCells(String cellId, List<String> remoteBranches) {
        this.cellMap.get(cellId).setRemoteLabels(remoteBranches);
    }

    public void setCellShape(String cellId, CellShape shape) {
        Cell cell = this.cellMap.get(cellId);
        cell.setShape(shape);
        this.cellsWithNonDefaultShapesOrLabels.add(cell);
    }

    public void setCellType(String cellId, Cell.CellType type) {
        Cell cell = this.cellMap.get(cellId);
        if (cell == null) {
            return;
        }
        cell.setCellType(type);
        if (type != Cell.CellType.BOTH) {
            this.cellsWithNonDefaultShapesOrLabels.add(cell);
        }
    }

    public List<String> resetCellShapes() {
        ArrayList<String> resetIDs = new ArrayList<String>();
        for (Cell cell : this.cellsWithNonDefaultShapesOrLabels) {
            cell.setShape(Cell.DEFAULT_SHAPE);
            String id = cell.getCellId();
            if (resetIDs.contains(id) || !this.allCells.contains((Object)cell)) continue;
            resetIDs.add(id);
        }
        this.cellsWithNonDefaultShapesOrLabels = new ArrayList<Cell>();
        return resetIDs;
    }

    public boolean isNeighbor(String cellID, String neighborID) {
        List<Cell> relatives = this.getRelatives(cellID);
        for (Cell c : relatives) {
            if (!c.getCellId().equals(neighborID)) continue;
            return true;
        }
        return false;
    }

    public List<Cell> getRelatives(String cellID) {
        Cell cell = this.cellMap.get(cellID);
        if (cell == null) {
            return new ArrayList<Cell>();
        }
        List<Cell> relatives = cell.getCellParents();
        relatives.addAll(cell.getCellChildren());
        return relatives;
    }

    public void merge() {
        this.allCells.addAll(this.addedCells);
        this.allCells.removeAll(this.removedCells);
        this.addedCells.clear();
        this.removedCells.clear();
        this.allEdges.addAll(this.addedEdges);
        this.allEdges.removeAll(this.removedEdges);
        this.addedEdges.clear();
        this.removedEdges.clear();
        this.numCellsProperty.set(this.allCells.size());
    }
}

