/*
 * Decompiled with CFR 0.152.
 */
package elegit.treefx;

import elegit.treefx.Cell;
import elegit.treefx.CommitTreeScrollPane;
import elegit.treefx.TreeGraphModel;
import elegit.treefx.TreeLayout;
import java.util.LinkedList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Pane;
import javafx.scene.transform.Rotate;

public class TreeGraph {
    private CommitTreeScrollPane scrollPane;
    public TreeGraphModel treeGraphModel;
    private Pane cellLayer;
    private volatile List<Node> queuedToAdd;
    private volatile List<Node> queuedToRemove;

    public TreeGraph(TreeGraphModel m) {
        this.treeGraphModel = m;
        this.cellLayer = new Pane();
        this.cellLayer.setRotationAxis(Rotate.X_AXIS);
        this.cellLayer.setRotate(180.0);
        this.cellLayer.setPadding(new Insets(0.0, 0.0, (double)(20 + TreeLayout.V_PAD), 0.0));
        this.cellLayer.boundsInLocalProperty().addListener((observable, oldValue, newValue) -> this.cellLayer.setMinWidth(newValue.getMaxX()));
        this.scrollPane = new CommitTreeScrollPane((Node)this.cellLayer);
        this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.scrollPane.NumItemsProperty.bind((ObservableValue)m.numCellsProperty);
        this.queuedToAdd = new LinkedList<Node>();
        this.queuedToRemove = new LinkedList<Node>();
    }

    public ScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public synchronized void update() {
        this.queuedToRemove.addAll(this.treeGraphModel.getRemovedCells());
        this.queuedToRemove.addAll(this.treeGraphModel.getRemovedEdges());
        this.queuedToAdd.addAll(this.treeGraphModel.getAddedCells());
        this.queuedToAdd.addAll(this.treeGraphModel.getAddedEdges());
        this.treeGraphModel.merge();
        Platform.runLater(() -> {
            LinkedList<Node> moreToAdd = new LinkedList<Node>();
            LinkedList<Node> moreToRemove = new LinkedList<Node>();
            for (Node n : this.queuedToAdd) {
                if (!(n instanceof Cell)) continue;
                moreToAdd.add(((Cell)n).getLabel());
            }
            this.cellLayer.getChildren().addAll(this.queuedToAdd);
            this.cellLayer.getChildren().addAll(moreToAdd);
            for (Node n : this.queuedToRemove) {
                if (!(n instanceof Cell)) continue;
                moreToRemove.add(((Cell)n).getLabel());
            }
            this.cellLayer.getChildren().removeAll(moreToRemove);
            this.cellLayer.getChildren().removeAll(this.queuedToRemove);
            this.queuedToAdd = new LinkedList<Node>();
            this.queuedToRemove = new LinkedList<Node>();
        });
    }

    Pane getCellLayerPane() {
        return this.cellLayer;
    }
}

