/*
 * Decompiled with CFR 0.152.
 */
package elegit.treefx;

import elegit.treefx.Cell;
import elegit.treefx.CellState;
import elegit.treefx.CommitTreeScrollPane;
import elegit.treefx.Edge;
import elegit.treefx.TreeGraphModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.animation.ScaleTransition;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.shape.Shape;
import javafx.util.Duration;

public class Highlighter {
    private static final List<String> blockedCellIDs = new ArrayList<String>();
    private static final Map<Cell, CellState> cellStates = new HashMap<Cell, CellState>();

    public static void highlightSelectedCell(String cellID, TreeGraphModel model, boolean enable, boolean ancestors, boolean descendants, boolean allGenerations) {
        Cell cell = model.cellMap.get(cellID);
        if (cell == null) {
            return;
        }
        if (enable) {
            Highlighter.highlightCell(cell, CellState.SELECTED, true);
            if (ancestors) {
                Highlighter.highlightCellParents(cell, CellState.HIGHLIGHTED1, allGenerations, new ArrayList<Cell>());
            }
            if (descendants) {
                Highlighter.highlightCellChildren(cell, CellState.HIGHLIGHTED1, allGenerations, new ArrayList<Cell>());
            }
        } else {
            Highlighter.highlightCell(cell, CellState.STANDARD, true);
            if (ancestors) {
                Highlighter.highlightCellParents(cell, CellState.STANDARD, allGenerations, new ArrayList<Cell>());
            }
            if (descendants) {
                Highlighter.highlightCellChildren(cell, CellState.STANDARD, allGenerations, new ArrayList<Cell>());
            }
        }
    }

    private static void highlightCellParents(Cell cell, CellState state, boolean recurse, List<Cell> visited) {
        for (Cell parent : cell.getCellParents()) {
            if (visited.contains((Object)parent)) continue;
            visited.add(parent);
            Highlighter.highlightCell(parent, state, true);
            if (!recurse) continue;
            Highlighter.highlightCellParents(parent, state, true, visited);
        }
    }

    private static void highlightCellChildren(Cell cell, CellState state, boolean recurse, List<Cell> visited) {
        for (Cell child : cell.getCellChildren()) {
            if (visited.contains((Object)child)) continue;
            visited.add(child);
            Highlighter.highlightCell(child, state, true);
            if (!recurse) continue;
            Highlighter.highlightCellChildren(child, state, true, visited);
        }
    }

    public static void updateCellEdges(String cellID, String selectedCellID, TreeGraphModel model, boolean enable) {
        Cell cell = model.cellMap.get(cellID);
        if (cell == null) {
            return;
        }
        Cell selectedCell = model.cellMap.get(selectedCellID);
        ArrayList<Edge> list = new ArrayList<Edge>(cell.edges);
        if (!enable && selectedCellID != null) {
            for (Edge e : selectedCell.edges) {
                list.remove((Object)e);
            }
        }
        for (Edge e : list) {
            e.setHighlighted(enable);
        }
    }

    public static void highlightCell(String cellID, String selectedCellID, TreeGraphModel model, boolean enable) {
        Cell cell = model.cellMap.get(cellID);
        if (cell == null) {
            return;
        }
        CellState state = enable ? (selectedCellID == null ? CellState.HIGHLIGHTED1 : CellState.HIGHLIGHTED2) : CellState.STANDARD;
        if (!cellID.equals(selectedCellID)) {
            Highlighter.highlightCell(cell, state, false);
        }
    }

    private static void highlightAllCells(List<Cell> cells, CellState state) {
        for (Cell cell : cells) {
            Highlighter.highlightCell(cell, state, true);
        }
    }

    private static void highlightCell(Cell cell, CellState state, boolean persistent) {
        if (persistent) {
            cellStates.put(cell, state);
        }
        if (blockedCellIDs.contains(cell.getCellId())) {
            return;
        }
        if (state == CellState.STANDARD && cellStates.containsKey((Object)cell)) {
            cell.setCellState(cellStates.get((Object)cell));
            return;
        }
        cell.setCellState(state);
    }

    public static void resetAll() {
        for (Cell cell : cellStates.keySet()) {
            cell.setCellState(CellState.STANDARD);
        }
        cellStates.clear();
    }

    public static void resetCell(Cell cell) {
        cell.setCellState(CellState.STANDARD);
        cellStates.remove((Object)cell);
    }

    public static void emphasizeCell(Cell c) {
        if (!blockedCellIDs.contains(c.getCellId())) {
            blockedCellIDs.add(c.getCellId());
        }
        Platform.runLater(() -> {
            CommitTreeScrollPane.scrollTo(c.rowLocationProperty.doubleValue());
            c.setCellState(CellState.EMPHASIZED);
            Shape s = (Shape)c.view;
            ScaleTransition sct = new ScaleTransition(Duration.millis((double)425.0), (Node)s);
            sct.setByX((double)0.3f);
            sct.setByY((double)0.3f);
            sct.setCycleCount(6);
            sct.setAutoReverse(true);
            c.view.setScaleX(1.0);
            c.view.setScaleY(1.0);
            sct.play();
            sct.setOnFinished(event -> Highlighter.endEmphasisOnCell(c));
        });
    }

    private static void endEmphasisOnCell(Cell c) {
        blockedCellIDs.remove(c.getCellId());
        Highlighter.highlightCell(c, cellStates.getOrDefault((Object)c, CellState.STANDARD), true);
    }
}

