/*
 * Decompiled with CFR 0.152.
 */
package elegit.treefx;

import elegit.treefx.Cell;
import elegit.treefx.DirectedPath;
import elegit.treefx.TreeLayout;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.When;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;

public class Edge
extends Group {
    public static BooleanProperty allVisible = new SimpleBooleanProperty(true);
    private BooleanProperty visible;
    private Cell source;
    private Cell target;
    private DirectedPath path;
    private boolean addedMidPoints;
    private DoubleProperty midLineX;

    public Edge(Cell source, Cell target) {
        this.source = source;
        this.target = target;
        this.addedMidPoints = false;
        this.midLineX = new SimpleDoubleProperty(0.0);
        DoubleBinding endX = source.translateXProperty().add((ObservableNumberValue)source.widthProperty().divide(2.0));
        DoubleBinding endY = source.translateYProperty().add((ObservableNumberValue)source.heightProperty());
        DoubleBinding startX = target.translateXProperty().add((ObservableNumberValue)target.widthProperty().divide(2.0));
        DoubleBinding startY = target.translateYProperty().add(0);
        this.path = new DirectedPath(startX, startY, endX, endY);
        this.checkAndAddMidPoints(startY, endY);
        this.path.addPoint(endX, endY.add((double)TreeLayout.V_SPACING / 4.0));
        source.translateXProperty().addListener((observable, oldValue, newValue) -> this.checkAndAddMidPoints(startY, endY));
        target.translateYProperty().addListener((observable, oldValue, newValue) -> this.checkAndAddMidPoints(startY, endY));
        source.translateXProperty().addListener((observable, oldValue, newValue) -> this.checkAndAddMidPoints(startY, endY));
        target.translateYProperty().addListener((observable, oldValue, newValue) -> this.checkAndAddMidPoints(startY, endY));
        this.midLineX.bind((ObservableValue)new When((ObservableBooleanValue)target.rowLocationProperty.subtract((ObservableNumberValue)source.rowLocationProperty).lessThan(0)).then((ObservableNumberValue)new When((ObservableBooleanValue)target.columnLocationProperty.subtract((ObservableNumberValue)source.columnLocationProperty).greaterThan(0)).then((ObservableNumberValue)endX.add((double)TreeLayout.H_SPACING / 2.0)).otherwise((ObservableNumberValue)new When((ObservableBooleanValue)target.columnLocationProperty.subtract((ObservableNumberValue)source.columnLocationProperty).lessThan(0)).then((ObservableNumberValue)startX.add((double)TreeLayout.H_SPACING / 2.0)).otherwise((ObservableNumberValue)startX))).otherwise((ObservableNumberValue)new When((ObservableBooleanValue)target.columnLocationProperty.subtract((ObservableNumberValue)source.columnLocationProperty).greaterThan(0)).then((ObservableNumberValue)endX.add((double)TreeLayout.H_SPACING / 2.0)).otherwise((ObservableNumberValue)new When((ObservableBooleanValue)target.columnLocationProperty.subtract((ObservableNumberValue)source.columnLocationProperty).lessThan(0)).then((ObservableNumberValue)startX.add((double)TreeLayout.H_SPACING / 2.0)).otherwise((ObservableNumberValue)startX))));
        if (source.getCellType() != Cell.CellType.BOTH || target.getCellType() != Cell.CellType.BOTH) {
            this.path.setDashed(true);
        }
        this.getChildren().add((Object)this.path);
        this.visible = new SimpleBooleanProperty(false);
        this.visibleProperty().bind((ObservableValue)source.visibleProperty().and((ObservableBooleanValue)target.visibleProperty()).and((ObservableBooleanValue)allVisible.or((ObservableBooleanValue)this.visible)));
        source.edges.add(this);
        target.edges.add(this);
    }

    private void checkAndAddMidPoints(DoubleBinding startY, DoubleBinding endY) {
        if (this.target.rowLocationProperty.get() - this.source.rowLocationProperty.get() > 1 || this.target.rowLocationProperty.get() - this.source.rowLocationProperty.get() < 0) {
            if (!this.addedMidPoints) {
                this.path.addPoint(this.midLineX.add(0), startY.subtract((double)TreeLayout.V_SPACING / 3.0), 1);
                this.path.addPoint(this.midLineX.add(0), endY.add((double)TreeLayout.V_SPACING / 2.0), 2);
                this.addedMidPoints = true;
            }
        } else if (this.addedMidPoints) {
            this.path.removePoint(2);
            this.path.removePoint(1);
            this.addedMidPoints = false;
        }
    }

    public void setHighlighted(boolean enable) {
        this.visible.set(enable);
    }

    public Cell getSource() {
        return this.source;
    }

    public Cell getTarget() {
        return this.target;
    }

    public void resetDashed() {
        if (this.source.getCellType() != Cell.CellType.BOTH || this.target.getCellType() != Cell.CellType.BOTH) {
            this.path.setDashed(true);
        } else {
            this.path.setDashed(false);
        }
    }
}

