/*
 * Decompiled with CFR 0.152.
 */
package elegit.treefx;

import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;

public class DirectedPath
extends Group {
    public static final IntegerProperty ARROW_LENGTH = new SimpleIntegerProperty(6);
    Path arrow;
    Path path = new Path();

    public DirectedPath(DoubleBinding startX, DoubleBinding startY, DoubleBinding endX, DoubleBinding endY) {
        MoveTo start = new MoveTo();
        start.xProperty().bind((ObservableValue)startX);
        start.yProperty().bind((ObservableValue)startY);
        LineTo end = new LineTo();
        end.xProperty().bind((ObservableValue)endX);
        end.yProperty().bind((ObservableValue)endY);
        this.path.getElements().add((Object)start);
        this.path.getElements().add((Object)end);
        this.arrow = this.getArrow();
        this.getChildren().add((Object)this.path);
        this.getChildren().add((Object)this.arrow);
        this.path.getStyleClass().setAll((Object[])new String[]{"edge"});
    }

    public void setDashed(boolean isDashed) {
        if (isDashed) {
            this.path.getStyleClass().setAll((Object[])new String[]{"edge", "invisEdge"});
        } else {
            this.path.getStyleClass().setAll((Object[])new String[]{"edge"});
        }
    }

    public void addPoint(DoubleBinding newX, DoubleBinding newY, int index) {
        this.getChildren().remove((Object)this.path);
        this.getChildren().remove((Object)this.arrow);
        LineTo newLine = new LineTo();
        newLine.xProperty().bind((ObservableValue)newX);
        newLine.yProperty().bind((ObservableValue)newY);
        this.path.getElements().add(index, (Object)newLine);
        this.arrow = this.getArrow();
        this.getChildren().add((Object)this.path);
        this.getChildren().add((Object)this.arrow);
    }

    public void addPoint(DoubleBinding newX, DoubleBinding newY) {
        this.addPoint(newX, newY, this.path.getElements().size() - 1);
    }

    public void removePoint(int index) {
        this.getChildren().remove((Object)this.path);
        this.getChildren().remove((Object)this.arrow);
        this.path.getElements().remove(index);
        this.getChildren().add((Object)this.path);
        this.getChildren().add((Object)this.arrow);
    }

    private Path getArrow() {
        DoubleBinding buttY;
        DoubleBinding buttX;
        ObservableList list = this.path.getElements();
        DoubleBinding tipX = ((LineTo)list.get(list.size() - 1)).xProperty().add(0);
        DoubleBinding tipY = ((LineTo)list.get(list.size() - 1)).yProperty().add(0);
        if (list.size() > 2) {
            buttX = ((LineTo)list.get(list.size() - 2)).xProperty().add(0);
            buttY = ((LineTo)list.get(list.size() - 2)).yProperty().add(0);
        } else {
            buttX = ((MoveTo)list.get(list.size() - 2)).xProperty().add(0);
            buttY = ((MoveTo)list.get(list.size() - 2)).yProperty().add(0);
        }
        SimpleDoubleProperty rise = new SimpleDoubleProperty();
        SimpleDoubleProperty run = new SimpleDoubleProperty();
        rise.bind((ObservableValue)tipY.subtract((ObservableNumberValue)buttY));
        run.bind((ObservableValue)tipX.subtract((ObservableNumberValue)buttX));
        MoveTo left = new MoveTo();
        left.xProperty().bind((ObservableValue)tipX.add((ObservableNumberValue)new CosBinding(new ArcTanBinding((DoubleProperty)rise, (DoubleProperty)run).add(3.9269908169872414)).multiply((ObservableNumberValue)ARROW_LENGTH)));
        left.yProperty().bind((ObservableValue)tipY.add((ObservableNumberValue)new SinBinding(new ArcTanBinding((DoubleProperty)rise, (DoubleProperty)run).add(3.9269908169872414)).multiply((ObservableNumberValue)ARROW_LENGTH)));
        LineTo tip = new LineTo();
        tip.xProperty().bind((ObservableValue)tipX);
        tip.yProperty().bind((ObservableValue)tipY);
        LineTo right = new LineTo();
        right.xProperty().bind((ObservableValue)tipX.add((ObservableNumberValue)new CosBinding(new ArcTanBinding((DoubleProperty)rise, (DoubleProperty)run).add(2.356194490192345)).multiply((ObservableNumberValue)ARROW_LENGTH)));
        right.yProperty().bind((ObservableValue)tipY.add((ObservableNumberValue)new SinBinding(new ArcTanBinding((DoubleProperty)rise, (DoubleProperty)run).add(2.356194490192345)).multiply((ObservableNumberValue)ARROW_LENGTH)));
        Path temp = new Path();
        temp.getElements().add((Object)left);
        temp.getElements().add((Object)tip);
        temp.getElements().add((Object)right);
        temp.getStyleClass().setAll((Object[])new String[]{"edge"});
        return temp;
    }

    private class CosBinding
    extends DoubleBinding {
        private final DoubleBinding theta;

        public CosBinding(DoubleBinding theta) {
            this.theta = theta;
            super.bind(new Observable[]{this.theta});
        }

        protected double computeValue() {
            return Math.cos(this.theta.get());
        }
    }

    private class SinBinding
    extends DoubleBinding {
        private final DoubleBinding theta;

        public SinBinding(DoubleBinding theta) {
            this.theta = theta;
            super.bind(new Observable[]{this.theta});
        }

        protected double computeValue() {
            return Math.sin(this.theta.get());
        }
    }

    private class ArcTanBinding
    extends DoubleBinding {
        private final DoubleProperty x;
        private final DoubleProperty y;

        public ArcTanBinding(DoubleProperty x, DoubleProperty y) {
            this.x = x;
            this.y = y;
            super.bind(new Observable[]{this.x});
            super.bind(new Observable[]{this.y});
        }

        protected double computeValue() {
            return Math.atan2(this.x.get(), this.y.get());
        }
    }
}

