/*
 * Decompiled with CFR 0.152.
 */
package elegit.treefx;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;

public class CommitTreeScrollPane
extends ScrollPane {
    private static final double DEFAULT_SCROLL_POS = 1.0;
    public final IntegerProperty NumItemsProperty = new SimpleIntegerProperty(1);
    private static int numItems = 1;
    private static final DoubleProperty vPos = new SimpleDoubleProperty(-1.0);

    public CommitTreeScrollPane(Node node) {
        super(node);
        vPos.addListener((observable, oldValue, newValue) -> {
            if (newValue.doubleValue() != -1.0) {
                double value = newValue.doubleValue() > 1.0 ? 1.0 : newValue.doubleValue();
                for (int i = 0; i < 3; ++i) {
                    this.vvalueProperty().setValue((Number)value);
                }
            }
        });
        this.NumItemsProperty.addListener((observable, oldValue, newValue) -> {
            numItems = newValue.intValue();
        });
    }

    public static void scrollTo(double pos) {
        if (pos < 0.0 || pos > (double)numItems) {
            vPos.setValue((Number)1.0);
        } else {
            double ratio = pos / (double)numItems;
            double offset = ratio >= 0.5 ? 1.0 / (double)numItems : -1.0 / (double)numItems;
            vPos.set(1.0 - (ratio + offset));
        }
        vPos.setValue((Number)-1.0);
    }
}

