/*
 * Decompiled with CFR 0.152.
 */
package elegit.treefx;

import elegit.treefx.Cell;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;

public enum CellShape {
    SQUARE,
    CIRCLE,
    TRIANGLE_UP,
    TRIANGLE_DOWN,
    TRIANGLE_RIGHT,
    TRIANGLE_LEFT;


    public Shape getType(Cell.CellType type) {
        Shape toReturn;
        switch (type) {
            case LOCAL: {
                toReturn = this.get();
                break;
            }
            case REMOTE: {
                toReturn = this.get();
                break;
            }
            case BOTH: {
                toReturn = Shape.union((Shape)this.getInside(2), (Shape)Shape.subtract((Shape)this.get(), (Shape)this.getInside(1)));
                break;
            }
            default: {
                toReturn = null;
            }
        }
        return toReturn;
    }

    public Shape get() {
        switch (this) {
            case CIRCLE: {
                return new Circle(10.0, 10.0, 10.0);
            }
            case TRIANGLE_UP: {
                return new Polygon(new double[]{0.0, 20.0, 20.0, 20.0, 10.0, 0.0});
            }
            case TRIANGLE_DOWN: {
                return new Polygon(new double[]{0.0, 0.0, 20.0, 0.0, 10.0, 20.0});
            }
            case TRIANGLE_RIGHT: {
                return new Polygon(new double[]{0.0, 0.0, 20.0, 10.0, 0.0, 20.0});
            }
            case TRIANGLE_LEFT: {
                return new Polygon(new double[]{0.0, 10.0, 20.0, 0.0, 20.0, 20.0});
            }
        }
        return new Rectangle(20.0, 20.0);
    }

    public Shape getInside(int inset) {
        int extraInset = inset;
        if (inset == 2) {
            ++extraInset;
        }
        switch (this) {
            case CIRCLE: {
                return new Circle(10.0, 10.0, 10.0 - (double)inset);
            }
            case TRIANGLE_UP: {
                return new Polygon(new double[]{extraInset, 20 - inset, 20 - extraInset, 20 - inset, 10.0, extraInset + 1});
            }
            case TRIANGLE_DOWN: {
                return new Polygon(new double[]{extraInset, inset, 20 - extraInset, inset, 10.0, 20 - extraInset});
            }
            case TRIANGLE_RIGHT: {
                return new Polygon(new double[]{inset, extraInset, 20 - extraInset, 10.0, inset, 20 - extraInset});
            }
            case TRIANGLE_LEFT: {
                return new Polygon(new double[]{extraInset, 10.0, 20 - inset, extraInset, 20 - inset, 20 - extraInset});
            }
        }
        return new Rectangle((double)inset, (double)inset, (double)(20 - 2 * inset), (double)(20 - 2 * inset));
    }
}

