/*
 * Decompiled with CFR 0.152.
 */
package elegit.treefx;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.GlyphsDude;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import elegit.RefHelper;
import elegit.TagHelper;
import elegit.treefx.BranchCellLabel;
import elegit.treefx.Cell;
import elegit.treefx.CellLabel;
import elegit.treefx.TagCellLabel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;

public class CellLabelContainer
extends GridPane {
    private final int MAX_COL_PER_ROW = 4;
    HBox basicLabels;
    List<HBox> extendedLabels;

    public void translate(double x, double y) {
        this.setTranslateX(x + 20.0 + 10.0);
        this.setTranslateY(y + 20.0 - 5.0 - (this.getHeight() - 25.0));
    }

    void addToolTip(Label l, String text) {
        Tooltip tooltip = new Tooltip(text);
        tooltip.setWrapText(true);
        tooltip.setMaxWidth(350.0);
        Tooltip.install((Node)l, (Tooltip)tooltip);
    }

    void setLabels(List<RefHelper> refHelpers, Cell cell) {
        Platform.runLater(() -> {
            this.getChildren().clear();
            if (refHelpers.size() < 1) {
                return;
            }
            Label showExtended = new Label();
            this.basicLabels = new HBox(5.0);
            this.extendedLabels = new ArrayList<HBox>();
            int col = 0;
            int row = 0;
            GridPane.setMargin((Node)this.basicLabels, (Insets)new Insets(0.0, 0.0, 5.0, 5.0));
            this.basicLabels.setPickOnBounds(false);
            for (RefHelper helper : refHelpers) {
                if (col > 4) {
                    col = 0;
                    HBox newLine = new HBox(5.0);
                    GridPane.setMargin((Node)newLine, (Insets)new Insets(0.0, 0.0, 5.0, 5.0));
                    GridPane.setRowIndex((Node)newLine, (Integer)(++row));
                    newLine.setVisible(false);
                    newLine.setPickOnBounds(false);
                    this.extendedLabels.add(newLine);
                }
                CellLabel label = helper instanceof TagHelper ? new TagCellLabel(helper, false) : new BranchCellLabel(helper, false);
                if (row > 0) {
                    this.extendedLabels.get(row - 1).getChildren().add((Object)label);
                } else {
                    this.basicLabels.getChildren().add((Object)label);
                }
                ++col;
            }
            showExtended.setVisible(false);
            if (row > 0) {
                showExtended.setVisible(true);
                showExtended.setTranslateX(-6.0);
                showExtended.setTranslateY(-3.0);
                Text down = GlyphsDude.createIcon((GlyphIcons)FontAwesomeIcon.CARET_DOWN);
                Text up = GlyphsDude.createIcon((GlyphIcons)FontAwesomeIcon.CARET_UP);
                showExtended.setGraphic((Node)down);
                showExtended.setOnMouseClicked(arg_0 -> this.lambda$null$0(showExtended, (Node)down, (Node)up, arg_0));
            }
            this.setMaxHeight(20.0);
            this.setRotationAxis(Rotate.X_AXIS);
            this.setRotate(180.0);
            this.visibleProperty().bind((ObservableValue)cell.visibleProperty());
            this.getChildren().clear();
            this.getChildren().addAll((Object[])new Node[]{this.basicLabels});
            this.getChildren().addAll(this.extendedLabels);
            this.getChildren().add((Object)showExtended);
        });
        this.setPickOnBounds(false);
    }

    void setCurrentLabels(List<String> labels) {
        Platform.runLater(() -> {
            for (Node m : this.getChildren()) {
                if (!(m instanceof HBox)) continue;
                for (Node n : ((HBox)m).getChildren()) {
                    if (!(n instanceof CellLabel) || !labels.contains(((CellLabel)n).getLabel().getText())) continue;
                    ((CellLabel)n).setCurrent(true);
                }
            }
        });
    }

    void setLabelMenus(Map<RefHelper, ContextMenu> menuMap) {
        Platform.runLater(() -> {
            for (Node m : this.getChildren()) {
                if (!(m instanceof HBox)) continue;
                for (Node n : ((HBox)m).getChildren()) {
                    if (!(n instanceof CellLabel) || !menuMap.keySet().contains(((CellLabel)n).getRefHelper())) continue;
                    ((CellLabel)n).setContextMenu((ContextMenu)menuMap.get(((CellLabel)n).getRefHelper()));
                }
            }
        });
    }

    void setRemoteLabels(List<String> labels) {
        Platform.runLater(() -> {
            for (Node m : this.getChildren()) {
                if (!(m instanceof HBox)) continue;
                for (Node n : ((HBox)m).getChildren()) {
                    if (!(n instanceof CellLabel) || !labels.contains(((CellLabel)n).getLabel().getText())) continue;
                    ((CellLabel)n).setRemote(true);
                }
            }
        });
    }

    private /* synthetic */ void lambda$null$0(Label showExtended, Node down, Node up, MouseEvent event) {
        if (showExtended.getGraphic().equals(down)) {
            showExtended.setGraphic(up);
        } else {
            showExtended.setGraphic(down);
        }
        Iterator<HBox> iterator = this.extendedLabels.iterator();
        while (iterator.hasNext()) {
            Node n;
            n.setVisible(!(n = (Node)iterator.next()).isVisible());
        }
    }
}

