/*
 * Decompiled with CFR 0.152.
 */
package elegit.treefx;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.GlyphsDude;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import elegit.RefHelper;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;

public class CellLabel
extends HBox {
    private String name;
    private RefHelper refHelper;
    boolean isCurrent;
    boolean isTag;
    boolean isRemote;
    Text pointer;
    ImageView image;
    Label label;
    ContextMenu contextMenu;
    public static final int MAX_CHAR_PER_LABEL = 25;

    CellLabel(RefHelper refHelper, boolean isCurrent) {
        this(refHelper, isCurrent, false);
    }

    CellLabel(RefHelper refHelper, boolean isCurrent, boolean isTag) {
        this.refHelper = refHelper;
        this.name = refHelper.getAbbrevName();
        this.isCurrent = isCurrent;
        this.isTag = isTag;
        this.isRemote = false;
        Text pointer = this.getPointer();
        Label label = this.getLabel();
        ImageView img = this.getImage();
        this.getChildren().add((Object)pointer);
        this.getChildren().add((Object)label);
        this.getChildren().add((Object)img);
        HBox.setMargin((Node)pointer, (Insets)new Insets(5.0, 2.0, 0.0, 5.0));
        HBox.setMargin((Node)img, (Insets)new Insets(2.0, 2.0, 0.0, 0.0));
        HBox.setMargin((Node)label, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
        this.getStyleClass().clear();
        this.getStyleClass().add((Object)"cell-label-box");
        this.setId(isCurrent ? "current" : (isTag ? "tag" : "regular"));
    }

    private Text getPointer() {
        this.pointer = GlyphsDude.createIcon((GlyphIcons)FontAwesomeIcon.CHEVRON_LEFT);
        this.pointer.setFill((Paint)Color.web((String)(this.isCurrent ? "#FFFFFF" : "333333")));
        return this.pointer;
    }

    protected Label getLabel() {
        this.label = new Label();
        this.label.getStyleClass().clear();
        if (this.name.length() > 25) {
            this.addToolTip(this.label, this.name);
            this.name = this.name.substring(0, 24) + "...";
        }
        this.label.setText(this.name);
        this.label.getStyleClass().clear();
        this.label.getStyleClass().add((Object)"cell-label");
        this.label.setId(this.isCurrent ? "current" : "regular");
        return this.label;
    }

    protected ImageView getImage() {
        this.image = new ImageView(new Image(this.isTag ? "elegit/images/tag.png" : (this.isCurrent ? "elegit/images/branch_white.png" : "elegit/images/branch.png")));
        this.image.setFitHeight(15.0);
        this.image.setPreserveRatio(true);
        return this.image;
    }

    public void setContextMenu(ContextMenu menu) {
        this.contextMenu = menu;
        this.setPickOnBounds(true);
        this.setOnMouseClicked(event -> {
            this.contextMenu.show((Node)this, event.getScreenX(), event.getScreenY());
            if (event.getButton() != MouseButton.PRIMARY && event.getButton() == MouseButton.SECONDARY && this.contextMenu != null) {
                this.contextMenu.show((Node)this, event.getScreenX(), event.getScreenY());
            }
            event.consume();
        });
    }

    void setRemote(boolean isRemote) {
        this.isRemote = true;
        this.refreshIcon();
    }

    private void addToolTip(Label l, String text) {
        Tooltip tooltip = new Tooltip(text);
        tooltip.setWrapText(true);
        tooltip.setMaxWidth(350.0);
        Tooltip.install((Node)l, (Tooltip)tooltip);
    }

    void setCurrent(boolean current) {
        this.isCurrent = current;
        ((Node)this.getChildren().get(1)).setId(this.isCurrent ? "current" : "regular");
        ((ImageView)this.getChildren().get(2)).setImage(new Image(this.isCurrent ? "elegit/images/branch_white.png" : "elegit/images/branch.png"));
        this.pointer.setFill((Paint)Color.web((String)(this.isCurrent ? "#FFFFFF" : "333333")));
        this.setId(this.isCurrent ? "current" : (this.isTag ? "tag" : "regular"));
    }

    void setTag(boolean tag) {
        this.isTag = tag;
        ((ImageView)this.getChildren().get(2)).setImage(new Image(this.isTag ? "elegit/images/tag.png" : "elegit/images/branch.png"));
        this.setId(this.isCurrent ? "current" : (this.isTag ? "tag" : "regular"));
    }

    String getName() {
        return this.name;
    }

    void refreshIcon() {
        String image = "elegit/images/";
        image = this.isTag ? image + "tag.png" : (this.isCurrent ? (this.isRemote ? image + "remote_white.png" : image + "remote.png") : image + "branch.png");
        ((ImageView)this.getChildren().get(2)).setImage(new Image(image));
    }

    RefHelper getRefHelper() {
        return this.refHelper;
    }
}

