/*
 * Decompiled with CFR 0.152.
 */
package elegit.treefx;

import elegit.CommitTreeController;
import elegit.RefHelper;
import elegit.treefx.CellLabelContainer;
import elegit.treefx.CellShape;
import elegit.treefx.CellState;
import elegit.treefx.Edge;
import elegit.treefx.Highlighter;
import elegit.treefx.TreeLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Shape;
import javafx.util.Duration;

public class Cell
extends Pane {
    static final CellShape DEFAULT_SHAPE = CellShape.SQUARE;
    public static final CellShape UNTRACKED_BRANCH_HEAD_SHAPE = CellShape.CIRCLE;
    public static final CellShape TRACKED_BRANCH_HEAD_SHAPE = CellShape.TRIANGLE_UP;
    public static final int BOX_SIZE = 20;
    private static final int BOX_SHIFT = 20;
    static final int BOX_INSET = 1;
    static final int BOX_INSIDE = 2;
    private static final String BACKGROUND_COLOR = "#F4F4F4";
    private static final int MAX_NUM_CELLS_TO_ANIMATE = 5;
    private static int numCellsBeingAnimated = 0;
    Node view;
    private CellShape shape;
    private CellType type;
    private Tooltip tooltip;
    private final String cellId;
    private final long time;
    private ContextMenu contextMenu;
    private CellLabelContainer refLabel;
    private boolean animate;
    private boolean useParentAsSource;
    private List<Cell> children = new ArrayList<Cell>();
    private ParentCell parents;
    List<Edge> edges = new ArrayList<Edge>();
    IntegerProperty columnLocationProperty;
    IntegerProperty rowLocationProperty;
    private BooleanProperty hasUpdatedPosition;

    public Cell(String s) {
        this.cellId = s;
        this.time = 0L;
    }

    public Cell(String cellId, long time, List<Cell> parents, CellType type) {
        this.cellId = cellId;
        this.time = time;
        this.parents = new ParentCell(this, parents);
        this.refLabel = new CellLabelContainer();
        this.type = type;
        this.setShape(DEFAULT_SHAPE);
        this.columnLocationProperty = new SimpleIntegerProperty(-1);
        this.rowLocationProperty = new SimpleIntegerProperty(-1);
        this.hasUpdatedPosition = new SimpleBooleanProperty(false);
        this.visibleProperty().bind((ObservableValue)this.hasUpdatedPosition);
        this.columnLocationProperty.addListener((observable, oldValue, newValue) -> this.hasUpdatedPosition.set(oldValue.intValue() == newValue.intValue() || newValue.intValue() > -1 && oldValue.intValue() > -1));
        this.rowLocationProperty.addListener((observable, oldValue, newValue) -> this.hasUpdatedPosition.set(oldValue.intValue() == newValue.intValue() || newValue.intValue() > -1 && oldValue.intValue() > -1));
        this.tooltip = new Tooltip(cellId);
        this.tooltip.setWrapText(true);
        this.tooltip.setMaxWidth(300.0);
        Tooltip.install((Node)this, (Tooltip)this.tooltip);
        this.setOnMouseClicked(event -> {
            if (event.getButton() == MouseButton.PRIMARY) {
                if (event.isShiftDown()) {
                    CommitTreeController.handleMouseClickedShift(this);
                } else {
                    CommitTreeController.handleMouseClicked(this.cellId);
                }
            } else if (event.getButton() == MouseButton.SECONDARY && this.contextMenu != null) {
                this.contextMenu.show((Node)this, event.getScreenX(), event.getScreenY());
            }
            event.consume();
        });
        this.setOnMouseEntered(event -> CommitTreeController.handleMouseover(this, true));
        this.setOnMouseExited(event -> CommitTreeController.handleMouseover(this, false));
        this.view = this.getBaseView();
    }

    void moveTo(double x, double y, boolean animate, boolean emphasize) {
        if (animate && numCellsBeingAnimated < 5) {
            ++numCellsBeingAnimated;
            Shape placeHolder = (Shape)this.getBaseView();
            placeHolder.setTranslateX(x + (double)TreeLayout.H_PAD);
            placeHolder.setTranslateY(y + 20.0);
            placeHolder.setOpacity(0.0);
            ((Pane)this.getParent()).getChildren().add((Object)placeHolder);
            TranslateTransition t = new TranslateTransition(Duration.millis((double)3000.0), (Node)this);
            t.setToX(x);
            t.setToY(y + 20.0);
            t.setCycleCount(1);
            t.setOnFinished(event -> {
                --numCellsBeingAnimated;
                ((Pane)this.getParent()).getChildren().remove((Object)placeHolder);
            });
            t.play();
            if (emphasize) {
                Highlighter.emphasizeCell(this);
            }
        } else {
            this.setTranslateX(x);
            this.setTranslateY(y + 20.0);
        }
        this.refLabel.translate(x, y);
        this.hasUpdatedPosition.set(true);
        if (!this.refLabel.isVisible()) {
            this.refLabel.setVisible(true);
        }
    }

    private Node getBaseView() {
        Shape node = DEFAULT_SHAPE.getType(this.type);
        this.setFillType(node, CellState.STANDARD);
        node.getStyleClass().setAll((Object[])new String[]{"cell"});
        node.setId("tree-cell");
        return node;
    }

    public synchronized void setView(Node newView) {
        if (this.view == null) {
            this.view = this.getBaseView();
        }
        newView.getStyleClass().setAll((Collection)this.view.getStyleClass());
        newView.setId(this.view.getId());
        this.view = newView;
        Platform.runLater(() -> {
            this.getChildren().clear();
            this.getChildren().add((Object)this.view);
            this.setFillType((Shape)this.view, CellState.STANDARD);
        });
    }

    public synchronized void setShape(CellShape newShape) {
        if (this.shape == newShape) {
            return;
        }
        this.setView((Node)newShape.getType(this.type));
        this.shape = newShape;
    }

    private void setDisplayLabel(String label) {
        this.tooltip.setText(label);
    }

    private void setRefLabel(List<RefHelper> refs) {
        this.refLabel.setLabels(refs, this);
    }

    private void setCurrentRefLabels(List<String> refs) {
        this.refLabel.setCurrentLabels(refs);
    }

    void setLabels(String displayLabel, List<RefHelper> refLabels) {
        this.setDisplayLabel(displayLabel);
        this.setRefLabel(refLabels);
    }

    void setCurrentLabels(List<String> refLabels) {
        this.setCurrentRefLabels(refLabels);
    }

    void setLabelMenus(Map<RefHelper, ContextMenu> menuMap) {
        this.refLabel.setLabelMenus(menuMap);
    }

    void setRemoteLabels(List<String> branchLabels) {
        this.refLabel.setRemoteLabels(branchLabels);
    }

    void setAnimate(boolean animate) {
        this.animate = animate;
    }

    void setUseParentAsSource(boolean useParentAsSource) {
        this.useParentAsSource = useParentAsSource;
    }

    void setContextMenu(ContextMenu contextMenu) {
        this.contextMenu = contextMenu;
    }

    private void addCellChild(Cell cell) {
        this.children.add(cell);
    }

    List<Cell> getCellChildren() {
        return this.children;
    }

    List<Cell> getCellParents() {
        return this.parents.toList();
    }

    boolean getAnimate() {
        return this.animate;
    }

    boolean getUseParentAsSource() {
        return this.useParentAsSource;
    }

    void removeCellChild(Cell cell) {
        this.children.remove((Object)cell);
    }

    private boolean isChild(Cell cell, int depth) {
        --depth;
        if (this.children.contains((Object)cell)) {
            return true;
        }
        if (depth != 0) {
            for (Cell child : this.children) {
                if (!child.isChild(cell, depth)) continue;
                return true;
            }
        }
        return false;
    }

    void setCellState(CellState state) {
        Platform.runLater(() -> this.setFillType((Shape)this.view, state));
    }

    void setCellType(CellType type) {
        this.type = type;
        Platform.runLater(() -> this.setFillType((Shape)this.view, CellState.STANDARD));
        for (Edge e : this.edges) {
            e.resetDashed();
        }
    }

    CellType getCellType() {
        return this.type;
    }

    public String getCellId() {
        return this.cellId;
    }

    long getTime() {
        return this.time;
    }

    public Node getLabel() {
        return this.refLabel;
    }

    public String toString() {
        return this.cellId;
    }

    private void setFillType(Shape n, CellState state) {
        Color baseColor = Color.web((String)state.getBackgroundColor());
        switch (this.type) {
            case LOCAL: {
                n.setFill((Paint)baseColor);
                break;
            }
            case REMOTE: {
                n.setFill((Paint)Color.web((String)BACKGROUND_COLOR));
                n.setStroke((Paint)baseColor);
                break;
            }
            case BOTH: {
                n.setFill((Paint)baseColor);
                n.setStroke((Paint)baseColor);
                break;
            }
        }
    }

    private class ParentCell {
        private ArrayList<Cell> parents = new ArrayList();

        ParentCell(Cell child, List<Cell> parents) {
            for (Cell parent : parents) {
                this.parents.add(parent);
            }
            this.setChild(child);
        }

        public int count() {
            return this.parents.size();
        }

        ArrayList<Cell> toList() {
            return this.parents;
        }

        private void setChild(Cell cell) {
            for (Cell parent : this.parents) {
                if (parent == null) continue;
                parent.addCellChild(cell);
            }
        }
    }

    public static enum CellType {
        BOTH,
        LOCAL,
        REMOTE;

    }
}

