/*
 * Decompiled with CFR 0.152.
 */
package elegit.controllers;

import elegit.RepoHelper;
import elegit.SessionModel;
import elegit.controllers.NotificationController;
import elegit.controllers.SessionController;
import elegit.exceptions.NoFilesToStashException;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jgit.api.errors.GitAPIException;

public class StashSaveController {
    private Stage stage;
    private SessionController sessionController;
    private RepoHelper repoHelper;
    @FXML
    private NotificationController notificationPaneController;
    @FXML
    private AnchorPane anchorRoot;
    @FXML
    private Button saveButton;
    @FXML
    private TextField stashMessage;
    @FXML
    private CheckBox includeUntracked;
    static final Logger logger = LogManager.getLogger();

    public void initialize() {
        logger.info("Started up stash save window");
        SessionModel sessionModel = SessionModel.getSessionModel();
        this.repoHelper = sessionModel.getCurrentRepoHelper();
        this.stashMessage.setOnAction(event -> this.stashSave(this.stashMessage.getText()));
        this.notificationPaneController.bindParentBounds(this.anchorRoot.heightProperty());
    }

    public void showStage(AnchorPane pane) {
        this.stage = new Stage();
        this.stage.setTitle("Stash Save");
        this.stage.setScene(new Scene((Parent)pane));
        this.stage.setOnCloseRequest(event -> logger.info("Closed stash save window"));
        this.stage.show();
        this.notificationPaneController.setAnchor(this.stage);
    }

    public void closeWindow() {
        this.stage.close();
    }

    public void handleSave() {
        if (this.stashMessage.getText() != null) {
            this.stashSave(this.stashMessage.getText());
        } else {
            this.stashSave();
        }
    }

    public void stashSave() {
        try {
            this.repoHelper.stashSave(this.includeUntracked.isSelected());
            this.sessionController.gitStatus();
            this.closeWindow();
        }
        catch (GitAPIException e) {
            this.notificationPaneController.addNotification("Something went wrong with the save.");
        }
        catch (NoFilesToStashException e) {
            this.notificationPaneController.addNotification("No files to stash.");
        }
    }

    public void stashSave(String message) {
        try {
            this.repoHelper.stashSave(this.includeUntracked.isSelected(), message, "");
            this.sessionController.gitStatus();
            this.closeWindow();
        }
        catch (GitAPIException e) {
            this.notificationPaneController.addNotification("Something went wrong with the save.");
        }
        catch (NoFilesToStashException e) {
            this.notificationPaneController.addNotification("No files to stash");
        }
    }

    void setSessionController(SessionController controller) {
        this.sessionController = controller;
    }
}

