/*
 * Decompiled with CFR 0.152.
 */
package elegit.controllers;

import elegit.CommitHelper;
import elegit.RepoHelper;
import elegit.SessionModel;
import elegit.controllers.NotificationController;
import elegit.controllers.SessionController;
import java.io.IOException;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.StashApplyFailureException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;

public class StashListController {
    private Stage stage;
    private SessionController sessionController;
    private RepoHelper repoHelper;
    @FXML
    private NotificationController notificationPaneController;
    @FXML
    private AnchorPane anchorRoot;
    @FXML
    private ListView<CommitHelper> stashList;
    @FXML
    private Button applyButton;
    @FXML
    private Button dropButton;
    @FXML
    private Button clearButton;
    @FXML
    private Button popButton;
    static final Logger logger = LogManager.getLogger();

    public void initialize() {
        logger.info("Started up stash list window");
        SessionModel sessionModel = SessionModel.getSessionModel();
        this.repoHelper = sessionModel.getCurrentRepoHelper();
        this.stashList.setCellFactory((Callback)new Callback<ListView<CommitHelper>, ListCell<CommitHelper>>(){

            public ListCell<CommitHelper> call(ListView<CommitHelper> param) {
                return new ListCell<CommitHelper>(){

                    protected void updateItem(CommitHelper helper, boolean empty) {
                        super.updateItem((Object)helper, empty);
                        Label label = new Label();
                        if (helper != null && !empty) {
                            label.setText(this.getIndex() + ": " + helper.getMessage(true));
                            label.getStyleClass().clear();
                            label.setFont(new Font(12.0));
                        }
                        this.setGraphic((Node)label);
                    }
                };
            }
        });
        this.refreshList();
        this.setButtonListeners();
        this.stashList.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.notificationPaneController.bindParentBounds(this.anchorRoot.heightProperty());
    }

    public void showStage(AnchorPane pane) {
        this.stage = new Stage();
        this.stage.setTitle("Stash List");
        this.stage.setScene(new Scene((Parent)pane));
        this.stage.setOnCloseRequest(event -> logger.info("Closed stash list window"));
        this.stage.show();
        this.notificationPaneController.setAnchor(this.stage);
    }

    private void setButtonListeners() {
        this.applyButton.disableProperty().bind((ObservableValue)this.stashList.getSelectionModel().selectedIndexProperty().lessThan(0));
        this.dropButton.disableProperty().bind((ObservableValue)this.stashList.getSelectionModel().selectedIndexProperty().lessThan(0));
        this.popButton.disableProperty().bind((ObservableValue)this.stashList.getSelectionModel().selectedIndexProperty().lessThan(0));
    }

    private void refreshList() {
        try {
            this.stashList.setItems(FXCollections.observableArrayList(this.repoHelper.stashList()));
        }
        catch (GitAPIException e) {
            this.notificationPaneController.addNotification("Something went wrong retrieving the stash(es)");
        }
        catch (IOException e) {
            this.notificationPaneController.addNotification("Something went wrong.");
        }
    }

    public void closeWindow() {
        this.stage.close();
    }

    public void handleApply() {
        String stashRef = ((CommitHelper)this.stashList.getSelectionModel().getSelectedItem()).getId();
        try {
            this.repoHelper.stashApply(stashRef, false);
            this.sessionController.gitStatus();
        }
        catch (WrongRepositoryStateException e) {
            this.notificationPaneController.addNotification("Conflicts occured while trying to apply stash. Commit/stash changes or force apply (right click).");
        }
        catch (StashApplyFailureException e) {
            this.showStashConflictsNotification();
        }
        catch (GitAPIException e) {
            this.notificationPaneController.addNotification("Something went wrong with the apply. Try committing any uncommitted changes.");
        }
    }

    public void handleDrop() {
        int index = this.stashList.getSelectionModel().getSelectedIndex();
        try {
            this.repoHelper.stashDrop(index);
            this.refreshList();
        }
        catch (GitAPIException e) {
            this.notificationPaneController.addNotification("Something went wrong with the drop. Try committing any uncommitted changes.");
        }
    }

    public void handleClearStash() {
        try {
            this.repoHelper.stashClear();
            this.refreshList();
        }
        catch (GitAPIException e) {
            this.notificationPaneController.addNotification("Something went wrong with the clear. Try committing any uncommitted changes.");
        }
    }

    public void handlePop() {
        String stashRef = ((CommitHelper)this.stashList.getSelectionModel().getSelectedItem()).getId();
        int index = this.stashList.getSelectionModel().getSelectedIndex();
        try {
            this.repoHelper.stashApply(stashRef, false);
            this.repoHelper.stashDrop(index);
            this.refreshList();
            this.sessionController.gitStatus();
        }
        catch (StashApplyFailureException e) {
            this.showStashConflictsNotification();
        }
        catch (GitAPIException e) {
            this.notificationPaneController.addNotification("Something went wrong with the pop. Try committing any uncommitted changes.");
        }
    }

    void setSessionController(SessionController controller) {
        this.sessionController = controller;
    }

    private void showStashConflictsNotification() {
        Platform.runLater(() -> {
            logger.warn("Stash apply conflicts warning");
            EventHandler handler = event -> this.sessionController.quickStashSave();
            this.notificationPaneController.addNotification("You can't apply that stash because there would be conflicts. Stash your changes or resolve conflicts first.", "stash", handler);
        });
    }
}

