/*
 * Decompiled with CFR 0.152.
 */
package elegit.controllers;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.GlyphsDude;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import elegit.AllFilesPanelView;
import elegit.BranchHelper;
import elegit.BranchModel;
import elegit.BusyWindow;
import elegit.ClonedRepoHelperBuilder;
import elegit.CommitHelper;
import elegit.CommitTreeController;
import elegit.CommitTreeModel;
import elegit.CommitTreePanelView;
import elegit.ConflictingFileWatcher;
import elegit.DataSubmitter;
import elegit.ExistingRepoHelperBuilder;
import elegit.GitIgnoreEditor;
import elegit.LocalBranchHelper;
import elegit.LocalCommitTreeModel;
import elegit.PopUpWindows;
import elegit.PrefObj;
import elegit.RemoteBranchHelper;
import elegit.RepoFile;
import elegit.RepoHelper;
import elegit.RepoHelperBuilder;
import elegit.RepositoryMonitor;
import elegit.SessionModel;
import elegit.WorkingTreePanelView;
import elegit.controllers.BranchCheckoutController;
import elegit.controllers.CheckoutFilesController;
import elegit.controllers.CommitController;
import elegit.controllers.CreateDeleteBranchWindowController;
import elegit.controllers.DropdownController;
import elegit.controllers.MenuController;
import elegit.controllers.MergeWindowController;
import elegit.controllers.NotificationController;
import elegit.controllers.StashListController;
import elegit.controllers.StashSaveController;
import elegit.exceptions.CancelledAuthorizationException;
import elegit.exceptions.CancelledDialogueException;
import elegit.exceptions.ConflictingFilesException;
import elegit.exceptions.MissingRepoException;
import elegit.exceptions.NoCommitsToMergeException;
import elegit.exceptions.NoCommitsToPushException;
import elegit.exceptions.NoFilesSelectedToAddException;
import elegit.exceptions.NoFilesSelectedToRemoveException;
import elegit.exceptions.NoFilesStagedForCommitException;
import elegit.exceptions.NoFilesToStashException;
import elegit.exceptions.NoRepoLoadedException;
import elegit.exceptions.NoRepoSelectedException;
import elegit.exceptions.NoTagNameException;
import elegit.exceptions.NoTrackingException;
import elegit.exceptions.PushToAheadRemoteError;
import elegit.exceptions.StagedFileCheckedException;
import elegit.exceptions.TagNameExistsException;
import elegit.exceptions.UnableToAddException;
import elegit.exceptions.UnableToRemoveException;
import elegit.treefx.TreeLayout;
import java.awt.Desktop;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.controlsfx.control.CheckListView;
import org.controlsfx.control.PopOver;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.CannotDeleteCurrentBranchException;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.InvalidTagNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.MultipleParentsNotAllowedException;
import org.eclipse.jgit.api.errors.NotMergedException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.StashApplyFailureException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.dircache.InvalidPathException;
import org.eclipse.jgit.errors.NoMergeBaseException;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class SessionController {
    public Button gitStatusButton;
    public Button commitButton;
    public Button pushButton;
    public Button fetchButton;
    public Button addButton;
    public Button removeButton;
    public Button checkoutFileButton;
    public Button mergeButton;
    public Button commitInfoNameCopyButton;
    public Button commitInfoGoToButton;
    public Button addDeleteBranchButton;
    public Button checkoutButton;
    public Button tagButton;
    public Button pushTagsButton;
    private SessionModel theModel;
    public Node root;
    public Tab workingTreePanelTab;
    public Tab allFilesPanelTab;
    public TabPane filesTabPane;
    public WorkingTreePanelView workingTreePanelView;
    public AllFilesPanelView allFilesPanelView;
    public CommitTreePanelView commitTreePanelView;
    public CommitTreeModel commitTreeModel;
    public ImageView remoteImage;
    private String commitInfoNameText = "";
    public TextArea commitInfoMessageText;
    public TextField tagNameField;
    public HBox currentLocalBranchHbox;
    public HBox currentRemoteTrackingBranchHbox;
    private Label currentLocalBranchLabel;
    private Label currentRemoteTrackingLabel;
    public Text browserText;
    public Text needToFetch;
    public Text branchStatusText;
    public Text updatingText;
    public URL remoteURL;
    private DataSubmitter d;
    private BooleanProperty isWorkingTreeTabSelected;
    public static SimpleBooleanProperty anythingChecked;
    private volatile boolean isRecentRepoEventListenerBlocked = false;
    static final Logger logger;
    public ContextMenu pushContextMenu;
    public ContextMenu commitContextMenu;
    public ContextMenu fetchContextMenu;
    public Hyperlink legendLink;
    public StackPane statusTextPane;
    private Stage mainStage;
    @FXML
    private AnchorPane anchorRoot;
    @FXML
    private StackPane notificationPane;
    @FXML
    private NotificationController notificationPaneController;
    @FXML
    private MenuController menuController;
    @FXML
    private DropdownController dropdownController;
    boolean tryCommandAgainWithHTTPAuth;
    private boolean isGitStatusDone;
    private boolean isTimerDone;
    Preferences preferences;
    private static final String LOGGING_LEVEL_KEY = "LOGGING_LEVEL";

    public void initialize() {
        this.theModel = SessionModel.getSessionModel();
        this.d = new DataSubmitter();
        CommitTreeController.sessionController = this;
        CommitController.sessionController = this;
        this.menuController.setSessionController(this);
        this.dropdownController.setSessionController(this);
        this.commitTreeModel = new LocalCommitTreeModel(this.theModel, this.commitTreePanelView);
        this.workingTreePanelView.setSessionModel(this.theModel);
        this.allFilesPanelView.setSessionModel(this.theModel);
        this.initializeLayoutParameters();
        this.initButtons();
        this.setButtonIconsAndTooltips();
        this.setButtonsDisabled(true);
        this.initWorkingTreePanelTab();
        this.theModel.loadRecentRepoHelpersFromStoredPathStrings();
        this.theModel.loadMostRecentRepoHelper();
        this.initPanelViews();
        this.updateUIEnabledStatus();
        this.setRecentReposDropdownToCurrentRepo();
        this.refreshRecentReposInDropdown();
        this.initRepositoryMonitor();
        this.initStatusText();
        this.notificationPaneController.bindParentBounds(this.anchorRoot.heightProperty());
        VBox.setVgrow((Node)this.commitInfoMessageText, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.filesTabPane, (Priority)Priority.ALWAYS);
        try {
            ConflictingFileWatcher.watchConflictingFiles(this.theModel.getCurrentRepoHelper());
        }
        catch (IOException | GitAPIException e) {
            e.printStackTrace();
        }
        this.tryCommandAgainWithHTTPAuth = false;
        this.preferences = Preferences.userNodeForPackage(this.getClass());
    }

    public void setStage(Stage stage) {
        this.mainStage = stage;
        this.notificationPaneController.setAnchor(this.mainStage);
    }

    private void initStatusText() {
        this.updatingText.setVisible(false);
        this.branchStatusText.visibleProperty().bind((ObservableValue)this.updatingText.visibleProperty().not());
        this.currentRemoteTrackingLabel = new Label("N/A");
        this.currentLocalBranchLabel = new Label("N/A");
        this.initCellLabel(this.currentLocalBranchLabel, this.currentLocalBranchHbox);
        this.initCellLabel(this.currentRemoteTrackingLabel, this.currentRemoteTrackingBranchHbox);
        this.updateStatusText();
    }

    private void initCellLabel(Label label, HBox hbox) {
        hbox.getStyleClass().clear();
        hbox.getStyleClass().add((Object)"cell-label-box");
        label.getStyleClass().clear();
        label.getStyleClass().add((Object)"cell-label");
        label.setId("current");
        hbox.setId("current");
        hbox.getChildren().add((Object)label);
    }

    private void addToolTip(Node n, String text) {
        Tooltip tooltip = new Tooltip(text);
        tooltip.setWrapText(true);
        tooltip.setMaxWidth(350.0);
        Tooltip.install((Node)n, (Tooltip)tooltip);
    }

    private void updateStatusText() {
        Color statusColor;
        if (this.theModel.getCurrentRepoHelper() == null) {
            return;
        }
        boolean update = RepositoryMonitor.hasFoundNewRemoteChanges.get();
        String fetchText = update ? "New changes to fetch" : "Up to date";
        Color fetchColor = update ? Color.FIREBRICK : Color.FORESTGREEN;
        this.needToFetch.setText(fetchText);
        this.needToFetch.setFont(new Font(15.0));
        this.needToFetch.setFill((Paint)fetchColor);
        BranchHelper localBranch = this.theModel.getCurrentRepoHelper().getBranchModel().getCurrentBranch();
        boolean bl = update = !localBranch.getAbbrevName().equals(this.currentLocalBranchLabel.getText());
        if (update) {
            Platform.runLater(() -> {
                this.currentLocalBranchLabel.setText(localBranch.getAbbrevName());
                this.currentLocalBranchLabel.setOnMouseClicked(event -> CommitTreeController.focusCommitInGraph(localBranch.getCommit()));
                this.addToolTip((Node)this.currentLocalBranchHbox, localBranch.getRefName());
            });
        }
        String remoteBranch = "N/A";
        String remoteBranchFull = "N/A";
        CommitHelper remoteHead = null;
        try {
            remoteBranch = this.theModel.getCurrentRepoHelper().getBranchModel().getCurrentRemoteAbbrevBranch();
            remoteHead = this.theModel.getCurrentRepoHelper().getBranchModel().getCurrentRemoteBranchHead();
            remoteBranchFull = this.theModel.getCurrentRepoHelper().getBranchModel().getCurrentRemoteBranch();
        }
        catch (IOException e) {
            this.showGenericErrorNotification();
        }
        if (remoteBranch == null) {
            remoteBranch = "N/A";
            remoteBranchFull = "N/A";
        }
        String remoteBranchFinal = remoteBranch;
        String remoteBranchFullFinal = remoteBranchFull;
        boolean bl2 = update = !remoteBranch.equals(this.currentRemoteTrackingLabel.getText());
        if (update) {
            CommitHelper finalRemoteHead = remoteHead;
            Platform.runLater(() -> {
                this.currentRemoteTrackingLabel.setText(remoteBranchFinal);
                if (finalRemoteHead != null) {
                    this.currentRemoteTrackingLabel.setOnMouseClicked(event -> CommitTreeController.focusCommitInGraph(finalRemoteHead));
                }
                this.addToolTip((Node)this.currentRemoteTrackingBranchHbox, remoteBranchFullFinal);
            });
        }
        int ahead = 0;
        int behind = 0;
        try {
            ahead = this.theModel.getCurrentRepoHelper().getAheadCount();
            behind = this.theModel.getCurrentRepoHelper().getBehindCount();
        }
        catch (IOException e) {
            this.showGenericErrorNotification();
        }
        String statusText = "Up to date.";
        if (ahead > 0) {
            statusText = this.currentLocalBranchLabel.getText() + " ahead of " + this.currentRemoteTrackingLabel.getText() + " by " + ahead + " commit";
            if (ahead > 1) {
                statusText = statusText + "s";
            }
            if (behind > 0) {
                statusText = statusText + "\nand behind by " + behind + " commit";
                if (behind > 1) {
                    statusText = statusText + "s";
                }
            }
            statusText = statusText + ".";
        } else if (behind > 0) {
            statusText = this.currentLocalBranchLabel.getText() + " behind " + this.currentRemoteTrackingLabel.getText() + " by " + behind + " commit";
            if (behind > 1) {
                statusText = statusText + "s";
            }
            statusText = statusText + ".";
        }
        update = !statusText.equals(this.branchStatusText.getText());
        Color color = statusColor = statusText.equals("Up to date.") ? Color.FORESTGREEN : Color.FIREBRICK;
        if (update) {
            this.branchStatusText.setText(statusText);
            this.branchStatusText.setFill((Paint)statusColor);
        }
    }

    private void initWorkingTreePanelTab() {
        this.isWorkingTreeTabSelected = new SimpleBooleanProperty(true);
        this.isWorkingTreeTabSelected.bind((ObservableValue)this.workingTreePanelTab.selectedProperty());
        this.workingTreePanelTab.getTabPane().getSelectionModel().select((Object)this.workingTreePanelTab);
    }

    private void initRepositoryMonitor() {
        RepositoryMonitor.startWatching(this.theModel, this);
        RepositoryMonitor.hasFoundNewRemoteChanges.addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.updateStatusText();
            }
        });
    }

    private void initializeLayoutParameters() {
        this.gitStatusButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.commitButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.addButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.checkoutFileButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.removeButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.addDeleteBranchButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.mergeButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.checkoutButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.pushButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.pushTagsButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.fetchButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.commitInfoNameCopyButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.commitInfoGoToButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.workingTreePanelView.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.allFilesPanelView.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.tagNameField.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    }

    private void initButtons() {
        anythingChecked = new SimpleBooleanProperty(false);
        this.checkoutFileButton.disableProperty().bind((ObservableValue)anythingChecked.not());
        this.addButton.disableProperty().bind((ObservableValue)anythingChecked.not());
        this.removeButton.disableProperty().bind((ObservableValue)anythingChecked.not());
        this.legendLink.setFont(new Font(12.0));
        this.pushButton.setOnMouseClicked(event -> {
            if (event.getButton() == MouseButton.SECONDARY && this.pushContextMenu != null) {
                this.pushContextMenu.show((Node)this.pushButton, event.getScreenX(), event.getScreenY());
            }
            event.consume();
        });
        this.commitButton.setOnMouseClicked(event -> {
            if (event.getButton() == MouseButton.SECONDARY && this.commitContextMenu != null) {
                this.commitContextMenu.show((Node)this.commitButton, event.getScreenX(), event.getScreenY());
            }
            event.consume();
        });
        this.fetchButton.setOnMouseClicked(event -> {
            if (event.getButton() == MouseButton.SECONDARY && this.fetchContextMenu != null) {
                this.fetchContextMenu.show((Node)this.fetchButton, event.getScreenX(), event.getScreenY());
            }
            event.consume();
        });
        this.tagNameField.setOnKeyTyped(event -> {
            if (event.getCharacter().equals("\r")) {
                this.handleTagButton();
            }
        });
    }

    private void setButtonIconsAndTooltips() {
        Text clipboardIcon = GlyphsDude.createIcon((GlyphIcons)FontAwesomeIcon.CLIPBOARD);
        this.commitInfoNameCopyButton.setGraphic((Node)clipboardIcon);
        Text goToIcon = GlyphsDude.createIcon((GlyphIcons)FontAwesomeIcon.ARROW_CIRCLE_LEFT);
        this.commitInfoGoToButton.setGraphic((Node)goToIcon);
        this.commitInfoGoToButton.setTooltip(new Tooltip("Go to selected commit"));
        this.commitInfoNameCopyButton.setTooltip(new Tooltip("Copy commit ID"));
        this.commitButton.setTooltip(new Tooltip("Check in selected files to local repository"));
        this.addButton.setTooltip(new Tooltip("Stage changes for selected files"));
        this.checkoutFileButton.setTooltip(new Tooltip("Checkout files from the index (discard all unstaged changes)"));
        this.removeButton.setTooltip(new Tooltip("Delete selected files and remove them from Git"));
        this.fetchButton.setTooltip(new Tooltip("Download files from another repository to remote repository"));
        this.pushButton.setTooltip(new Tooltip("Update remote repository with local changes,\nright click for advanced options"));
        this.dropdownController.loadNewRepoButton.setTooltip(new Tooltip("Load a new repository"));
        this.mergeButton.setTooltip(new Tooltip("Merge two commits together"));
    }

    private synchronized void initPanelViews() {
        try {
            this.workingTreePanelView.drawDirectoryView();
            this.allFilesPanelView.drawDirectoryView();
            this.commitTreeModel.init();
            this.setBrowserURL();
        }
        catch (IOException | GitAPIException e) {
            this.showGenericErrorNotification();
        }
    }

    private void setBrowserURL() {
        try {
            RepoHelper currentRepoHelper = this.theModel.getCurrentRepoHelper();
            if (currentRepoHelper == null) {
                throw new NoRepoLoadedException();
            }
            if (!currentRepoHelper.exists()) {
                throw new MissingRepoException();
            }
            List<String> remoteURLs = currentRepoHelper.getLinkedRemoteRepoURLs();
            if (remoteURLs.size() == 0) {
                this.showNoRemoteNotification();
                return;
            }
            String URLString = remoteURLs.get(0);
            if (URLString != null) {
                if (URLString.contains("@")) {
                    URLString = "https://" + URLString.replace(":", "/").split("@")[1];
                }
                try {
                    this.remoteURL = new URL(URLString);
                    this.browserText.setText(this.remoteURL.getHost());
                }
                catch (MalformedURLException e) {
                    this.browserText.setText(URLString);
                }
            }
            Tooltip URLTooltip = new Tooltip(URLString);
            Tooltip.install((Node)this.browserText, (Tooltip)URLTooltip);
            this.browserText.setFill((Paint)Color.DARKCYAN);
            this.browserText.setUnderline(true);
        }
        catch (MissingRepoException e) {
            this.showMissingRepoNotification();
            this.setButtonsDisabled(true);
            this.refreshRecentReposInDropdown();
        }
        catch (NoRepoLoadedException e) {
            this.setButtonsDisabled(true);
        }
    }

    void setButtonsDisabled(boolean disable) {
        Platform.runLater(() -> {
            this.dropdownController.openRepoDirButton.setDisable(disable);
            this.gitStatusButton.setDisable(disable);
            this.tagButton.setDisable(disable);
            this.commitButton.setDisable(disable);
            this.pushButton.setDisable(disable);
            this.fetchButton.setDisable(disable);
            this.remoteImage.setVisible(!disable);
            this.browserText.setVisible(!disable);
            this.workingTreePanelTab.setDisable(disable);
            this.allFilesPanelTab.setDisable(disable);
            this.dropdownController.removeRecentReposButton.setDisable(disable);
            this.dropdownController.repoDropdownSelector.setDisable(disable);
            this.addDeleteBranchButton.setDisable(disable);
            this.checkoutButton.setDisable(disable);
            this.mergeButton.setDisable(disable);
            this.pushTagsButton.setDisable(disable);
            this.needToFetch.setVisible(!disable);
            this.currentLocalBranchHbox.setVisible(!disable);
            this.currentRemoteTrackingBranchHbox.setVisible(!disable);
            this.statusTextPane.setVisible(!disable);
            this.updateMenuBarEnabledStatus(disable);
        });
        this.root.setOnMouseClicked(event -> {
            if (disable) {
                this.showNoRepoLoadedNotification();
            }
            if (this.notificationPaneController.isListPaneVisible()) {
                this.notificationPaneController.toggleNotificationList();
            }
        });
    }

    private void updateMenuBarEnabledStatus(boolean disable) {
        this.menuController.repoMenu.setDisable(disable);
        this.menuController.gitIgnoreMenuItem.setDisable(disable);
    }

    private void updateUIEnabledStatus() {
        if (this.theModel.getCurrentRepoHelper() == null && this.theModel.getAllRepoHelpers().size() >= 0) {
            this.setButtonsDisabled(true);
        } else {
            this.setButtonsDisabled(false);
        }
    }

    public void handleLoadNewRepoButton() {
        this.dropdownController.newRepoOptionsMenu.show((Node)this.dropdownController.loadNewRepoButton, Side.BOTTOM, 0.0, 0.0);
    }

    public void handleLoadExistingRepoOption() {
        this.handleLoadRepoMenuItem(new ExistingRepoHelperBuilder(this.theModel));
    }

    public void handleCloneNewRepoOption() {
        this.handleLoadRepoMenuItem(new ClonedRepoHelperBuilder(this.theModel));
    }

    private synchronized void handleLoadRepoMenuItem(RepoHelperBuilder builder) {
        try {
            final RepoHelper repoHelper = builder.getRepoHelperFromDialogs();
            if (this.theModel.getCurrentRepoHelper() != null && repoHelper.localPath.equals(this.theModel.getCurrentRepoHelper().localPath)) {
                this.showSameRepoLoadedNotification();
                return;
            }
            RepositoryMonitor.pause();
            BusyWindow.show();
            BusyWindow.setLoadingText("Loading the repository...");
            Thread th = new Thread((Runnable)new Task<Void>(){

                protected Void call() {
                    try {
                        TreeLayout.stopMovingCells();
                        SessionController.this.refreshRecentReposInDropdown();
                        SessionController.this.theModel.openRepoFromHelper(repoHelper);
                        SessionController.this.setRecentReposDropdownToCurrentRepo();
                        Platform.runLater(() -> {
                            SessionController.this.initPanelViews();
                            SessionController.this.updateUIEnabledStatus();
                        });
                    }
                    catch (ClassNotFoundException | BackingStoreException exception) {
                    }
                    catch (MissingRepoException e) {
                        SessionController.this.showMissingRepoNotification();
                        SessionController.this.refreshRecentReposInDropdown();
                    }
                    catch (IOException e) {
                        SessionController.this.showRepoWasNotLoadedNotification();
                    }
                    catch (Exception e) {
                        SessionController.this.showGenericErrorNotification();
                        e.printStackTrace();
                    }
                    finally {
                        RepositoryMonitor.unpause();
                        BusyWindow.hide();
                    }
                    return null;
                }
            });
            th.setDaemon(true);
            th.setName("Loading existing/cloning repository");
            th.start();
        }
        catch (InvalidPathException e) {
            this.showRepoWasNotLoadedNotification();
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            this.showInvalidRepoNotification();
        }
        catch (JGitInternalException e) {
            this.showNonEmptyFolderNotification(() -> this.handleLoadRepoMenuItem(builder));
        }
        catch (InvalidRemoteException e) {
            this.showInvalidRemoteNotification(() -> this.handleLoadRepoMenuItem(builder));
        }
        catch (TransportException e) {
            this.showTransportExceptionNotification(e);
        }
        catch (CancelledAuthorizationException | NoRepoSelectedException e) {
        }
        catch (IOException | GitAPIException e) {
            this.showRepoWasNotLoadedNotification();
        }
    }

    @FXML
    private void setRecentReposDropdownToCurrentRepo() {
        Platform.runLater(() -> {
            SessionController sessionController = this;
            synchronized (sessionController) {
                this.isRecentRepoEventListenerBlocked = true;
                RepoHelper currentRepo = this.theModel.getCurrentRepoHelper();
                this.dropdownController.repoDropdownSelector.setValue((Object)currentRepo);
                this.isRecentRepoEventListenerBlocked = false;
            }
        });
    }

    @FXML
    private void refreshRecentReposInDropdown() {
        Platform.runLater(() -> {
            SessionController sessionController = this;
            synchronized (sessionController) {
                this.isRecentRepoEventListenerBlocked = true;
                List<RepoHelper> repoHelpers = this.theModel.getAllRepoHelpers();
                this.dropdownController.repoDropdownSelector.setItems(FXCollections.observableArrayList(repoHelpers));
                this.isRecentRepoEventListenerBlocked = false;
            }
        });
    }

    private synchronized void handleRecentRepoMenuItem(final RepoHelper repoHelper) {
        if (this.isRecentRepoEventListenerBlocked || repoHelper == null) {
            return;
        }
        this.notificationPaneController.clearAllNotifications();
        logger.info("Switching repos");
        RepositoryMonitor.pause();
        BusyWindow.show();
        BusyWindow.setLoadingText("Opening the repository...");
        Thread th = new Thread((Runnable)new Task<Void>(){

            protected Void call() throws Exception {
                try {
                    SessionController.this.theModel.openRepoFromHelper(repoHelper);
                    Platform.runLater(() -> {
                        SessionController.this.initPanelViews();
                        SessionController.this.updateUIEnabledStatus();
                    });
                }
                catch (IOException e) {
                    SessionController.this.showRepoWasNotLoadedNotification();
                }
                catch (MissingRepoException e) {
                    SessionController.this.showMissingRepoNotification();
                    SessionController.this.refreshRecentReposInDropdown();
                }
                catch (ClassNotFoundException | BackingStoreException e) {
                }
                catch (Exception e) {
                    SessionController.this.showGenericErrorNotification();
                    e.printStackTrace();
                }
                finally {
                    RepositoryMonitor.unpause();
                    BusyWindow.hide();
                }
                return null;
            }
        });
        th.setDaemon(true);
        th.setName("Open repository from recent list");
        th.start();
    }

    public void loadSelectedRepo() {
        if (this.theModel.getAllRepoHelpers().size() == 0) {
            return;
        }
        RepoHelper selectedRepoHelper = (RepoHelper)this.dropdownController.repoDropdownSelector.getValue();
        this.handleRecentRepoMenuItem(selectedRepoHelper);
    }

    public void handleAddButton() {
        try {
            logger.info("Add button clicked");
            if (this.theModel.getCurrentRepoHelper() == null) {
                throw new NoRepoLoadedException();
            }
            if (!this.theModel.getCurrentRepoHelper().exists()) {
                throw new MissingRepoException();
            }
            if (!this.workingTreePanelView.isAnyFileSelected()) {
                throw new NoFilesSelectedToAddException();
            }
            if (this.workingTreePanelView.isAnyFileStagedSelected()) {
                throw new StagedFileCheckedException();
            }
            BusyWindow.show();
            BusyWindow.setLoadingText("Adding...");
            Thread th = new Thread((Runnable)new Task<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Void call() {
                    try {
                        ArrayList<Path> filePathsToAdd = new ArrayList<Path>();
                        for (RepoFile checkedFile : SessionController.this.workingTreePanelView.getCheckedFilesInDirectory()) {
                            if (checkedFile.canAdd()) {
                                filePathsToAdd.add(checkedFile.getFilePath());
                                continue;
                            }
                            throw new UnableToAddException(checkedFile.filePath.toString());
                        }
                        SessionController.this.theModel.getCurrentRepoHelper().addFilePaths(filePathsToAdd);
                        SessionController.this.gitStatus();
                    }
                    catch (JGitInternalException e) {
                        SessionController.this.showJGitInternalError(e);
                    }
                    catch (UnableToAddException e) {
                        SessionController.this.showCannotAddFileNotification(e.filename);
                    }
                    catch (IOException | GitAPIException e) {
                        SessionController.this.showGenericErrorNotification();
                    }
                    finally {
                        BusyWindow.hide();
                    }
                    return null;
                }
            });
            th.setDaemon(true);
            th.setName("Git add");
            th.start();
        }
        catch (NoFilesSelectedToAddException e) {
            this.showNoFilesSelectedForAddNotification();
        }
        catch (NoRepoLoadedException e) {
            this.showNoRepoLoadedNotification();
        }
        catch (MissingRepoException e) {
            this.showMissingRepoNotification();
        }
        catch (StagedFileCheckedException e) {
            this.showStagedFilesSelectedNotification();
        }
    }

    public void handleRemoveButton() {
        try {
            logger.info("Remove button clicked");
            if (this.theModel.getCurrentRepoHelper() == null) {
                throw new NoRepoLoadedException();
            }
            if (!this.theModel.getCurrentRepoHelper().exists()) {
                throw new MissingRepoException();
            }
            if (!this.workingTreePanelView.isAnyFileSelected()) {
                throw new NoFilesSelectedToRemoveException();
            }
            BusyWindow.show();
            BusyWindow.setLoadingText("Removing...");
            Thread th = new Thread((Runnable)new Task<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Void call() {
                    try {
                        ArrayList<Path> filePathsToRemove = new ArrayList<Path>();
                        for (RepoFile checkedFile : SessionController.this.workingTreePanelView.getCheckedFilesInDirectory()) {
                            if (checkedFile.canRemove()) {
                                filePathsToRemove.add(checkedFile.getFilePath());
                                continue;
                            }
                            throw new UnableToRemoveException(checkedFile.filePath.toString());
                        }
                        SessionController.this.theModel.getCurrentRepoHelper().removeFilePaths(filePathsToRemove);
                        SessionController.this.gitStatus();
                    }
                    catch (JGitInternalException e) {
                        SessionController.this.showJGitInternalError(e);
                    }
                    catch (UnableToRemoveException e) {
                        SessionController.this.showCannotRemoveFileNotification(e.filename);
                    }
                    catch (GitAPIException e) {
                        SessionController.this.showGenericErrorNotification();
                    }
                    finally {
                        BusyWindow.hide();
                    }
                    return null;
                }
            });
            th.setDaemon(true);
            th.setName("Git rm");
            th.start();
        }
        catch (NoFilesSelectedToRemoveException e) {
            this.showNoFilesSelectedForRemoveNotification();
        }
        catch (NoRepoLoadedException e) {
            this.showNoRepoLoadedNotification();
        }
        catch (MissingRepoException e) {
            this.showMissingRepoNotification();
        }
    }

    public void handleCheckoutButton(Path filePath) {
        try {
            logger.info("Checkout file button clicked");
            if (!PopUpWindows.showCheckoutAlert()) {
                throw new CancelledDialogueException();
            }
            if (this.theModel.getCurrentRepoHelper() == null) {
                throw new NoRepoLoadedException();
            }
            if (!this.theModel.getCurrentRepoHelper().exists()) {
                throw new MissingRepoException();
            }
            this.theModel.getCurrentRepoHelper().checkoutFile(filePath);
        }
        catch (NoRepoLoadedException e) {
            this.showNoRepoLoadedNotification();
        }
        catch (MissingRepoException e) {
            this.showMissingRepoNotification();
        }
        catch (GitAPIException e) {
            this.showGenericErrorNotification();
        }
        catch (CancelledDialogueException cancelledDialogueException) {
            // empty catch block
        }
    }

    public void handleCheckoutButton() {
        try {
            logger.info("Checkout button clicked");
            if (this.theModel.getCurrentRepoHelper() == null) {
                throw new NoRepoLoadedException();
            }
            if (!this.theModel.getCurrentRepoHelper().exists()) {
                throw new MissingRepoException();
            }
            if (!this.workingTreePanelView.isAnyFileSelected()) {
                throw new NoFilesSelectedToAddException();
            }
            if (!PopUpWindows.showCheckoutAlert()) {
                throw new CancelledDialogueException();
            }
            ArrayList<Path> filePathsToCheckout = new ArrayList<Path>();
            for (RepoFile checkedFile : this.workingTreePanelView.getCheckedFilesInDirectory()) {
                filePathsToCheckout.add(checkedFile.getFilePath());
            }
            this.theModel.getCurrentRepoHelper().checkoutFiles(filePathsToCheckout);
            this.gitStatus();
        }
        catch (NoFilesSelectedToAddException e) {
            this.showNoFilesSelectedForAddNotification();
        }
        catch (NoRepoLoadedException e) {
            this.showNoRepoLoadedNotification();
        }
        catch (MissingRepoException e) {
            this.showMissingRepoNotification();
        }
        catch (GitAPIException e) {
            this.showGenericErrorNotification();
        }
        catch (CancelledDialogueException cancelledDialogueException) {
            // empty catch block
        }
    }

    public void handleCheckoutFilesButton(CommitHelper commitHelper) {
        try {
            logger.info("Checkout files from commit button clicked");
            if (this.theModel.getCurrentRepoHelper() == null) {
                throw new NoRepoLoadedException();
            }
            logger.info("Opened checkout files window");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/elegit/fxml/CheckoutFiles.fxml"));
            fxmlLoader.load();
            CheckoutFilesController checkoutFilesController = (CheckoutFilesController)fxmlLoader.getController();
            checkoutFilesController.setSessionController(this);
            checkoutFilesController.setCommitHelper(commitHelper);
            AnchorPane fxmlRoot = (AnchorPane)fxmlLoader.getRoot();
            checkoutFilesController.showStage(fxmlRoot);
        }
        catch (IOException e) {
            this.showGenericErrorNotification();
            e.printStackTrace();
        }
        catch (NoRepoLoadedException e) {
            this.showNoRepoLoadedNotification();
            this.setButtonsDisabled(true);
        }
    }

    public void handleCommitAll() {
        this.handleCommitButton(CommitType.ALL);
    }

    public void handleCommitNormal() {
        this.handleCommitButton(CommitType.NORMAL);
    }

    public void handleCommitButton(CommitType type) {
        try {
            logger.info("Commit button clicked");
            if (this.theModel.getCurrentRepoHelper() == null) {
                throw new NoRepoLoadedException();
            }
            if (!this.theModel.getCurrentRepoHelper().exists()) {
                throw new MissingRepoException();
            }
            if (!this.workingTreePanelView.isAnyFileStaged() && type.equals((Object)CommitType.NORMAL)) {
                throw new NoFilesStagedForCommitException();
            }
            if (type.equals((Object)CommitType.NORMAL)) {
                this.commitNormal();
            } else {
                this.commitAll();
            }
        }
        catch (NoRepoLoadedException e) {
            this.showNoRepoLoadedNotification();
            this.setButtonsDisabled(true);
        }
        catch (MissingRepoException e) {
            this.showMissingRepoNotification();
            this.setButtonsDisabled(true);
            this.refreshRecentReposInDropdown();
        }
        catch (NoFilesStagedForCommitException e) {
            this.showNoFilesStagedForCommitNotification();
        }
        catch (IOException e) {
            this.showGenericErrorNotification();
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void commitAll() {
        final String message = PopUpWindows.getCommitMessage();
        if (message.equals("cancel")) {
            return;
        }
        BusyWindow.show();
        BusyWindow.setLoadingText("Committing all...");
        Thread th = new Thread((Runnable)new Task<Void>(){

            protected Void call() {
                try {
                    SessionController.this.theModel.getCurrentRepoHelper().commitAll(message);
                    SessionController.this.gitStatus();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    BusyWindow.hide();
                }
                return null;
            }
        });
        th.setDaemon(true);
        th.setName("Git commit all");
        th.start();
    }

    private void commitNormal() throws IOException {
        logger.info("Opened commit manager window");
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/elegit/fxml/CommitView.fxml"));
        fxmlLoader.load();
        CommitController commitController = (CommitController)fxmlLoader.getController();
        commitController.isClosed.addListener((observable, oldValue, newValue) -> {
            if (!oldValue.booleanValue() && newValue.booleanValue()) {
                this.gitStatus();
            }
        });
        GridPane fxmlRoot = (GridPane)fxmlLoader.getRoot();
        commitController.showStage(fxmlRoot);
    }

    public void handleTagButton() {
        logger.info("Clicked tag button");
        try {
            if (this.theModel.getCurrentRepoHelper() == null) {
                throw new NoRepoLoadedException();
            }
            if (!this.theModel.getCurrentRepoHelper().exists()) {
                throw new MissingRepoException();
            }
            final String tagName = this.tagNameField.getText();
            if (this.theModel.getCurrentRepoHelper().getTagModel().getTag(tagName) != null) {
                throw new TagNameExistsException();
            }
            if (tagName.length() == 0) {
                throw new NoTagNameException();
            }
            Thread th = new Thread((Runnable)new Task<Void>(){

                protected Void call() {
                    try {
                        SessionController.this.theModel.getCurrentRepoHelper().getTagModel().tag(tagName, SessionController.this.commitInfoNameText);
                        SessionController.this.tagNameField.clear();
                        SessionController.this.gitStatus();
                    }
                    catch (JGitInternalException e) {
                        SessionController.this.showJGitInternalError(e);
                    }
                    catch (MissingRepoException e) {
                        SessionController.this.showMissingRepoNotification();
                        SessionController.this.setButtonsDisabled(true);
                        SessionController.this.refreshRecentReposInDropdown();
                    }
                    catch (InvalidTagNameException e) {
                        SessionController.this.showInvalidTagNameNotification(tagName);
                    }
                    catch (TransportException e) {
                        SessionController.this.showTransportExceptionNotification(e);
                    }
                    catch (GitAPIException e) {
                        SessionController.this.showGenericErrorNotification();
                        e.printStackTrace();
                    }
                    catch (TagNameExistsException e) {
                        SessionController.this.showTagExistsNotification();
                    }
                    catch (Exception e) {
                        SessionController.this.showGenericErrorNotification();
                        e.printStackTrace();
                    }
                    SessionController.this.tagNameField.setText("");
                    SessionController.this.clearSelectedCommit();
                    SessionController.this.selectCommit(SessionController.this.theModel.getCurrentRepoHelper().getTagModel().getTag(tagName).getCommitId());
                    return null;
                }
            });
            th.setDaemon(true);
            th.setName("Git tag");
            th.start();
        }
        catch (NoRepoLoadedException e) {
            this.showNoRepoLoadedNotification();
            this.setButtonsDisabled(true);
        }
        catch (MissingRepoException e) {
            this.showMissingRepoNotification();
            this.setButtonsDisabled(true);
            this.refreshRecentReposInDropdown();
        }
        catch (NoTagNameException e) {
            this.showNoTagNameNotification();
        }
        catch (TagNameExistsException e) {
            this.showTagExistsNotification();
        }
    }

    public void handlePushButton() {
        this.pushBranchOrAllSetup(PushType.BRANCH);
    }

    public void handlePushAllButton() {
        this.pushBranchOrAllSetup(PushType.ALL);
    }

    private void pushBranchOrAllSetup(PushType pushType) {
        try {
            PushCommand push;
            logger.info("Push button clicked");
            if (this.theModel.getCurrentRepoHelper() == null) {
                throw new NoRepoLoadedException();
            }
            if (pushType == PushType.BRANCH && !this.theModel.getCurrentRepoHelper().canPush()) {
                throw new NoCommitsToPushException();
            }
            RepoHelper helper = this.theModel.getCurrentRepoHelper();
            if (pushType == PushType.BRANCH) {
                push = helper.prepareToPushCurrentBranch(false);
            } else if (pushType == PushType.ALL) {
                push = helper.prepareToPushAll();
            } else {
                push = null;
                assert (false) : "PushType enum case not handled";
            }
            this.pushBranchOrAll(pushType, push);
        }
        catch (NoRepoLoadedException e) {
            this.showNoRepoLoadedNotification();
            this.setButtonsDisabled(true);
        }
        catch (NoCommitsToPushException e) {
            this.showNoCommitsToPushNotification();
        }
        catch (IOException e) {
            this.showGenericErrorNotification();
        }
        catch (PushToAheadRemoteError pushToAheadRemoteError) {
            pushToAheadRemoteError.printStackTrace();
        }
        catch (MissingRepoException e) {
            this.showMissingRepoNotification();
            this.setButtonsDisabled(true);
            this.refreshRecentReposInDropdown();
        }
        catch (GitAPIException e) {
            this.showGenericErrorNotification();
            e.printStackTrace();
        }
    }

    public void pushBranchOrAll(final PushType pushType, final PushCommand push) {
        try {
            final RepoHelperBuilder.AuthDialogResponse credentialResponse = this.askUserForCredentials();
            BusyWindow.show();
            BusyWindow.setLoadingText("Pushing...");
            Thread th = new Thread((Runnable)new Task<Void>(){

                protected Void call() {
                    SessionController.this.tryCommandAgainWithHTTPAuth = false;
                    try {
                        SessionController.this.pushBranchOrAllDetails(credentialResponse, pushType, push);
                    }
                    catch (TransportException e) {
                        SessionController.this.determineIfTryAgain(e);
                    }
                    finally {
                        BusyWindow.hide();
                    }
                    if (SessionController.this.tryCommandAgainWithHTTPAuth) {
                        Platform.runLater(() -> SessionController.this.pushBranchOrAll(pushType, push));
                    }
                    return null;
                }
            });
            th.setDaemon(true);
            th.setName("Git push");
            th.start();
        }
        catch (CancelledAuthorizationException e) {
            this.showCommandCancelledNotification();
        }
    }

    private void determineIfTryAgain(TransportException e) {
        this.showTransportExceptionNotification(e);
        if (!e.getMessage().endsWith("Auth cancel")) {
            this.tryCommandAgainWithHTTPAuth = true;
        }
    }

    private void pushBranchOrAllDetails(RepoHelperBuilder.AuthDialogResponse response, PushType pushType, PushCommand push) throws TransportException {
        try {
            RepositoryMonitor.resetFoundNewChanges(false);
            RepoHelper helper = this.theModel.getCurrentRepoHelper();
            if (response != null) {
                helper.ownerAuth = new UsernamePasswordCredentialsProvider(response.username, response.password);
            }
            if (pushType == PushType.BRANCH) {
                helper.pushCurrentBranch(push);
            } else if (pushType == PushType.ALL) {
                helper.pushAll(push);
            } else assert (false) : "PushType enum case not handled";
            this.gitStatus();
        }
        catch (InvalidRemoteException e) {
            this.showNoRemoteNotification();
        }
        catch (PushToAheadRemoteError e) {
            this.showPushToAheadRemoteNotification(e.isAllRefsRejected());
        }
        catch (TransportException e) {
            throw e;
        }
        catch (Exception e) {
            this.showGenericErrorNotification();
            e.printStackTrace();
        }
    }

    private RepoHelperBuilder.AuthDialogResponse askUserForCredentials() throws CancelledAuthorizationException {
        RepoHelperBuilder.AuthDialogResponse response = this.tryCommandAgainWithHTTPAuth ? RepoHelperBuilder.getAuthCredentialFromDialog() : null;
        return response;
    }

    public void handlePushTagsButton() {
        try {
            logger.info("Push tags button clicked");
            if (this.theModel.getCurrentRepoHelper() == null) {
                throw new NoRepoLoadedException();
            }
            final RepoHelperBuilder.AuthDialogResponse credentialResponse = this.askUserForCredentials();
            BusyWindow.show();
            BusyWindow.setLoadingText("Pushing tags...");
            Thread th = new Thread((Runnable)new Task<Void>(){

                protected Void call() {
                    SessionController.this.tryCommandAgainWithHTTPAuth = false;
                    try {
                        SessionController.this.handlePushTagsButtonDetails(credentialResponse);
                    }
                    catch (TransportException e) {
                        SessionController.this.determineIfTryAgain(e);
                    }
                    finally {
                        BusyWindow.hide();
                    }
                    if (SessionController.this.tryCommandAgainWithHTTPAuth) {
                        Platform.runLater(() -> SessionController.this.handlePushTagsButton());
                    }
                    return null;
                }
            });
            th.setDaemon(true);
            th.setName("Git push --tags");
            th.start();
        }
        catch (NoRepoLoadedException e) {
            this.showNoRepoLoadedNotification();
            this.setButtonsDisabled(true);
        }
        catch (CancelledAuthorizationException e) {
            this.showCommandCancelledNotification();
        }
    }

    private void handlePushTagsButtonDetails(RepoHelperBuilder.AuthDialogResponse response) throws TransportException {
        try {
            RepositoryMonitor.resetFoundNewChanges(false);
            RepoHelper helper = this.theModel.getCurrentRepoHelper();
            if (response != null) {
                helper.ownerAuth = new UsernamePasswordCredentialsProvider(response.username, response.password);
            }
            Iterable<PushResult> results = helper.pushTags();
            this.gitStatus();
            boolean upToDate = true;
            if (results == null) {
                upToDate = false;
            } else {
                for (PushResult result : results) {
                    for (RemoteRefUpdate update : result.getRemoteUpdates()) {
                        if (update.getStatus() != RemoteRefUpdate.Status.OK) continue;
                        upToDate = false;
                    }
                }
            }
            if (upToDate) {
                this.showTagsUpToDateNotification();
            } else {
                this.showTagsUpdatedNotification();
            }
        }
        catch (InvalidRemoteException e) {
            this.showNoRemoteNotification();
        }
        catch (PushToAheadRemoteError e) {
            this.showPushToAheadRemoteNotification(e.isAllRefsRejected());
        }
        catch (MissingRepoException e) {
            this.showMissingRepoNotification();
            this.setButtonsDisabled(true);
            this.refreshRecentReposInDropdown();
        }
        catch (TransportException e) {
            throw e;
        }
        catch (Exception e) {
            this.showGenericErrorNotification();
            e.printStackTrace();
        }
    }

    public boolean checkoutBranch(BranchHelper selectedBranch) {
        if (selectedBranch == null) {
            return false;
        }
        if (selectedBranch instanceof RemoteBranchHelper) {
            try {
                this.theModel.getCurrentRepoHelper().getBranchModel().trackRemoteBranch((RemoteBranchHelper)selectedBranch);
            }
            catch (RefAlreadyExistsException e) {
                this.showRefAlreadyExistsNotification();
            }
            catch (Exception e) {
                this.showGenericErrorNotification();
            }
        }
        try {
            selectedBranch.checkoutBranch();
            CommitTreeController.setBranchHeads(CommitTreeController.getCommitTreeModel(), this.theModel.getCurrentRepoHelper());
            CommitTreeController.focusCommitInGraph(this.theModel.getCurrentRepoHelper().getBranchModel().getCurrentBranchHead());
            this.gitStatus();
            return true;
        }
        catch (JGitInternalException e) {
            this.showJGitInternalError(e);
        }
        catch (CheckoutConflictException e) {
            this.showCheckoutConflictsNotification(e.getConflictingPaths());
        }
        catch (IOException | GitAPIException e) {
            this.showGenericErrorNotification();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBranch(BranchHelper selectedBranch) {
        BranchModel branchModel = this.theModel.getCurrentRepoHelper().getBranchModel();
        boolean authorizationSucceeded = true;
        try {
            if (selectedBranch != null) {
                if (selectedBranch instanceof LocalBranchHelper) {
                    branchModel.deleteLocalBranch((LocalBranchHelper)selectedBranch);
                    this.updateUser(selectedBranch.getRefName() + " deleted.");
                } else {
                    this.deleteRemoteBranch(selectedBranch, branchModel, message -> this.updateUser((String)message));
                }
            }
        }
        catch (NotMergedException e) {
            logger.warn("Can't delete branch because not merged warning");
            this.showNotMergedNotification(selectedBranch);
        }
        catch (CannotDeleteCurrentBranchException e) {
            logger.warn("Can't delete current branch warning");
            this.showCannotDeleteBranchNotification(selectedBranch);
        }
        catch (TransportException e) {
            this.showTransportExceptionNotification(e);
            authorizationSucceeded = false;
        }
        catch (GitAPIException e) {
            logger.warn("IO error");
            this.showGenericErrorNotification();
        }
        finally {
            this.gitStatus();
            if (authorizationSucceeded) {
                this.tryCommandAgainWithHTTPAuth = false;
            } else {
                this.tryCommandAgainWithHTTPAuth = true;
                this.deleteBranch(selectedBranch);
            }
        }
    }

    void deleteRemoteBranch(final BranchHelper selectedBranch, final BranchModel branchModel, final Consumer<String> updateFn) {
        try {
            final RepoHelperBuilder.AuthDialogResponse credentialResponse = this.askUserForCredentials();
            BusyWindow.show();
            BusyWindow.setLoadingText("Deleting remote branch...");
            Thread th = new Thread((Runnable)new Task<Void>(){

                protected Void call() {
                    SessionController.this.tryCommandAgainWithHTTPAuth = false;
                    try {
                        SessionController.this.deleteRemoteBranchDetails(credentialResponse, selectedBranch, branchModel, updateFn);
                    }
                    catch (TransportException e) {
                        SessionController.this.determineIfTryAgain(e);
                    }
                    finally {
                        BusyWindow.hide();
                    }
                    if (SessionController.this.tryCommandAgainWithHTTPAuth) {
                        Platform.runLater(() -> SessionController.this.deleteRemoteBranch(selectedBranch, branchModel, updateFn));
                    }
                    return null;
                }
            });
            th.setDaemon(true);
            th.setName("Git delete remote branch");
            th.start();
        }
        catch (CancelledAuthorizationException e) {
            this.showCommandCancelledNotification();
        }
    }

    private void deleteRemoteBranchDetails(RepoHelperBuilder.AuthDialogResponse response, BranchHelper selectedBranch, BranchModel branchModel, Consumer<String> updateFn) throws TransportException {
        try {
            if (response != null) {
                selectedBranch.repoHelper.ownerAuth = new UsernamePasswordCredentialsProvider(response.username, response.password);
            }
            RemoteRefUpdate.Status deleteStatus = branchModel.deleteRemoteBranch((RemoteBranchHelper)selectedBranch);
            String updateMessage = selectedBranch.getRefName();
            switch (deleteStatus) {
                case OK: {
                    updateMessage = updateMessage + " deleted.";
                    break;
                }
                case NON_EXISTING: {
                    updateMessage = updateMessage + " no longer\nexists on the server.\nFetch -p to remove " + updateMessage;
                }
                default: {
                    updateMessage = updateMessage + " deletion\nfailed.";
                }
            }
            updateFn.accept(updateMessage);
        }
        catch (TransportException e) {
            throw e;
        }
        catch (IOException | GitAPIException e) {
            logger.warn("IO error");
            this.showGenericErrorNotification();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceDeleteBranch(LocalBranchHelper branchToDelete) {
        BranchModel branchModel = this.theModel.getCurrentRepoHelper().getBranchModel();
        logger.info("Deleting local branch");
        try {
            if (branchToDelete != null) {
                branchModel.forceDeleteLocalBranch(branchToDelete);
                CommitTreeController.setBranchHeads(this.commitTreeModel, this.theModel.getCurrentRepoHelper());
                this.updateUser(" deleted.");
            }
        }
        catch (CannotDeleteCurrentBranchException e) {
            this.showCannotDeleteBranchNotification(branchToDelete);
        }
        catch (GitAPIException e) {
            this.showGenericErrorNotification();
        }
        finally {
            this.gitStatus();
        }
    }

    public void handleRevertMultipleButton(final List<CommitHelper> commits) {
        try {
            logger.info("Revert button clicked");
            if (this.theModel.getCurrentRepoHelper() == null) {
                throw new NoRepoLoadedException();
            }
            BusyWindow.show();
            BusyWindow.setLoadingText("Reverting...");
            Thread th = new Thread((Runnable)new Task<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Void call() {
                    try {
                        SessionController.this.theModel.getCurrentRepoHelper().revertHelpers(commits);
                        SessionController.this.gitStatus();
                    }
                    catch (MultipleParentsNotAllowedException e) {
                        for (CommitHelper commit : commits) {
                            if (commit.getParents().size() > 1) {
                                SessionController.this.showCantRevertMultipleParentsNotification();
                            }
                            if (commit.getParents().size() != 0) continue;
                            SessionController.this.showCantRevertZeroParentsNotification();
                        }
                    }
                    catch (InvalidRemoteException e) {
                        SessionController.this.showNoRemoteNotification();
                    }
                    catch (TransportException e) {
                        SessionController.this.showTransportExceptionNotification(e);
                    }
                    catch (MissingRepoException e) {
                        SessionController.this.showMissingRepoNotification();
                        SessionController.this.setButtonsDisabled(true);
                        SessionController.this.refreshRecentReposInDropdown();
                    }
                    catch (Exception e) {
                        SessionController.this.showGenericErrorNotification();
                        e.printStackTrace();
                    }
                    finally {
                        BusyWindow.hide();
                    }
                    return null;
                }
            });
            th.setDaemon(true);
            th.setName("Git revert");
            th.start();
        }
        catch (NoRepoLoadedException e) {
            this.showNoRepoLoadedNotification();
            this.setButtonsDisabled(true);
        }
    }

    public void handleRevertButton(final CommitHelper commit) {
        try {
            logger.info("Revert button clicked");
            if (this.theModel.getCurrentRepoHelper() == null) {
                throw new NoRepoLoadedException();
            }
            BusyWindow.show();
            BusyWindow.setLoadingText("Reverting...");
            Thread th = new Thread((Runnable)new Task<Void>(){

                protected Void call() {
                    try {
                        SessionController.this.theModel.getCurrentRepoHelper().revert(commit);
                        SessionController.this.gitStatus();
                    }
                    catch (MultipleParentsNotAllowedException e) {
                        if (commit.getParents().size() > 1) {
                            SessionController.this.showCantRevertMultipleParentsNotification();
                        }
                        if (commit.getParents().size() == 0) {
                            SessionController.this.showCantRevertZeroParentsNotification();
                        }
                    }
                    catch (InvalidRemoteException e) {
                        SessionController.this.showNoRemoteNotification();
                    }
                    catch (TransportException e) {
                        SessionController.this.showTransportExceptionNotification(e);
                    }
                    catch (MissingRepoException e) {
                        SessionController.this.showMissingRepoNotification();
                        SessionController.this.setButtonsDisabled(true);
                        SessionController.this.refreshRecentReposInDropdown();
                    }
                    catch (Exception e) {
                        SessionController.this.showGenericErrorNotification();
                        e.printStackTrace();
                    }
                    finally {
                        BusyWindow.hide();
                    }
                    return null;
                }
            });
            th.setDaemon(true);
            th.setName("Git revert");
            th.start();
        }
        catch (NoRepoLoadedException e) {
            this.showNoRepoLoadedNotification();
            this.setButtonsDisabled(true);
        }
    }

    public void handleResetButton(CommitHelper commit) {
        this.handleAdvancedResetButton(commit, ResetCommand.ResetType.MIXED);
    }

    public void handleAdvancedResetButton(final CommitHelper commit, final ResetCommand.ResetType type) {
        try {
            logger.info("Reset button clicked");
            if (this.theModel.getCurrentRepoHelper() == null) {
                throw new NoRepoLoadedException();
            }
            BusyWindow.show();
            BusyWindow.setLoadingText("Resetting...");
            Thread th = new Thread((Runnable)new Task<Void>(){

                protected Void call() {
                    try {
                        SessionController.this.theModel.getCurrentRepoHelper().reset(commit.getId(), type);
                        SessionController.this.gitStatus();
                    }
                    catch (InvalidRemoteException e) {
                        SessionController.this.showNoRemoteNotification();
                    }
                    catch (TransportException e) {
                        SessionController.this.showTransportExceptionNotification(e);
                    }
                    catch (MissingRepoException e) {
                        SessionController.this.showMissingRepoNotification();
                        SessionController.this.setButtonsDisabled(true);
                        SessionController.this.refreshRecentReposInDropdown();
                    }
                    catch (Exception e) {
                        SessionController.this.showGenericErrorNotification();
                        e.printStackTrace();
                    }
                    finally {
                        BusyWindow.hide();
                    }
                    return null;
                }
            });
            th.setDaemon(true);
            th.setName("Git reset");
            th.start();
        }
        catch (NoRepoLoadedException e) {
            this.showNoRepoLoadedNotification();
            this.setButtonsDisabled(true);
        }
    }

    public void handleStashSaveButton() {
        try {
            logger.info("Stash save button clicked");
            if (this.theModel.getCurrentRepoHelper() == null) {
                throw new NoRepoLoadedException();
            }
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/elegit/fxml/StashSave.fxml"));
            fxmlLoader.load();
            StashSaveController stashSaveController = (StashSaveController)fxmlLoader.getController();
            stashSaveController.setSessionController(this);
            AnchorPane fxmlRoot = (AnchorPane)fxmlLoader.getRoot();
            stashSaveController.showStage(fxmlRoot);
        }
        catch (IOException e) {
            this.showGenericErrorNotification();
            e.printStackTrace();
        }
        catch (NoRepoLoadedException e) {
            this.showNoRepoLoadedNotification();
            this.setButtonsDisabled(true);
        }
    }

    public void quickStashSave() {
        try {
            logger.info("Quick stash save button clicked");
            if (this.theModel.getCurrentRepoHelper() == null) {
                throw new NoRepoLoadedException();
            }
            this.theModel.getCurrentRepoHelper().stashSave(false);
            this.gitStatus();
        }
        catch (GitAPIException e) {
            this.showGenericErrorNotification();
            e.printStackTrace();
        }
        catch (NoFilesToStashException e) {
            this.showNoFilesToStashNotification();
        }
        catch (NoRepoLoadedException e) {
            this.setButtonsDisabled(true);
        }
    }

    public void handleStashApplyButton() {
        logger.info("Stash apply button clicked");
        try {
            CommitHelper topStash = this.theModel.getCurrentRepoHelper().stashList().get(0);
            this.theModel.getCurrentRepoHelper().stashApply(topStash.getId(), false);
            this.gitStatus();
        }
        catch (StashApplyFailureException e) {
            this.showStashConflictsNotification();
        }
        catch (GitAPIException e) {
            this.showGenericErrorNotification();
        }
        catch (IOException e) {
            this.showGenericErrorNotification();
        }
    }

    public void handleStashListButton() {
        try {
            logger.info("Stash list button clicked");
            if (this.theModel.getCurrentRepoHelper() == null) {
                throw new NoRepoLoadedException();
            }
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/elegit/fxml/StashList.fxml"));
            fxmlLoader.load();
            StashListController stashListController = (StashListController)fxmlLoader.getController();
            stashListController.setSessionController(this);
            AnchorPane fxmlRoot = (AnchorPane)fxmlLoader.getRoot();
            stashListController.showStage(fxmlRoot);
        }
        catch (IOException e) {
            this.showGenericErrorNotification();
            e.printStackTrace();
        }
        catch (NoRepoLoadedException e) {
            this.showNoRepoLoadedNotification();
            this.setButtonsDisabled(true);
        }
    }

    public void handleStashDropButton() {
        logger.info("Stash drop button clicked");
        try {
            this.theModel.getCurrentRepoHelper().stashDrop(0);
        }
        catch (GitAPIException e) {
            this.showGenericErrorNotification();
        }
    }

    public void handleFetchButton(boolean prune, boolean pull) {
        logger.info("Fetch button clicked");
        RepositoryMonitor.pause();
        this.gitFetch(prune, pull);
        RepositoryMonitor.unpause();
        this.submitLog();
    }

    public void handlePruneFetchButton() {
        this.handleFetchButton(true, false);
    }

    public void handleNormalFetchButton() {
        this.handleFetchButton(false, false);
    }

    public void handlePullButton() {
        this.handleFetchButton(false, true);
    }

    private synchronized void gitFetch(final boolean prune, final boolean pull) {
        try {
            if (this.theModel.getCurrentRepoHelper() == null) {
                throw new NoRepoLoadedException();
            }
            final RepoHelperBuilder.AuthDialogResponse response = this.askUserForCredentials();
            BusyWindow.show();
            BusyWindow.setLoadingText("Fetching...");
            Thread th = new Thread((Runnable)new Task<Void>(){

                protected Void call() {
                    SessionController.this.tryCommandAgainWithHTTPAuth = false;
                    try {
                        RepositoryMonitor.resetFoundNewChanges(false);
                        RepoHelper helper = SessionController.this.theModel.getCurrentRepoHelper();
                        if (response != null) {
                            helper.ownerAuth = new UsernamePasswordCredentialsProvider(response.username, response.password);
                        }
                        if (!helper.fetch(prune)) {
                            SessionController.this.showNoCommitsFetchedNotification();
                        }
                        if (pull) {
                            SessionController.this.mergeFromFetch();
                        }
                        SessionController.this.gitStatus();
                    }
                    catch (InvalidRemoteException e) {
                        SessionController.this.showNoRemoteNotification();
                    }
                    catch (TransportException e) {
                        SessionController.this.determineIfTryAgain(e);
                    }
                    catch (MissingRepoException e) {
                        SessionController.this.showMissingRepoNotification();
                        SessionController.this.setButtonsDisabled(true);
                        SessionController.this.refreshRecentReposInDropdown();
                    }
                    catch (Exception e) {
                        SessionController.this.showGenericErrorNotification();
                        e.printStackTrace();
                    }
                    finally {
                        BusyWindow.hide();
                    }
                    if (SessionController.this.tryCommandAgainWithHTTPAuth) {
                        Platform.runLater(() -> SessionController.this.gitFetch(prune, pull));
                    }
                    return null;
                }
            });
            th.setDaemon(true);
            th.setName("Git fetch");
            th.start();
        }
        catch (NoRepoLoadedException e) {
            this.showNoRepoLoadedNotification();
            this.setButtonsDisabled(true);
        }
        catch (CancelledAuthorizationException e) {
            this.showCommandCancelledNotification();
        }
    }

    public void mergeFromFetch() {
        this.mergeFromFetch(this.notificationPaneController, null);
    }

    public void mergeFromFetch(final NotificationController notificationController, final Stage stageToClose) {
        try {
            logger.info("Merge from fetch button clicked");
            if (this.theModel.getCurrentRepoHelper() == null) {
                throw new NoRepoLoadedException();
            }
            if (this.theModel.getCurrentRepoHelper().getBehindCount() < 1) {
                throw new NoCommitsToMergeException();
            }
            BusyWindow.show();
            BusyWindow.setLoadingText("Merging...");
            Thread th = new Thread((Runnable)new Task<Void>(){

                protected Void call() throws GitAPIException, IOException {
                    try {
                        if (!SessionController.this.theModel.getCurrentRepoHelper().mergeFromFetch().isSuccessful()) {
                            SessionController.this.showUnsuccessfulMergeNotification(notificationController);
                        } else if (stageToClose != null) {
                            Platform.runLater(() -> ((Stage)stageToClose).close());
                        }
                        SessionController.this.gitStatus();
                    }
                    catch (InvalidRemoteException e) {
                        SessionController.this.showNoRemoteNotification(notificationController);
                    }
                    catch (TransportException e) {
                        SessionController.this.showTransportExceptionNotification(notificationController, e);
                    }
                    catch (JGitInternalException | NoMergeBaseException e) {
                        e.printStackTrace();
                    }
                    catch (CheckoutConflictException e) {
                        SessionController.this.showMergingWithChangedFilesNotification(notificationController);
                    }
                    catch (ConflictingFilesException e) {
                        SessionController.this.showMergeConflictsNotification(notificationController);
                        Platform.runLater(() -> PopUpWindows.showMergeConflictsAlert(e.getConflictingFiles()));
                        ConflictingFileWatcher.watchConflictingFiles(SessionController.this.theModel.getCurrentRepoHelper());
                    }
                    catch (MissingRepoException e) {
                        SessionController.this.showMissingRepoNotification(notificationController);
                        SessionController.this.setButtonsDisabled(true);
                    }
                    catch (IOException | GitAPIException e) {
                        SessionController.this.showGenericErrorNotification(notificationController);
                        e.printStackTrace();
                    }
                    catch (NoTrackingException e) {
                        SessionController.this.showNoRemoteTrackingNotification(notificationController);
                    }
                    catch (Exception e) {
                        SessionController.this.showGenericErrorNotification(notificationController);
                        e.printStackTrace();
                    }
                    finally {
                        BusyWindow.hide();
                    }
                    return null;
                }
            });
            th.setDaemon(true);
            th.setName("Git merge FETCH_HEAD");
            th.start();
        }
        catch (NoRepoLoadedException e) {
            this.showNoRepoLoadedNotification(notificationController);
            this.setButtonsDisabled(true);
        }
        catch (NoCommitsToMergeException e) {
            this.showNoCommitsToMergeNotification(notificationController);
        }
        catch (IOException e) {
            this.showGenericErrorNotification(notificationController);
        }
    }

    public void handleLoggingOffMenuItem() {
        this.changeLogging(Level.OFF);
        PopOver popOver = new PopOver((Node)new Text("Toggled logging off"));
        popOver.setTitle("");
        popOver.show((Node)this.commitTreePanelView);
        popOver.detach();
        popOver.setAutoHide(true);
    }

    public void handleLoggingOnMenuItem() {
        this.changeLogging(Level.INFO);
        PopOver popOver = new PopOver((Node)new Text("Toggled logging on"));
        popOver.show((Node)this.commitTreePanelView);
        popOver.detach();
        popOver.setAutoHide(true);
        logger.log(Level.INFO, "Toggled logging on");
    }

    public void handleCommitSortTopological() {
        TreeLayout.commitSortTopological = true;
        try {
            this.commitTreeModel.updateView();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showGenericErrorNotification();
        }
    }

    public void handleCommitSortDate() {
        TreeLayout.commitSortTopological = false;
        try {
            this.commitTreeModel.updateView();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showGenericErrorNotification();
        }
    }

    public void handleGitIgnoreMenuItem() {
        GitIgnoreEditor.show(SessionModel.getSessionModel().getCurrentRepoHelper(), null);
    }

    public void handleNewBranchButton() {
        this.handleCreateOrDeleteBranchButton("create");
    }

    public void handleDeleteLocalBranchButton() {
        this.handleCreateOrDeleteBranchButton("local");
    }

    public void handleDeleteRemoteBranchButton() {
        this.handleCreateOrDeleteBranchButton("remote");
    }

    public void handleCreateOrDeleteBranchButton() {
        this.handleCreateOrDeleteBranchButton("create");
    }

    public void handleCreateOrDeleteBranchButton(String tab) {
        try {
            logger.info("Create/delete branch button clicked");
            if (this.theModel.getCurrentRepoHelper() == null) {
                throw new NoRepoLoadedException();
            }
            logger.info("Opened create/delete branch window");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/elegit/fxml/CreateDeleteBranchWindow.fxml"));
            fxmlLoader.load();
            CreateDeleteBranchWindowController createDeleteBranchController = (CreateDeleteBranchWindowController)fxmlLoader.getController();
            createDeleteBranchController.setSessionController(this);
            AnchorPane fxmlRoot = (AnchorPane)fxmlLoader.getRoot();
            createDeleteBranchController.showStage(fxmlRoot, tab);
        }
        catch (IOException e) {
            this.showGenericErrorNotification();
            e.printStackTrace();
        }
        catch (NoRepoLoadedException e) {
            this.showNoRepoLoadedNotification();
            this.setButtonsDisabled(true);
        }
    }

    public void handleCommitNameCopyButton() {
        logger.info("Commit name copied");
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        content.putString(this.commitInfoNameText);
        clipboard.setContent((Map)content);
    }

    public void handleGoToCommitButton() {
        logger.info("Go to commit button clicked");
        String id = this.commitInfoNameText;
        CommitTreeController.focusCommitInGraph(id);
    }

    public void handleMergeFromFetchButton() {
        this.handleGeneralMergeButton(false);
    }

    public void handleBranchMergeButton() {
        this.handleGeneralMergeButton(true);
    }

    public void handleGeneralMergeButton(boolean localTabOpen) {
        try {
            logger.info("Merge button clicked");
            if (this.theModel.getCurrentRepoHelper() == null) {
                throw new NoRepoLoadedException();
            }
            logger.info("Opened merge window");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/elegit/fxml/MergeWindow.fxml"));
            fxmlLoader.load();
            MergeWindowController mergeWindowController = (MergeWindowController)fxmlLoader.getController();
            mergeWindowController.setSessionController(this);
            AnchorPane fxmlRoot = (AnchorPane)fxmlLoader.getRoot();
            mergeWindowController.showStage(fxmlRoot, localTabOpen);
        }
        catch (IOException e) {
            this.showGenericErrorNotification();
            e.printStackTrace();
        }
        catch (NoRepoLoadedException e) {
            this.showNoRepoLoadedNotification();
            this.setButtonsDisabled(true);
        }
    }

    public void onRefreshButton() {
        logger.info("Git status button clicked");
        this.showUpdatingText(true);
        this.gitStatus();
        this.showUpdatingText(false);
        CommitTreeController.focusCommitInGraph(this.theModel.getCurrentRepoHelper().getBranchModel().getCurrentBranchHead());
    }

    private void showUpdatingText(boolean setVisible) {
        if (setVisible) {
            this.isGitStatusDone = false;
            this.isTimerDone = false;
            this.updatingText.setVisible(true);
            Timer timer = new Timer(true);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (SessionController.this.isGitStatusDone) {
                        SessionController.this.updatingText.setVisible(false);
                    }
                    SessionController.this.isTimerDone = true;
                }
            }, 750L);
        } else {
            this.isGitStatusDone = true;
            if (this.isTimerDone) {
                this.updatingText.setVisible(false);
            }
        }
    }

    public void gitStatus() {
        RepositoryMonitor.pause();
        Platform.runLater(() -> {
            if (this.commitTreePanelView.isLayoutThreadRunning) {
                RepositoryMonitor.unpause();
                return;
            }
            try {
                this.theModel.getCurrentRepoHelper().getBranchModel().updateAllBranches();
                this.commitTreeModel.update();
                this.workingTreePanelView.drawDirectoryView();
                this.allFilesPanelView.drawDirectoryView();
                this.theModel.getCurrentRepoHelper().getTagModel().updateTags();
                this.updateStatusText();
            }
            catch (Exception e) {
                this.showGenericErrorNotification();
                e.printStackTrace();
            }
            finally {
                RepositoryMonitor.unpause();
            }
        });
    }

    public void handleRemoteMouseClick(MouseEvent event) {
        if (event.getButton() != MouseButton.PRIMARY) {
            return;
        }
        try {
            if (this.theModel.getCurrentRepoHelper() == null) {
                throw new NoRepoLoadedException();
            }
            if (!this.theModel.getCurrentRepoHelper().exists()) {
                throw new MissingRepoException();
            }
            List<String> remoteURLs = this.theModel.getCurrentRepoHelper().getLinkedRemoteRepoURLs();
            if (remoteURLs.size() == 0) {
                this.showNoRemoteNotification();
            }
            for (String remoteURL : remoteURLs) {
                if (remoteURL.contains("@")) {
                    remoteURL = "https://" + remoteURL.replace(":", "/").split("@")[1];
                }
                if (!SystemUtils.IS_OS_LINUX) {
                    Desktop desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                    if (desktop == null || !desktop.isSupported(Desktop.Action.BROWSE)) continue;
                    desktop.browse(new URI(remoteURL));
                    continue;
                }
                Runtime runtime = Runtime.getRuntime();
                String[] args = new String[]{"xdg-open", remoteURL};
                runtime.exec(args);
            }
        }
        catch (IOException | URISyntaxException e) {
            this.showGenericErrorNotification();
        }
        catch (MissingRepoException e) {
            this.showMissingRepoNotification();
            this.setButtonsDisabled(true);
            this.refreshRecentReposInDropdown();
        }
        catch (NoRepoLoadedException e) {
            this.showNoRepoLoadedNotification();
            this.setButtonsDisabled(true);
        }
    }

    private void updateUser(String type) {
        Platform.runLater(() -> {
            Text txt = new Text(" Branch " + type);
            PopOver popOver = new PopOver((Node)txt);
            popOver.setTitle("");
            popOver.show((Node)this.commitTreePanelView);
            popOver.detach();
            popOver.setAutoHide(true);
        });
    }

    public void openRepoDirectory() {
        if (Desktop.isDesktopSupported()) {
            try {
                logger.info("Opening Repo Directory");
                if (this.theModel.getCurrentRepoHelper() == null) {
                    throw new NoRepoLoadedException();
                }
                if (!SystemUtils.IS_OS_LINUX) {
                    Desktop.getDesktop().open(this.theModel.getCurrentRepoHelper().localPath.toFile());
                } else {
                    Runtime runtime = Runtime.getRuntime();
                    String[] args = new String[]{"nautilus", this.theModel.getCurrentRepoHelper().localPath.toFile().toString()};
                    runtime.exec(args);
                }
            }
            catch (IOException | IllegalArgumentException e) {
                this.showFailedToOpenLocalNotification();
                e.printStackTrace();
            }
            catch (NoRepoLoadedException e) {
                this.showNoRepoLoadedNotification();
                this.setButtonsDisabled(true);
            }
        }
    }

    public void chooseRecentReposToDelete() {
        logger.info("Remove repos button clicked");
        List<RepoHelper> repoHelpers = this.theModel.getAllRepoHelpers();
        CheckListView repoCheckListView = new CheckListView(FXCollections.observableArrayList(repoHelpers));
        Button removeSelectedButton = new Button("Remove repository shortcuts from Elegit");
        PopOver popover = new PopOver((Node)new VBox(new Node[]{repoCheckListView, removeSelectedButton}));
        popover.setTitle("Manage Recent Repositories");
        popover.show((Node)this.dropdownController.removeRecentReposButton);
        removeSelectedButton.setOnAction(e -> {
            this.handleRemoveReposButton((List<RepoHelper>)repoCheckListView.getCheckModel().getCheckedItems());
            popover.hide();
        });
    }

    private void handleRemoveReposButton(List<RepoHelper> checkedItems) {
        logger.info("Removed repos");
        this.theModel.removeRepoHelpers(checkedItems);
        if (!this.theModel.getAllRepoHelpers().isEmpty() && !this.theModel.getAllRepoHelpers().contains(this.theModel.getCurrentRepoHelper())) {
            int newIndex = this.theModel.getAllRepoHelpers().size() - 1;
            RepoHelper newCurrentRepo = this.theModel.getAllRepoHelpers().get(newIndex);
            this.handleRecentRepoMenuItem(newCurrentRepo);
            this.dropdownController.repoDropdownSelector.setValue((Object)newCurrentRepo);
            this.refreshRecentReposInDropdown();
        } else if (this.theModel.getAllRepoHelpers().isEmpty()) {
            TreeLayout.stopMovingCells();
            this.theModel.resetSessionModel();
            this.workingTreePanelView.resetFileStructurePanelView();
            this.allFilesPanelView.resetFileStructurePanelView();
            this.initialize();
        } else {
            try {
                this.theModel.openRepoFromHelper(this.theModel.getCurrentRepoHelper());
            }
            catch (MissingRepoException | IOException | ClassNotFoundException | BackingStoreException e1) {
                e1.printStackTrace();
            }
        }
        this.refreshRecentReposInDropdown();
    }

    public void showBranchCheckout() {
        try {
            logger.info("Branch checkout clicked");
            if (this.theModel.getCurrentRepoHelper() == null) {
                throw new NoRepoLoadedException();
            }
            logger.info("Opened branch checkout window");
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/elegit/fxml/BranchCheckout.fxml"));
            fxmlLoader.load();
            BranchCheckoutController branchCheckoutController = (BranchCheckoutController)fxmlLoader.getController();
            AnchorPane fxmlRoot = (AnchorPane)fxmlLoader.getRoot();
            branchCheckoutController.showStage(fxmlRoot);
        }
        catch (IOException e) {
            this.showGenericErrorNotification();
            e.printStackTrace();
        }
        catch (NoRepoLoadedException e) {
            this.showNoRepoLoadedNotification();
            this.setButtonsDisabled(true);
        }
    }

    public void showLegend() {
        try {
            logger.info("Legend clicked");
            GridPane fxmlRoot = (GridPane)FXMLLoader.load((URL)this.getClass().getResource("/elegit/fxml/Legend.fxml"));
            Stage stage = new Stage();
            stage.setTitle("Legend");
            stage.setScene(new Scene((Parent)fxmlRoot));
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setOnCloseRequest(event -> logger.info("Closed legend"));
            stage.show();
        }
        catch (IOException e) {
            this.showGenericErrorNotification();
            e.printStackTrace();
        }
    }

    public void selectCommit(String id) {
        Platform.runLater(() -> {
            CommitHelper commit = this.theModel.getCurrentRepoHelper().getCommit(id);
            this.commitInfoNameText = commit.getName();
            this.commitInfoMessageText.setVisible(true);
            this.commitInfoNameCopyButton.setVisible(true);
            this.commitInfoGoToButton.setVisible(true);
            this.tagNameField.setVisible(true);
            this.tagButton.setVisible(true);
            this.commitInfoMessageText.setText(this.theModel.getCurrentRepoHelper().getCommitDescriptorString(commit, true));
        });
    }

    public void clearSelectedCommit() {
        Platform.runLater(() -> {
            this.commitInfoMessageText.setText("");
            this.commitInfoMessageText.setVisible(false);
            this.commitInfoNameCopyButton.setVisible(false);
            this.commitInfoGoToButton.setVisible(false);
            this.tagNameField.setText("");
            this.tagNameField.setVisible(false);
            this.tagButton.setVisible(false);
        });
    }

    private void showGenericErrorNotification(NotificationController nc) {
        Platform.runLater(() -> {
            logger.warn("Generic error warning.");
            nc.addNotification("Sorry, there was an error.");
        });
    }

    void showGenericErrorNotification() {
        Platform.runLater(() -> {
            logger.warn("Generic error warning.");
            this.notificationPaneController.addNotification("Sorry, there was an error.");
        });
    }

    private void showJGitInternalError(JGitInternalException e) {
        Platform.runLater(() -> {
            if (e.getCause().toString().contains("LockFailedException")) {
                logger.warn("Lock failed warning.");
                this.notificationPaneController.addNotification(e.getCause().getMessage() + ". If no other git processes are running, manually remove all .lock files.");
            } else {
                logger.warn("Generic jgit internal warning.");
                this.notificationPaneController.addNotification("Sorry, there was a Git error.");
            }
        });
    }

    private void showNoRepoLoadedNotification(NotificationController nc) {
        Platform.runLater(() -> {
            logger.warn("No repo loaded warning.");
            nc.addNotification("You need to load a repository before you can perform operations on it. Click on the plus sign in the upper left corner!");
        });
    }

    private void showNoRepoLoadedNotification() {
        Platform.runLater(() -> {
            logger.warn("No repo loaded warning.");
            this.notificationPaneController.addNotification("You need to load a repository before you can perform operations on it. Click on the plus sign in the upper left corner!");
        });
    }

    private void showInvalidRepoNotification() {
        Platform.runLater(() -> {
            logger.warn("Invalid repo warning.");
            this.notificationPaneController.addNotification("Make sure the directory you selected contains an existing (non-bare) Git repository.");
        });
    }

    private void showMissingRepoNotification(NotificationController nc) {
        Platform.runLater(() -> {
            logger.warn("Missing repo warning");
            nc.addNotification("That repository no longer exists.");
        });
    }

    private void showMissingRepoNotification() {
        Platform.runLater(() -> {
            logger.warn("Missing repo warning");
            this.notificationPaneController.addNotification("That repository no longer exists.");
        });
    }

    private void showNoRemoteNotification(NotificationController nc) {
        Platform.runLater(() -> {
            logger.warn("No remote repo warning");
            String name = this.theModel.getCurrentRepoHelper() != null ? this.theModel.getCurrentRepoHelper().toString() : "the current repository";
            nc.addNotification("There is no remote repository associated with " + name);
        });
    }

    private void showNoRemoteNotification() {
        Platform.runLater(() -> {
            logger.warn("No remote repo warning");
            String name = this.theModel.getCurrentRepoHelper() != null ? this.theModel.getCurrentRepoHelper().toString() : "the current repository";
            this.notificationPaneController.addNotification("There is no remote repository associated with " + name);
        });
    }

    private void showFailedToOpenLocalNotification() {
        Platform.runLater(() -> {
            logger.warn("Failed to load local repo warning");
            String path = this.theModel.getCurrentRepoHelper() != null ? this.theModel.getCurrentRepoHelper().getLocalPath().toString() : "the location of the local repository";
            this.notificationPaneController.addNotification("Could not open directory at " + path);
        });
    }

    private void showNonEmptyFolderNotification(Runnable callback) {
        Platform.runLater(() -> {
            logger.warn("Folder alread exists warning");
            this.notificationPaneController.addNotification("Make sure a folder with that name doesn't already exist in that location");
        });
    }

    private void showInvalidRemoteNotification(Runnable callback) {
        Platform.runLater(() -> {
            logger.warn("Invalid remote warning");
            this.notificationPaneController.addNotification("Make sure you entered the correct remote URL.");
        });
    }

    private void showInvalidTagNameNotification(String tagName) {
        Platform.runLater(() -> {
            logger.warn("Invalid tag name exception");
            this.notificationPaneController.addNotification("The tag name '" + tagName + "' is invalid.\nRemove any of .~^:?*[]{}@ and try again.");
        });
    }

    private void showTransportExceptionNotification(TransportException e) {
        Platform.runLater(() -> this.showTransportExceptionNotification(this.notificationPaneController, e));
    }

    private void showTransportExceptionNotification(NotificationController nc, TransportException e) {
        Platform.runLater(() -> {
            if (e.getMessage().endsWith("git-receive-pack not permitted")) {
                logger.warn("Invalid authorization for repo warning");
                this.notificationPaneController.addNotification("Your login is correct, but you do not have permission to do this operation to this repository.");
            } else if (e.getMessage().endsWith("git-receive-pack not found")) {
                logger.warn("Remote repo couldn't be found warning");
                this.notificationPaneController.addNotification("The push failed because the remote repository couldn't be found.");
            } else if (e.getMessage().endsWith("not authorized")) {
                logger.warn("Invalid authorization warning");
                nc.addNotification("The username/password combination you have provided is incorrect. Try reentering your password.");
            } else {
                logger.warn("Transport exception");
                nc.addNotification("Error in connecting: " + e.getMessage());
            }
        });
    }

    private void showRepoWasNotLoadedNotification() {
        Platform.runLater(() -> {
            logger.warn("Repo not loaded warning");
            this.notificationPaneController.addNotification("Something went wrong, so no repository was loaded.");
        });
    }

    private void showPushToAheadRemoteNotification(boolean allRefsRejected) {
        Platform.runLater(() -> {
            logger.warn("Remote ahead of local warning");
            if (allRefsRejected) {
                this.notificationPaneController.addNotification("The remote repository is ahead of the local. You need to fetch and then merge (pull) before pushing.");
            } else {
                this.notificationPaneController.addNotification("You need to fetch/merge in order to push all of your changes.");
            }
        });
    }

    private void showLostRemoteNotification() {
        Platform.runLater(() -> {
            logger.warn("Remote repo couldn't be found warning");
            this.notificationPaneController.addNotification("The push failed because the remote repository couldn't be found.");
        });
    }

    private void showSameRepoLoadedNotification() {
        Platform.runLater(() -> {
            logger.warn("Same repo loaded");
            this.notificationPaneController.addNotification("That repository is already open");
        });
    }

    private void showNoFilesStagedForCommitNotification() {
        Platform.runLater(() -> {
            logger.warn("No files staged for commit warning");
            this.notificationPaneController.addNotification("You need to add files before commiting");
        });
    }

    private void showNoFilesSelectedForAddNotification() {
        Platform.runLater(() -> {
            logger.warn("No files selected for add warning");
            this.notificationPaneController.addNotification("You need to select files to add");
        });
    }

    private void showStagedFilesSelectedNotification() {
        Platform.runLater(() -> {
            logger.warn("Staged files selected for commit warning");
            this.notificationPaneController.addNotification("You can't add staged files!");
        });
    }

    private void showNoFilesSelectedForRemoveNotification() {
        Platform.runLater(() -> {
            logger.warn("No files staged for remove warning");
            this.notificationPaneController.addNotification("You need select files to remove");
        });
    }

    private void showCannotAddFileNotification(String filename) {
        Platform.runLater(() -> {
            logger.warn("Cannot add file notification");
            this.notificationPaneController.addNotification("Cannot add " + filename + ". It might already be added (staged).");
        });
    }

    private void showCannotRemoveFileNotification(String filename) {
        Platform.runLater(() -> {
            logger.warn("Cannot remove file notification");
            this.notificationPaneController.addNotification("Cannot remove " + filename + " because it hasn't been staged yet.");
        });
    }

    private void showNoTagNameNotification() {
        Platform.runLater(() -> {
            logger.warn("No tag name warning");
            this.notificationPaneController.addNotification("You need to write a tag name in order to tag the commit");
        });
    }

    private void showNoCommitsToPushNotification() {
        Platform.runLater(() -> {
            logger.warn("No local commits to push warning");
            this.notificationPaneController.addNotification("There aren't any local commits to push");
        });
    }

    private void showTagsUpToDateNotification() {
        Platform.runLater(() -> {
            logger.warn("Tags up to date notification");
            this.notificationPaneController.addNotification("Tags are up to date with the remote");
        });
    }

    private void showTagsUpdatedNotification() {
        Platform.runLater(() -> {
            logger.warn("Tags updated notification");
            this.notificationPaneController.addNotification("Tags were updated");
        });
    }

    private void showNoCommitsFetchedNotification() {
        Platform.runLater(() -> {
            logger.warn("No commits fetched warning");
            this.notificationPaneController.addNotification("No new commits were fetched");
        });
    }

    private void showTagExistsNotification() {
        Platform.runLater(() -> {
            logger.warn("Tag already exists warning.");
            this.notificationPaneController.addNotification("Sorry that tag already exists in this repository.");
        });
    }

    private void showCantRevertMultipleParentsNotification() {
        Platform.runLater(() -> {
            logger.warn("Tried to revert commit with multiple parents.");
            this.notificationPaneController.addNotification("You cannot revert that commit because it has more than one parent.");
        });
    }

    private void showCantRevertZeroParentsNotification() {
        Platform.runLater(() -> {
            logger.warn("Tried to revert commit with zero parents.");
            this.notificationPaneController.addNotification("You cannot revert that commit because it has zero parents.");
        });
    }

    private void showCommandCancelledNotification() {
        Platform.runLater(() -> {
            logger.warn("Command cancelled.");
            this.notificationPaneController.addNotification("Command cancelled.");
        });
    }

    private void showCannotDeleteBranchNotification(BranchHelper branch) {
        Platform.runLater(() -> {
            logger.warn("Cannot delete current branch notification");
            this.notificationPaneController.addNotification(String.format("Sorry, %s can't be deleted right now. Try checking out a different branch first.", branch.getRefName()));
        });
    }

    private void showNotMergedNotification(BranchHelper nonmergedBranch) {
        logger.warn("Not merged notification");
        this.notificationPaneController.addNotification("That branch has to be merged before you can do that.");
    }

    private void showStashConflictsNotification() {
        Platform.runLater(() -> {
            logger.warn("Stash apply conflicts warning");
            EventHandler handler = event -> this.quickStashSave();
            this.notificationPaneController.addNotification("You can't apply that stash because there would be conflicts. Stash your changes or resolve conflicts first.", "stash", handler);
        });
    }

    private void showCheckoutConflictsNotification(List<String> conflictingPaths) {
        Platform.runLater(() -> {
            logger.warn("Checkout conflicts warning");
            EventHandler handler = event -> this.quickStashSave();
            this.notificationPaneController.addNotification("You can't switch to that branch because there would be a merge conflict. Stash your changes or resolve conflicts first.", "stash", handler);
        });
    }

    private void showRefAlreadyExistsNotification() {
        logger.info("Branch already exists notification");
        this.notificationPaneController.addNotification("Looks like that branch already exists locally!");
    }

    private void showUnsuccessfulMergeNotification(NotificationController nc) {
        Platform.runLater(() -> {
            logger.warn("Failed merged warning");
            nc.addNotification("Merging failed");
        });
    }

    private void showMergingWithChangedFilesNotification(NotificationController nc) {
        Platform.runLater(() -> {
            logger.warn("Can't merge with modified files warning");
            nc.addNotification("Can't merge with modified files present, please add/commit before merging.");
        });
    }

    private void showMergeConflictsNotification(NotificationController nc) {
        Platform.runLater(() -> {
            logger.warn("Merge conflict warning");
            nc.addNotification("Can't complete merge due to conflicts. Resolve the conflicts and commit all files to complete merging");
        });
    }

    private void showNoRemoteTrackingNotification(NotificationController nc) {
        Platform.runLater(() -> {
            logger.warn("No remote tracking for current branch notification.");
            nc.addNotification("There is no remote tracking information for the current branch.");
        });
    }

    private void showNoCommitsToMergeNotification(NotificationController nc) {
        Platform.runLater(() -> {
            logger.warn("No commits to merge warning");
            nc.addNotification("There aren't any commits to merge. Try fetching first");
        });
    }

    private void showNoFilesToStashNotification() {
        Platform.runLater(() -> {
            logger.warn("No files to stash warning");
            this.notificationPaneController.addNotification("There are no files to stash.");
        });
    }

    private void submitLog() {
        try {
            String lastUUID = this.theModel.getLastUUID();
            this.theModel.setLastUUID(this.d.submitData(lastUUID));
        }
        catch (IOException | ClassNotFoundException | BackingStoreException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            try {
                this.theModel.setLastUUID("");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void loadLogging() {
        Platform.runLater(() -> {
            Level storedLevel = this.getLoggingLevel();
            if (storedLevel == null) {
                storedLevel = PopUpWindows.getLoggingPermissions() ? Level.INFO : Level.OFF;
            }
            this.changeLogging(storedLevel);
            logger.info("Starting up.");
        });
    }

    void changeLogging(Level level) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        loggerConfig.setLevel(level);
        ctx.updateLoggers();
        this.setLoggingLevelPref(level);
    }

    Level getLoggingLevel() {
        try {
            return (Level)PrefObj.getObject(this.preferences, LOGGING_LEVEL_KEY);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    void setLoggingLevelPref(Level level) {
        try {
            PrefObj.putObject(this.preferences, LOGGING_LEVEL_KEY, level);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        logger = LogManager.getLogger(SessionController.class);
    }

    public static enum PushType {
        BRANCH,
        ALL;

    }

    private static enum CommitType {
        NORMAL,
        ALL;

    }
}

