/*
 * Decompiled with CFR 0.152.
 */
package elegit.controllers;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.GlyphsDude;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import elegit.controllers.SessionController;
import java.util.Timer;
import java.util.TimerTask;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Line;
import javafx.scene.text.Text;
import javafx.stage.PopupWindow;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.PopOver;

public class NotificationController {
    private static final int MIN_SCROLLPANE_HEIGHT = 20;
    private static final int BUTTON_WIDTH = 85;
    @FXML
    StackPane notificationPane;
    @FXML
    AnchorPane latestNotification;
    @FXML
    StackPane notificationListPane;
    @FXML
    ScrollPane notificationList;
    @FXML
    AnchorPane notificationListUI;
    @FXML
    Line resizeLine;
    @FXML
    Line separatorLine;
    @FXML
    Button minimizeButton;
    @FXML
    Label notificationNum;
    @FXML
    HBox latestNotificationBox;
    private PopOver notificationAlert;
    private TimerTask hideBubbleTask;
    private Stage anchor;
    static final Logger logger = LogManager.getLogger(SessionController.class);

    public void initialize() {
        this.notificationListPane.setVisible(false);
        this.notificationListPane.setMouseTransparent(true);
        this.latestNotification.setOnMouseClicked(this::handleNotificationPane);
        this.resizeLine.setOnMouseDragged(this::handleLineDragged);
        this.minimizeButton.setOnMouseClicked(event -> this.hideNotificationList());
        this.minimizeButton.boundsInParentProperty().addListener((observable, oldValue, newValue) -> this.resizeLine.setEndX(newValue.getMinX() + 85.0));
        this.separatorLine.endXProperty().bind((ObservableValue)this.resizeLine.endXProperty());
        this.notificationListUI.setPickOnBounds(false);
        this.notificationPane.setPickOnBounds(false);
        this.notificationNum.setPickOnBounds(false);
    }

    public void setAnchor(Stage stage) {
        this.anchor = stage;
    }

    private PopOver updateNotificationBubble(String notification) {
        Text notifcationText = new Text(notification);
        notifcationText.setWrappingWidth(230.0);
        notifcationText.setStyle("-fx-font-weight: bold");
        HBox hBox = new HBox(new Node[]{notifcationText});
        hBox.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        hBox.setOnMouseClicked(event -> this.showNotificationList());
        PopOver popOver = new PopOver((Node)hBox);
        popOver.setTitle("New Notification");
        popOver.setArrowLocation(PopOver.ArrowLocation.BOTTOM_RIGHT);
        popOver.setAnchorLocation(PopupWindow.AnchorLocation.CONTENT_BOTTOM_RIGHT);
        return popOver;
    }

    private void handleNotificationPane(MouseEvent e) {
        if (e.getTarget().toString().contains("ImageView")) {
            this.toggleNotificationList();
        } else if (e.getClickCount() > 1) {
            this.toggleNotificationList();
        }
    }

    private void handleLineDragged(MouseEvent e) {
        if (this.notificationList.getHeight() < 20.0 || e.getSceneY() > this.notificationList.getScene().getHeight() - 20.0) {
            this.notificationList.setPrefHeight(20.0);
            this.hideNotificationList();
            return;
        }
        if (e.getSceneY() < this.notificationList.getScene().getHeight() - 20.0) {
            this.showNotificationList();
        }
        this.notificationList.setPrefHeight(this.notificationList.getHeight() - e.getY());
    }

    void toggleNotificationList() {
        this.notificationListPane.setVisible(!this.notificationListPane.isVisible());
        this.notificationListPane.setMouseTransparent(!this.notificationListPane.isMouseTransparent());
        this.latestNotification.setVisible(!this.latestNotification.isVisible());
        if (this.notificationListPane.isVisible()) {
            this.hideBubble();
        }
    }

    private void hideNotificationList() {
        if (this.isListPaneVisible()) {
            this.toggleNotificationList();
        }
    }

    private void showNotificationList() {
        if (!this.isListPaneVisible()) {
            this.toggleNotificationList();
            this.hideBubble();
        }
    }

    boolean isListPaneVisible() {
        return this.notificationListPane.isVisible();
    }

    void addNotification(String notification) {
        Label line = this.makeNotificationLabel(notification);
        this.setLatestNotification(this.makeLatestNotificationLabel(line));
        this.showBubble(notification);
        VBox vBox = (VBox)this.notificationList.getContent();
        vBox.getChildren().add(0, (Object)line);
        this.setNotificationNum();
    }

    void addNotification(String notification, String actionText, EventHandler handler) {
        HBox box = new HBox();
        Label line = this.makeNotificationLabel(notification);
        this.showBubble(notification);
        Button actionButton = new Button(actionText);
        actionButton.setId("notification");
        actionButton.setOnMouseClicked(handler);
        this.setLatestNotification(this.makeLatestNotificationLabel(line), this.makeLatestNotificationButton(actionButton));
        line.setOnMouseClicked(event -> {
            if (event.getTarget().equals(line.getGraphic())) {
                this.removeNotification((Region)box);
            }
        });
        box.setSpacing(5.0);
        box.getChildren().add((Object)line);
        box.getChildren().add((Object)actionButton);
        VBox vBox = (VBox)this.notificationList.getContent();
        vBox.getChildren().add(0, (Object)box);
        this.setNotificationNum();
    }

    private Label makeNotificationLabel(String notification) {
        Label line = new Label(notification);
        line.setWrapText(true);
        line.setId("notification");
        line.setGraphic((Node)GlyphsDude.createIcon((GlyphIcons)FontAwesomeIcon.TIMES_CIRCLE));
        line.setOnMouseClicked(event -> {
            if (event.getTarget().equals(line.getGraphic())) {
                this.removeNotification((Region)line);
            }
        });
        return line;
    }

    private Label makeLatestNotificationLabel(Label notification) {
        Label line = new Label(notification.getText());
        line.setWrapText(true);
        line.setId("notification");
        return line;
    }

    private Button makeLatestNotificationButton(Button action) {
        Button latestActionButton = new Button(action.getText());
        latestActionButton.setId("notification");
        latestActionButton.setOnMouseClicked(action.getOnMouseClicked());
        return latestActionButton;
    }

    void bindParentBounds(ReadOnlyDoubleProperty parentHeight) {
        this.notificationPane.maxHeightProperty().bind((ObservableValue)parentHeight.divide(1.1));
    }

    @FXML
    void clearAllNotifications() {
        VBox vBox = (VBox)this.notificationList.getContent();
        vBox.getChildren().clear();
        this.setLatestNotification(null);
        this.setNotificationNum();
    }

    private void removeNotification(Region notification) {
        VBox vBox = (VBox)this.notificationList.getContent();
        if (vBox.getChildren().indexOf((Object)notification) == 0) {
            if (vBox.getChildren().size() > 1) {
                if (vBox.getChildren().get(1) instanceof HBox) {
                    HBox box = (HBox)vBox.getChildren().get(1);
                    this.setLatestNotification(this.makeLatestNotificationLabel((Label)box.getChildren().get(0)), this.makeLatestNotificationButton((Button)box.getChildren().get(1)));
                } else {
                    this.setLatestNotification(this.makeLatestNotificationLabel((Label)vBox.getChildren().get(1)));
                }
            } else {
                this.setLatestNotification(null);
            }
        }
        vBox.getChildren().remove((Object)notification);
        this.setNotificationNum();
    }

    private void setLatestNotification(Label notificationLabel) {
        if (notificationLabel != null) {
            this.latestNotificationBox.getChildren().setAll((Object[])new Node[]{notificationLabel});
        } else {
            this.latestNotificationBox.getChildren().clear();
        }
    }

    private void setLatestNotification(Label notificationLabel, Button notificationButton) {
        try {
            this.latestNotificationBox.getChildren().setAll((Object[])new Node[]{notificationLabel, notificationButton});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setNotificationNum() {
        int num = ((VBox)this.notificationList.getContent()).getChildren().size();
        if (num > 0) {
            this.notificationNum.setText(num + "");
        } else {
            this.notificationNum.setText("");
        }
    }

    private void showBubble(String notification) {
        if (!this.isListPaneVisible()) {
            this.notificationAlert = this.updateNotificationBubble(notification);
            this.notificationAlert.show((Window)this.anchor, this.anchor.getX() + this.anchor.getWidth() - 15.0, this.anchor.getY() + this.anchor.getHeight() - 15.0);
            this.notificationAlert.detach();
            this.notificationAlert.setAutoHide(true);
            this.hideBubbleTask();
        }
    }

    private void hideBubbleTask() {
        if (this.hideBubbleTask != null) {
            this.hideBubbleTask.cancel();
        }
        Timer timer = new Timer(true);
        this.hideBubbleTask = new TimerTask(){

            @Override
            public void run() {
                NotificationController.this.hideBubble();
            }
        };
        timer.schedule(this.hideBubbleTask, 4000L);
    }

    private void hideBubble() {
        if (this.notificationAlert != null) {
            this.notificationAlert.hide();
        }
    }
}

