/*
 * Decompiled with CFR 0.152.
 */
package elegit.controllers;

import elegit.BranchModel;
import elegit.CommitTreeController;
import elegit.CommitTreeModel;
import elegit.ConflictingFileWatcher;
import elegit.LocalBranchHelper;
import elegit.PopUpWindows;
import elegit.RemoteBranchHelper;
import elegit.RepoHelper;
import elegit.SessionModel;
import elegit.controllers.NotificationController;
import elegit.controllers.SessionController;
import java.io.IOException;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.lib.BranchTrackingStatus;
import org.eclipse.jgit.lib.Repository;

public class MergeWindowController {
    @FXML
    private Label remoteTrackingBranchName;
    @FXML
    private Label localBranchName1;
    @FXML
    private Label localBranchName2;
    @FXML
    private AnchorPane anchorRoot;
    @FXML
    private ComboBox<LocalBranchHelper> branchDropdownSelector;
    @FXML
    private Button mergeButton;
    @FXML
    private Text mergeRemoteTrackingText;
    @FXML
    private StackPane notificationPane;
    @FXML
    private NotificationController notificationPaneController;
    @FXML
    private HBox remoteBranchBox;
    @FXML
    private Text intoText1;
    @FXML
    private AnchorPane arrowPane;
    @FXML
    private HBox localBranchBox1;
    @FXML
    private TabPane mergeTypePane;
    @FXML
    private Tab localBranchTab;
    private static final int REMOTE_PANE = 0;
    private static final int LOCAL_PANE = 1;
    private Stage stage;
    SessionModel sessionModel;
    RepoHelper repoHelper;
    private BranchModel branchModel;
    private boolean disable;
    private CommitTreeModel localCommitTreeModel;
    private SessionController sessionController;
    static final Logger logger = LogManager.getLogger();

    public void initialize() throws IOException {
        this.sessionModel = SessionModel.getSessionModel();
        this.repoHelper = this.sessionModel.getCurrentRepoHelper();
        this.branchModel = this.repoHelper.getBranchModel();
        this.branchDropdownSelector.setItems(FXCollections.observableArrayList(this.branchModel.getLocalBranchesTyped()));
        this.branchDropdownSelector.setPromptText("...");
        this.branchDropdownSelector.setCellFactory((Callback)new Callback<ListView<LocalBranchHelper>, ListCell<LocalBranchHelper>>(){

            public ListCell<LocalBranchHelper> call(ListView<LocalBranchHelper> param) {
                return new ListCell<LocalBranchHelper>(){
                    private final Label branchName = new Label();
                    {
                        this.branchName.setStyle("-fx-text-fill: #333333;-fx-font-size: 14px;-fx-font-weight: bold;-fx-background-color: #CCCCCC;-fx-background-radius: 5;-fx-padding: 0 3 0 3");
                    }

                    protected void updateItem(LocalBranchHelper helper, boolean empty) {
                        super.updateItem((Object)helper, empty);
                        if (helper == null || empty) {
                            this.setGraphic(null);
                        } else {
                            if (helper.getRefName().length() > 25) {
                                this.branchName.setTooltip(new Tooltip(helper.getRefName()));
                            }
                            this.branchName.setText(helper.getAbbrevName());
                            this.setGraphic((Node)this.branchName);
                            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                        }
                    }
                };
            }
        });
        this.notificationPaneController.bindParentBounds(this.anchorRoot.heightProperty());
        this.localCommitTreeModel = CommitTreeController.getCommitTreeModel();
        this.initText();
        this.initMergeButton();
    }

    private void initText() throws IOException {
        String curBranch = this.repoHelper.getBranchModel().getCurrentBranch().getRefName();
        BranchTrackingStatus b = BranchTrackingStatus.of((Repository)this.repoHelper.getRepo(), (String)curBranch);
        if (b == null) {
            this.disable = true;
            this.mergeRemoteTrackingText.setText("This branch does not have an\nupstream remote branch.\n\nPush to create a remote branch.");
            this.hideRemoteMerge();
        } else {
            this.disable = false;
            String curRemoteTrackingBranch = b.getRemoteTrackingBranch();
            curRemoteTrackingBranch = Repository.shortenRefName((String)curRemoteTrackingBranch);
            this.localBranchName1.setText(curBranch);
            this.remoteTrackingBranchName.setText(curRemoteTrackingBranch);
        }
        this.localBranchName2.setText(curBranch);
    }

    private void initMergeButton() {
        if (this.disable) {
            this.mergeButton.disableProperty().bind((ObservableValue)this.mergeTypePane.getSelectionModel().selectedIndexProperty().lessThan(1));
        }
    }

    private void hideRemoteMerge() {
        this.remoteBranchBox.setVisible(false);
        this.intoText1.setVisible(false);
        this.arrowPane.setVisible(false);
        this.localBranchBox1.setVisible(false);
    }

    void showStage(AnchorPane pane, boolean localTabOpen) {
        this.anchorRoot = pane;
        this.stage = new Stage();
        this.stage.setTitle("Merge");
        this.stage.setScene(new Scene((Parent)this.anchorRoot));
        this.stage.initModality(Modality.APPLICATION_MODAL);
        this.stage.setOnCloseRequest(event -> logger.info("Closed merge window"));
        this.stage.show();
        if (localTabOpen) {
            this.mergeTypePane.getSelectionModel().select((Object)this.localBranchTab);
        }
        this.notificationPaneController.setAnchor(this.stage);
    }

    public void closeWindow() {
        if (Platform.isFxApplicationThread()) {
            this.stage.close();
        } else {
            Platform.runLater(() -> this.stage.close());
        }
    }

    public void handleMergeButton() throws GitAPIException, IOException {
        try {
            if (this.mergeTypePane.getSelectionModel().isSelected(1)) {
                if (!this.branchDropdownSelector.getSelectionModel().isEmpty()) {
                    this.localBranchMerge();
                } else {
                    this.showSelectBranchNotification();
                }
            }
            if (this.mergeTypePane.getSelectionModel().isSelected(0)) {
                this.mergeFromFetch();
            }
        }
        catch (JGitInternalException e) {
            this.showJGitInternalError(e);
        }
        catch (IOException | GitAPIException e) {
            this.showGenericErrorNotification();
        }
    }

    private void mergeFromFetch() {
        this.sessionController.mergeFromFetch(this.notificationPaneController, this.stage);
    }

    private void localBranchMerge() throws GitAPIException, IOException {
        logger.info("Merging selected branch with current");
        LocalBranchHelper selectedBranch = (LocalBranchHelper)this.branchDropdownSelector.getSelectionModel().getSelectedItem();
        MergeResult mergeResult = this.branchModel.mergeWithBranch(selectedBranch);
        if (mergeResult.getMergeStatus().equals((Object)MergeResult.MergeStatus.CONFLICTING)) {
            this.showConflictsNotification();
            this.sessionController.gitStatus();
            ConflictingFileWatcher.watchConflictingFiles(this.sessionModel.getCurrentRepoHelper());
        } else if (mergeResult.getMergeStatus().equals((Object)MergeResult.MergeStatus.ALREADY_UP_TO_DATE)) {
            this.showUpToDateNotification();
        } else if (mergeResult.getMergeStatus().equals((Object)MergeResult.MergeStatus.FAILED)) {
            this.showFailedMergeNotification();
        } else if (mergeResult.getMergeStatus().equals((Object)MergeResult.MergeStatus.MERGED) || mergeResult.getMergeStatus().equals((Object)MergeResult.MergeStatus.MERGED_NOT_COMMITTED)) {
            this.showMergeSuccessNotification();
        } else if (mergeResult.getMergeStatus().equals((Object)MergeResult.MergeStatus.FAST_FORWARD)) {
            this.showFastForwardMergeNotification();
        } else {
            System.out.println(mergeResult.getMergeStatus());
        }
        this.sessionController.gitStatus();
    }

    public void handleTrackDifBranch() {
        RemoteBranchHelper toTrack = PopUpWindows.showTrackDifRemoteBranchDialog((ObservableList<RemoteBranchHelper>)FXCollections.observableArrayList(this.branchModel.getRemoteBranchesTyped()));
        logger.info("Track remote branch locally (in merge window) button clicked");
        try {
            if (toTrack != null) {
                LocalBranchHelper tracker = this.branchModel.trackRemoteBranch(toTrack);
                this.branchDropdownSelector.getItems().add((Object)tracker);
                CommitTreeController.setBranchHeads(this.localCommitTreeModel, this.repoHelper);
            }
        }
        catch (RefAlreadyExistsException e) {
            logger.warn("Branch already exists locally warning");
            this.showRefAlreadyExistsNotification();
        }
        catch (IOException | GitAPIException e) {
            this.showGenericErrorNotification();
            e.printStackTrace();
        }
    }

    void setSessionController(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    private void showFastForwardMergeNotification() {
        logger.info("Fast forward merge complete notification");
        this.notificationPaneController.addNotification("Fast-forward merge completed.");
    }

    private void showMergeSuccessNotification() {
        logger.info("Merge completed notification");
        this.notificationPaneController.addNotification("Merge completed.");
    }

    private void showFailedMergeNotification() {
        logger.warn("Merge failed notification");
        this.notificationPaneController.addNotification("The merge failed.");
    }

    private void showUpToDateNotification() {
        logger.warn("No merge necessary notification");
        this.notificationPaneController.addNotification("No merge necessary. Those two branches are already up-to-date.");
    }

    private void showConflictsNotification() {
        logger.info("Merge conflicts notification");
        this.notificationPaneController.addNotification("That merge resulted in conflicts. Check the working tree to resolve them.");
    }

    private void showGenericErrorNotification() {
        Platform.runLater(() -> {
            logger.warn("Generic error.");
            this.notificationPaneController.addNotification("Sorry, there was an error.");
        });
    }

    private void showJGitInternalError(JGitInternalException e) {
        Platform.runLater(() -> {
            if (e.getCause().toString().contains("LockFailedException")) {
                logger.warn("Lock failed warning.");
                this.notificationPaneController.addNotification("Cannot lock .git/index. If no other git processes are running, manually remove all .lock files.");
            } else {
                logger.warn("Generic jgit internal warning.");
                this.notificationPaneController.addNotification("Sorry, there was a Git error.");
            }
        });
    }

    private void showRefAlreadyExistsNotification() {
        logger.info("Branch already exists notification");
        this.notificationPaneController.addNotification("That branch already exists locally.");
    }

    private void showSelectBranchNotification() {
        logger.info("Select a branch first notification");
        this.notificationPaneController.addNotification("You need to select a branch first");
    }
}

