/*
 * Decompiled with CFR 0.152.
 */
package elegit.controllers;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.GlyphsDude;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import elegit.RepoHelper;
import elegit.controllers.SessionController;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.text.Text;

public class DropdownController {
    private SessionController sessionController;
    public ComboBox<RepoHelper> repoDropdownSelector;
    @FXML
    public Button openRepoDirButton;
    @FXML
    public Button loadNewRepoButton;
    @FXML
    public Button removeRecentReposButton;
    @FXML
    public MenuItem cloneOption;
    @FXML
    public MenuItem existingOption;
    @FXML
    public ContextMenu newRepoOptionsMenu;

    public void setSessionController(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public void initialize() {
        this.openRepoDirButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Text openExternallyIcon = GlyphsDude.createIcon((GlyphIcons)FontAwesomeIcon.EXTERNAL_LINK);
        this.openRepoDirButton.setGraphic((Node)openExternallyIcon);
        this.openRepoDirButton.setTooltip(new Tooltip("Open repository directory"));
        int REPO_DROPDOWN_MAX_WIDTH = 147;
        this.repoDropdownSelector.setMaxWidth(147.0);
        Text plusIcon = GlyphsDude.createIcon((GlyphIcons)FontAwesomeIcon.PLUS);
        this.loadNewRepoButton.setGraphic((Node)plusIcon);
        Text minusIcon = GlyphsDude.createIcon((GlyphIcons)FontAwesomeIcon.MINUS);
        this.removeRecentReposButton.setGraphic((Node)minusIcon);
        this.removeRecentReposButton.setTooltip(new Tooltip("Clear shortcuts to recently opened repos"));
        Text downloadIcon = GlyphsDude.createIcon((GlyphIcons)FontAwesomeIcon.CLOUD_DOWNLOAD);
        this.cloneOption.setGraphic((Node)downloadIcon);
        Text folderOpenIcon = GlyphsDude.createIcon((GlyphIcons)FontAwesomeIcon.FOLDER_OPEN);
        this.existingOption.setGraphic((Node)folderOpenIcon);
    }

    public void loadSelectedRepo() {
        this.sessionController.loadSelectedRepo();
    }

    public void openRepoDirectory() {
        this.sessionController.openRepoDirectory();
    }

    public void handleLoadNewRepoButton() {
        this.sessionController.handleLoadNewRepoButton();
    }

    public void handleCloneNewRepoOption() {
        this.sessionController.handleCloneNewRepoOption();
    }

    public void handleLoadExistingRepoOption() {
        this.sessionController.handleLoadExistingRepoOption();
    }

    public void chooseRecentReposToDelete() {
        this.sessionController.chooseRecentReposToDelete();
    }
}

