/*
 * Decompiled with CFR 0.152.
 */
package elegit.controllers;

import elegit.BranchHelper;
import elegit.BranchModel;
import elegit.CommitTreeController;
import elegit.CommitTreeModel;
import elegit.LocalBranchHelper;
import elegit.PopUpWindows;
import elegit.RemoteBranchHelper;
import elegit.RepoHelper;
import elegit.SessionModel;
import elegit.controllers.NotificationController;
import elegit.controllers.SessionController;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.PopOver;
import org.eclipse.jgit.api.errors.CannotDeleteCurrentBranchException;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NotMergedException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.api.errors.TransportException;

public class CreateDeleteBranchWindowController {
    @FXML
    private AnchorPane anchorRoot;
    @FXML
    private CheckBox checkoutCheckBox;
    @FXML
    private TextField newBranchTextField;
    @FXML
    private ComboBox<LocalBranchHelper> localBranchesDropdown;
    @FXML
    private ComboBox<RemoteBranchHelper> remoteBranchesDropdown;
    @FXML
    private Button createButton;
    @FXML
    private Button deleteButton;
    @FXML
    private Button deleteButton2;
    @FXML
    private StackPane notificationPane;
    @FXML
    private NotificationController notificationPaneController;
    @FXML
    private TabPane tabPane;
    @FXML
    private Tab deleteLocalTab;
    @FXML
    private Tab deleteRemoteTab;
    @FXML
    private Tab createTab;
    private Stage stage;
    SessionModel sessionModel;
    RepoHelper repoHelper;
    private BranchModel branchModel;
    private CommitTreeModel localCommitTreeModel;
    private SessionController sessionController;
    static final Logger logger = LogManager.getLogger();

    public void initialize() {
        this.sessionModel = SessionModel.getSessionModel();
        this.repoHelper = this.sessionModel.getCurrentRepoHelper();
        this.branchModel = this.repoHelper.getBranchModel();
        this.refreshBranchesDropDown();
        this.localBranchesDropdown.setPromptText("Select a local branch...");
        this.remoteBranchesDropdown.setPromptText("Select a remote branch...");
        this.newBranchTextField.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.createButton.setDisable(true);
        this.deleteButton.setDisable(true);
        this.newBranchTextField.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.equals("")) {
                this.createButton.setDisable(true);
            } else {
                this.createButton.setDisable(false);
            }
        });
        this.newBranchTextField.setOnAction(event -> this.createNewBranch(this.newBranchTextField.getText(), this.checkoutCheckBox.isSelected()));
        this.localBranchesDropdown.getSelectionModel().selectedIndexProperty().addListener((observable, oldValue, newValue) -> {
            if ((Integer)newValue == -1) {
                this.deleteButton.setDisable(true);
            } else {
                this.deleteButton.setDisable(false);
            }
        });
        this.deleteButton2.disableProperty().bind((ObservableValue)this.remoteBranchesDropdown.getSelectionModel().selectedIndexProperty().lessThan(0));
        this.localCommitTreeModel = CommitTreeController.getCommitTreeModel();
        this.notificationPaneController.bindParentBounds(this.anchorRoot.heightProperty());
    }

    private void refreshBranchesDropDown() {
        this.localBranchesDropdown.setItems(FXCollections.observableArrayList(this.branchModel.getLocalBranchesTyped()));
        this.remoteBranchesDropdown.setItems(FXCollections.observableArrayList(this.branchModel.getRemoteBranchesTyped()));
        this.localBranchesDropdown.setCellFactory((Callback)new Callback<ListView<LocalBranchHelper>, ListCell<LocalBranchHelper>>(){

            public ListCell<LocalBranchHelper> call(ListView<LocalBranchHelper> param) {
                return new ListCell<LocalBranchHelper>(){
                    private final Label branchName = new Label();

                    protected void updateItem(LocalBranchHelper helper, boolean empty) {
                        super.updateItem((Object)helper, empty);
                        if (helper == null || empty) {
                            this.setGraphic(null);
                        } else {
                            this.branchName.setText(helper.getAbbrevName());
                            if (CreateDeleteBranchWindowController.this.repoHelper.getBranchModel().getCurrentBranch().getRefName().equals(this.branchName.getText())) {
                                this.branchName.setId("branch-current");
                            } else {
                                this.branchName.setId("branch-not-current");
                            }
                            this.setGraphic((Node)this.branchName);
                            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                        }
                    }
                };
            }
        });
        this.remoteBranchesDropdown.setCellFactory((Callback)new Callback<ListView<RemoteBranchHelper>, ListCell<RemoteBranchHelper>>(){

            public ListCell<RemoteBranchHelper> call(ListView<RemoteBranchHelper> param) {
                return new ListCell<RemoteBranchHelper>(){
                    private final Label branchName = new Label();

                    protected void updateItem(RemoteBranchHelper helper, boolean empty) {
                        super.updateItem((Object)helper, empty);
                        if (helper == null || empty) {
                            this.setGraphic(null);
                        } else {
                            this.branchName.setText(helper.getAbbrevName());
                            try {
                                if (CreateDeleteBranchWindowController.this.repoHelper.getBranchModel().getCurrentRemoteBranch() != null && CreateDeleteBranchWindowController.this.repoHelper.getBranchModel().getCurrentRemoteBranch().equals(this.branchName.getText())) {
                                    this.branchName.setId("branch-current");
                                } else {
                                    this.branchName.setId("branch-not-current");
                                }
                                this.setGraphic((Node)this.branchName);
                                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                            }
                            catch (IOException e) {
                                this.setGraphic(null);
                            }
                        }
                    }
                };
            }
        });
    }

    void showStage(AnchorPane pane, String tab) {
        this.anchorRoot = pane;
        this.stage = new Stage();
        this.stage.setTitle("Create or delete branch");
        this.stage.setScene(new Scene((Parent)this.anchorRoot));
        this.stage.initModality(Modality.APPLICATION_MODAL);
        this.stage.setOnCloseRequest(event -> logger.info("Closed create/delete branch window"));
        this.stage.show();
        if (tab.equals("create")) {
            this.tabPane.getSelectionModel().select((Object)this.createTab);
        }
        if (tab.equals("local")) {
            this.tabPane.getSelectionModel().select((Object)this.deleteLocalTab);
        }
        if (tab.equals("remote")) {
            this.tabPane.getSelectionModel().select((Object)this.deleteRemoteTab);
        }
        this.notificationPaneController.setAnchor(this.stage);
    }

    public void closeWindow() {
        this.stage.close();
    }

    public void handleCreateBranch() {
        this.createNewBranch(this.newBranchTextField.getText(), this.checkoutCheckBox.isSelected());
        this.stage.close();
    }

    private void createNewBranch(final String branchName, final boolean checkout) {
        Thread th = new Thread((Runnable)new Task<Void>(){

            protected Void call() {
                LocalBranchHelper newBranch = null;
                try {
                    logger.info("New branch button clicked");
                    newBranch = CreateDeleteBranchWindowController.this.branchModel.createNewLocalBranch(branchName);
                    if (checkout && newBranch != null) {
                        CreateDeleteBranchWindowController.this.checkoutBranch(newBranch, CreateDeleteBranchWindowController.this.sessionModel);
                    }
                    CreateDeleteBranchWindowController.this.sessionController.gitStatus();
                }
                catch (RefAlreadyExistsException e) {
                    logger.warn("Branch already exists warning");
                    CreateDeleteBranchWindowController.this.showRefAlreadyExistsNotification(branchName);
                }
                catch (InvalidRefNameException e1) {
                    logger.warn("Invalid branch name warning");
                    CreateDeleteBranchWindowController.this.showInvalidBranchNameNotification();
                }
                catch (RefNotFoundException e1) {
                    logger.warn("Can't create branch without a commit in the repo warning");
                    CreateDeleteBranchWindowController.this.showNoCommitsYetNotification();
                }
                catch (GitAPIException e1) {
                    logger.warn("Git error");
                    logger.debug((Object)e1.getStackTrace());
                    CreateDeleteBranchWindowController.this.showGenericGitErrorNotification();
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    logger.warn("Unspecified IOException");
                    logger.debug((Object)e1.getStackTrace());
                    CreateDeleteBranchWindowController.this.showGenericErrorNotification();
                    e1.printStackTrace();
                }
                finally {
                    CreateDeleteBranchWindowController.this.refreshBranchesDropDown();
                }
                return null;
            }
        });
        th.setDaemon(true);
        th.setName("createNewBranch");
        th.start();
    }

    private boolean checkoutBranch(LocalBranchHelper selectedBranch, SessionModel theSessionModel) {
        if (selectedBranch == null) {
            return false;
        }
        try {
            selectedBranch.checkoutBranch();
            CommitTreeController.focusCommitInGraph(selectedBranch.getCommit());
            CommitTreeController.setBranchHeads(CommitTreeController.getCommitTreeModel(), theSessionModel.getCurrentRepoHelper());
            return true;
        }
        catch (JGitInternalException e) {
            this.showJGitInternalError(e);
        }
        catch (CheckoutConflictException e) {
            this.showCheckoutConflictsNotification(e.getConflictingPaths());
        }
        catch (IOException | GitAPIException e) {
            this.showGenericErrorNotification();
        }
        return false;
    }

    public void handleDeleteRemoteBranch() {
        logger.info("Delete remote branches button clicked");
        BranchHelper selectedBranch = (BranchHelper)this.remoteBranchesDropdown.getSelectionModel().getSelectedItem();
        this.deleteBranch(selectedBranch);
        this.refreshBranchesDropDown();
    }

    public void handleDeleteLocalBranch() {
        logger.info("Delete remote branches button clicked");
        BranchHelper selectedBranch = (BranchHelper)this.localBranchesDropdown.getSelectionModel().getSelectedItem();
        this.deleteBranch(selectedBranch);
        this.refreshBranchesDropDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBranch(BranchHelper selectedBranch) {
        boolean authorizationSucceeded = true;
        try {
            if (selectedBranch != null) {
                if (selectedBranch instanceof LocalBranchHelper) {
                    this.branchModel.deleteLocalBranch((LocalBranchHelper)selectedBranch);
                    this.updateUser(selectedBranch.getRefName() + " deleted.", BranchModel.BranchType.LOCAL);
                } else {
                    this.sessionController.deleteRemoteBranch(selectedBranch, this.branchModel, message -> this.updateUser((String)message, BranchModel.BranchType.REMOTE));
                }
            }
        }
        catch (NotMergedException e) {
            logger.warn("Can't delete branch because not merged warning");
            Platform.runLater(() -> {
                if (PopUpWindows.showForceDeleteBranchAlert() && selectedBranch instanceof LocalBranchHelper) {
                    this.forceDeleteBranch((LocalBranchHelper)selectedBranch);
                }
            });
            this.showNotMergedNotification(selectedBranch);
        }
        catch (CannotDeleteCurrentBranchException e) {
            logger.warn("Can't delete current branch warning");
            this.showCannotDeleteBranchNotification(selectedBranch);
        }
        catch (TransportException e) {
            this.showNotAuthorizedNotification();
            authorizationSucceeded = false;
        }
        catch (GitAPIException e) {
            logger.warn("Git error");
            this.showGenericGitErrorNotificationWithBranch(selectedBranch);
        }
        finally {
            this.refreshBranchesDropDown();
            CommitTreeController.setBranchHeads(this.localCommitTreeModel, this.repoHelper);
            if (authorizationSucceeded) {
                this.sessionController.tryCommandAgainWithHTTPAuth = false;
            } else {
                this.sessionController.tryCommandAgainWithHTTPAuth = true;
                this.deleteBranch(selectedBranch);
            }
        }
    }

    private void forceDeleteBranch(LocalBranchHelper branchToDelete) {
        logger.info("Deleting local branch");
        try {
            if (branchToDelete != null) {
                this.branchModel.forceDeleteLocalBranch(branchToDelete);
                CommitTreeController.setBranchHeads(this.localCommitTreeModel, this.repoHelper);
                this.updateUser(" deleted ");
            }
        }
        catch (CannotDeleteCurrentBranchException e) {
            logger.warn("Can't delete current branch warning");
            this.showCannotDeleteBranchNotification(branchToDelete);
        }
        catch (GitAPIException e) {
            logger.warn("Git error");
            this.showGenericGitErrorNotificationWithBranch(branchToDelete);
            e.printStackTrace();
        }
        finally {
            this.refreshBranchesDropDown();
        }
    }

    private void updateUser(String type) {
        Platform.runLater(() -> {
            Text txt = new Text(" Branch" + type);
            PopOver popOver = new PopOver((Node)txt);
            popOver.setTitle("");
            popOver.show((Node)this.createButton);
            popOver.detach();
            this.newBranchTextField.clear();
            this.checkoutCheckBox.setSelected(false);
            popOver.setAutoHide(true);
        });
    }

    private void updateUser(String message, BranchModel.BranchType branchType) {
        Platform.runLater(() -> {
            Object dropdownToReset;
            Button buttonToShowOver;
            Text txt = new Text(message);
            PopOver popOver = new PopOver((Node)txt);
            popOver.setTitle("");
            if (branchType == BranchModel.BranchType.LOCAL) {
                buttonToShowOver = this.deleteButton;
                dropdownToReset = this.localBranchesDropdown;
            } else {
                buttonToShowOver = this.deleteButton2;
                dropdownToReset = this.remoteBranchesDropdown;
            }
            System.out.println("here i am " + message);
            popOver.show((Node)buttonToShowOver);
            System.out.println("showed");
            popOver.detach();
            popOver.setAutoHide(true);
            dropdownToReset.getSelectionModel().clearSelection();
        });
    }

    void setSessionController(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    @FXML
    public void onEnter(ActionEvent ae) {
        System.out.println("Enter key pressed!");
    }

    private void showInvalidBranchNameNotification() {
        Platform.runLater(() -> {
            logger.warn("Invalid branch name notification");
            this.notificationPaneController.addNotification("That branch name is invalid.");
        });
    }

    private void showNoCommitsYetNotification() {
        Platform.runLater(() -> {
            logger.warn("No commits yet notification");
            this.notificationPaneController.addNotification("You cannot make a branch since your repo has no commits yet. Make a commit first!");
        });
    }

    private void showGenericGitErrorNotification() {
        Platform.runLater(() -> {
            logger.warn("Git error notification");
            this.notificationPaneController.addNotification("Sorry, there was a git error.");
        });
    }

    private void showGenericErrorNotification() {
        Platform.runLater(() -> {
            logger.warn("Generic error warning.");
            this.notificationPaneController.addNotification("Sorry, there was an error.");
        });
    }

    private void showCannotDeleteBranchNotification(BranchHelper branch) {
        Platform.runLater(() -> {
            logger.warn("Cannot delete current branch notification");
            this.notificationPaneController.addNotification(String.format("Sorry, %s can't be deleted right now. Try checking out a different branch first.", branch.getRefName()));
        });
    }

    private void showGenericGitErrorNotificationWithBranch(BranchHelper branch) {
        Platform.runLater(() -> {
            logger.warn("Git error on branch notification");
            this.notificationPaneController.addNotification(String.format("Sorry, there was a git error on branch %s.", branch.getRefName()));
        });
    }

    private void showCommandCancelledNotification() {
        Platform.runLater(() -> {
            logger.warn("Command cancelled notification");
            this.notificationPaneController.addNotification("Command cancelled.");
        });
    }

    private void showNotMergedNotification(BranchHelper nonmergedBranch) {
        logger.warn("Not merged notification");
        this.notificationPaneController.addNotification("That branch has to be merged before you can do that.");
    }

    private void showJGitInternalError(JGitInternalException e) {
        Platform.runLater(() -> {
            if (e.getCause().toString().contains("LockFailedException")) {
                logger.warn("Lock failed warning.");
                this.notificationPaneController.addNotification("Cannot lock .git/index. If no other git processes are running, manually remove all .lock files.");
            } else {
                logger.warn("Generic jgit internal warning.");
                this.notificationPaneController.addNotification("Sorry, there was a Git error.");
            }
        });
    }

    private void showCheckoutConflictsNotification(List<String> conflictingPaths) {
        Platform.runLater(() -> {
            logger.warn("Checkout conflicts warning");
            EventHandler handler = event -> this.sessionController.quickStashSave();
            this.notificationPaneController.addNotification("You can't switch to that branch because there would be a merge conflict. Stash your changes or resolve conflicts first.", "stash", handler);
        });
    }

    private void showNotAuthorizedNotification() {
        Platform.runLater(() -> {
            logger.warn("Invalid authorization warning");
            this.notificationPaneController.addNotification("The authorization information you gave does not allow you to modify this repository. Try reentering your password.");
        });
    }

    private void showRefAlreadyExistsNotification(String ref) {
        Platform.runLater(() -> {
            logger.warn("Ref already exists warning");
            this.notificationPaneController.addNotification(ref + " already exists. Choose a different name.");
        });
    }
}

