/*
 * Decompiled with CFR 0.152.
 */
package elegit.controllers;

import elegit.AllFilesPanelView;
import elegit.BusyWindow;
import elegit.RepoHelper;
import elegit.SessionModel;
import elegit.StagedTreePanelView;
import elegit.controllers.SessionController;
import elegit.exceptions.MissingRepoException;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jgit.api.errors.GitAPIException;

public class CommitController {
    private Stage stage;
    private SessionModel sessionModel;
    private RepoHelper repoHelper;
    @FXML
    public Button commitButton;
    @FXML
    public TextArea commitMessageField;
    @FXML
    public StagedTreePanelView stagedFilesPanelView;
    @FXML
    public AllFilesPanelView allFilesPanelView;
    public BooleanProperty isClosed;
    private Thread refresher;
    static final Logger logger = LogManager.getLogger();
    static SessionController sessionController;

    public void initialize() {
        logger.info("Started up branch manager");
        this.isClosed = new SimpleBooleanProperty(false);
        this.sessionModel = SessionModel.getSessionModel();
        this.repoHelper = this.sessionModel.getCurrentRepoHelper();
        this.commitMessageField.requestFocus();
        this.stagedFilesPanelView.setSessionModel(this.sessionModel);
        this.allFilesPanelView.setSessionModel(this.sessionModel);
        this.updatePanelViews();
        this.commitButton.setDisable(true);
        this.commitMessageField.textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.equals("")) {
                this.commitButton.setDisable(false);
            } else {
                this.commitButton.setDisable(true);
            }
        });
        this.initializeLayoutParameters();
    }

    private void initializeLayoutParameters() {
        this.commitButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.commitMessageField.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    }

    public void showStage(GridPane pane) {
        this.stage = new Stage();
        this.stage.setTitle("Commit");
        this.stage.setScene(new Scene((Parent)pane, 550.0, 450.0));
        this.stage.initModality(Modality.APPLICATION_MODAL);
        this.stage.setOnCloseRequest(event -> {
            logger.info("Closed commit window");
            this.refresher.interrupt();
        });
        this.stage.show();
        this.refresher = new Thread((Runnable)new Task<Void>(){

            protected Void call() throws Exception {
                while (CommitController.this.stage.isShowing() && !this.isCancelled()) {
                    CommitController.this.updatePanelViews();
                    Thread.sleep(5000L);
                }
                return null;
            }
        });
        this.refresher.setDaemon(true);
        this.refresher.setName("Commit tree refresher");
        this.refresher.start();
    }

    public void updatePanelViews() {
        try {
            this.stagedFilesPanelView.drawDirectoryView();
            this.allFilesPanelView.drawDirectoryView();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleCommitButton() {
        try {
            String messageText = this.commitMessageField.getText();
            this.closeWindow();
            BusyWindow.show();
            BusyWindow.setLoadingText("Committing...");
            this.repoHelper.commit(messageText);
        }
        catch (GitAPIException e) {
            e.printStackTrace();
        }
        catch (MissingRepoException e) {
            e.printStackTrace();
        }
        finally {
            BusyWindow.hide();
            this.isClosed.setValue(Boolean.valueOf(true));
        }
    }

    public void closeWindow() {
        this.stage.close();
    }
}

