/*
 * Decompiled with CFR 0.152.
 */
package elegit.controllers;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.GlyphsDude;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import elegit.CommitHelper;
import elegit.RepoHelper;
import elegit.SessionModel;
import elegit.controllers.NotificationController;
import elegit.controllers.SessionController;
import java.util.ArrayList;
import java.util.List;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jgit.api.CheckoutResult;

public class CheckoutFilesController {
    private Stage stage;
    private SessionController sessionController;
    private RepoHelper repoHelper;
    private CommitHelper commitHelper;
    @FXML
    private TextField fileField;
    @FXML
    private VBox filesToCheckout;
    @FXML
    private NotificationController notificationPaneController;
    @FXML
    private Label header;
    @FXML
    private AnchorPane anchorRoot;
    private List<String> fileNames;
    static final Logger logger = LogManager.getLogger();

    public void initialize() {
        logger.info("Started up checkout files from commit window");
        SessionModel sessionModel = SessionModel.getSessionModel();
        this.repoHelper = sessionModel.getCurrentRepoHelper();
        this.fileNames = new ArrayList<String>();
        this.notificationPaneController.bindParentBounds(this.anchorRoot.heightProperty());
    }

    public void showStage(AnchorPane pane) {
        this.stage = new Stage();
        this.stage.setTitle("Checkout files");
        this.stage.setScene(new Scene((Parent)pane));
        this.stage.setOnCloseRequest(event -> logger.info("Closed checkout files from commit window"));
        this.stage.show();
        this.notificationPaneController.setAnchor(this.stage);
    }

    public void handleCheckoutButton() {
        try {
            if (this.fileNames.size() == 0) {
                this.notificationPaneController.addNotification("You need to add some files first");
                return;
            }
            CheckoutResult result = this.repoHelper.checkoutFiles(this.fileNames, this.commitHelper.getId());
            switch (result.getStatus()) {
                case CONFLICTS: {
                    this.notificationPaneController.addNotification("Checkout has not completed because of checkout conflicts");
                    break;
                }
                case ERROR: {
                    this.notificationPaneController.addNotification("An error occurred during checkout");
                    break;
                }
                case NONDELETED: {
                    this.notificationPaneController.addNotification("Checkout has completed, but some files could not be deleted.");
                    break;
                }
                case NOT_TRIED: {
                    this.notificationPaneController.addNotification("Something went wrong... try checking out again.");
                    break;
                }
                case OK: {
                    this.sessionController.gitStatus();
                    this.closeWindow();
                }
            }
        }
        catch (Exception e) {
            this.notificationPaneController.addNotification("Something went wrong.");
        }
    }

    public void handleAddButton() {
        String fileName = this.fileField.getText();
        if (this.fileNames.contains(fileName)) {
            this.notificationPaneController.addNotification(fileName + " has already been added.");
            return;
        }
        if (fileName.equals("")) {
            this.notificationPaneController.addNotification("You need to type a file name first");
            return;
        }
        Label line = new Label(fileName);
        line.setWrapText(true);
        line.setId("notification");
        line.setGraphic((Node)GlyphsDude.createIcon((GlyphIcons)FontAwesomeIcon.TIMES_CIRCLE));
        line.setOnMouseClicked(event -> {
            if (event.getTarget().equals(line.getGraphic())) {
                this.fileNames.remove(fileName);
            }
            this.filesToCheckout.getChildren().remove((Object)line);
        });
        this.fileNames.add(fileName);
        this.filesToCheckout.getChildren().add(0, (Object)line);
    }

    public void closeWindow() {
        this.stage.close();
    }

    void setSessionController(SessionController controller) {
        this.sessionController = controller;
    }

    void setCommitHelper(CommitHelper commitHelper) {
        this.commitHelper = commitHelper;
        this.header.setText(this.header.getText() + commitHelper.getId().substring(0, 8));
    }
}

