/*
 * Decompiled with CFR 0.152.
 */
package elegit.controllers;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.GlyphsDude;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import elegit.BranchModel;
import elegit.CommitTreeController;
import elegit.CommitTreeModel;
import elegit.LocalBranchHelper;
import elegit.LocalCommitTreeModel;
import elegit.RemoteBranchHelper;
import elegit.RepoHelper;
import elegit.SessionModel;
import elegit.controllers.NotificationController;
import java.io.IOException;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jgit.api.errors.CannotDeleteCurrentBranchException;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.lib.Repository;

public class BranchCheckoutController {
    public ListView<RemoteBranchHelper> remoteListView;
    public ListView<LocalBranchHelper> localListView;
    Repository repo;
    private RepoHelper repoHelper;
    private BranchModel branchModel;
    @FXML
    private AnchorPane anchorRoot;
    @FXML
    private Button trackRemoteBranchButton;
    @FXML
    private Button checkoutLocalBranchButton;
    @FXML
    private StackPane notificationPane;
    @FXML
    private NotificationController notificationPaneController;
    private SessionModel sessionModel;
    private LocalCommitTreeModel localCommitTreeModel;
    private Stage stage;
    static final Logger logger = LogManager.getLogger();

    public void initialize() throws Exception {
        logger.info("Started up branch manager");
        this.sessionModel = SessionModel.getSessionModel();
        this.repoHelper = this.sessionModel.getCurrentRepoHelper();
        this.repo = this.repoHelper.getRepo();
        this.branchModel = this.repoHelper.getBranchModel();
        for (CommitTreeModel commitTreeModel : CommitTreeController.allCommitTreeModels) {
            if (!commitTreeModel.getViewName().equals("Local commit tree")) continue;
            this.localCommitTreeModel = (LocalCommitTreeModel)commitTreeModel;
        }
        this.remoteListView.setItems(FXCollections.observableArrayList(this.branchModel.getRemoteBranchesTyped()));
        this.localListView.setItems(FXCollections.observableArrayList(this.branchModel.getLocalBranchesTyped()));
        this.localListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.remoteListView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.setIcons();
        this.updateButtons();
        this.notificationPaneController.bindParentBounds(this.anchorRoot.heightProperty());
    }

    private void setIcons() {
        Text cloudDownIcon = GlyphsDude.createIcon((GlyphIcons)FontAwesomeIcon.CLOUD_DOWNLOAD);
        cloudDownIcon.setFill((Paint)Color.WHITE);
        this.trackRemoteBranchButton.setGraphic((Node)cloudDownIcon);
    }

    void showStage(AnchorPane pane) {
        this.anchorRoot = pane;
        this.stage = new Stage();
        this.stage.setTitle("Branch Checkout");
        this.stage.setScene(new Scene((Parent)this.anchorRoot, 550.0, 450.0));
        this.stage.initModality(Modality.APPLICATION_MODAL);
        this.stage.setOnCloseRequest(event -> logger.info("Closed branch manager window"));
        this.stage.show();
        this.notificationPaneController.setAnchor(this.stage);
    }

    public void closeWindow() {
        this.stage.close();
    }

    public void handleRemoteListViewMouseClick() {
        if (!this.localListView.getSelectionModel().isEmpty()) {
            this.localListView.getSelectionModel().clearSelection();
        }
        this.updateButtons();
    }

    public void handleLocalListViewMouseClick() {
        if (!this.remoteListView.getSelectionModel().isEmpty()) {
            this.remoteListView.getSelectionModel().clearSelection();
        }
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.localListView.getSelectionModel().getSelectedIndices().size() > 0) {
            this.checkoutLocalBranchButton.setDisable(false);
            this.trackRemoteBranchButton.setDisable(true);
        }
        if (this.remoteListView.getSelectionModel().getSelectedIndices().size() > 0) {
            this.trackRemoteBranchButton.setDisable(false);
            this.checkoutLocalBranchButton.setDisable(true);
        }
    }

    public void trackSelectedBranchLocally() throws GitAPIException, IOException {
        logger.info("Track remote branch locally button clicked");
        RemoteBranchHelper selectedRemoteBranch = (RemoteBranchHelper)this.remoteListView.getSelectionModel().getSelectedItem();
        try {
            if (selectedRemoteBranch != null) {
                LocalBranchHelper tracker = this.branchModel.trackRemoteBranch(selectedRemoteBranch);
                this.localListView.getItems().add((Object)tracker);
                CommitTreeController.setBranchHeads(this.localCommitTreeModel, this.repoHelper);
            }
        }
        catch (RefAlreadyExistsException e) {
            logger.warn("Branch already exists locally warning");
            this.showRefAlreadyExistsNotification();
        }
    }

    private void forceDeleteLocalBranch(LocalBranchHelper branchToDelete) {
        logger.info("Deleting local branch");
        try {
            if (branchToDelete != null) {
                this.branchModel.forceDeleteLocalBranch(branchToDelete);
                this.localListView.getItems().remove((Object)branchToDelete);
                CommitTreeController.setBranchHeads(this.localCommitTreeModel, this.repoHelper);
            }
        }
        catch (CannotDeleteCurrentBranchException e) {
            logger.warn("Can't delete current branch warning");
            this.showCannotDeleteBranchNotification(branchToDelete);
        }
        catch (GitAPIException e) {
            logger.warn("Git error");
            this.showGenericGitErrorNotificationWithBranch(branchToDelete);
            e.printStackTrace();
        }
    }

    private boolean checkoutBranch(LocalBranchHelper selectedBranch, SessionModel theSessionModel) {
        if (selectedBranch == null) {
            return false;
        }
        try {
            selectedBranch.checkoutBranch();
            CommitTreeController.focusCommitInGraph(selectedBranch.getCommit());
            CommitTreeController.setBranchHeads(CommitTreeController.getCommitTreeModel(), theSessionModel.getCurrentRepoHelper());
            return true;
        }
        catch (JGitInternalException e) {
            this.showJGitInternalError(e);
        }
        catch (CheckoutConflictException e) {
            this.showCheckoutConflictsNotification(e.getConflictingPaths());
        }
        catch (IOException | GitAPIException e) {
            this.showGenericErrorNotification();
        }
        return false;
    }

    public void handleCheckoutButton() {
        if (this.checkoutBranch((LocalBranchHelper)this.localListView.getSelectionModel().getSelectedItem(), this.sessionModel)) {
            this.closeWindow();
        }
    }

    private void showGenericGitErrorNotificationWithBranch(LocalBranchHelper branch) {
        logger.warn("Git error on branch notification");
        this.notificationPaneController.addNotification(String.format("Sorry, there was a git error on branch %s.", branch.getRefName()));
    }

    private void showGenericErrorNotification() {
        logger.warn("Generic error notification");
        this.notificationPaneController.addNotification("Sorry, there was an error.");
    }

    private void showCannotDeleteBranchNotification(LocalBranchHelper branch) {
        logger.warn("Cannot delete current branch notification");
        this.notificationPaneController.addNotification(String.format("Sorry, %s can't be deleted right now. Try checking out a different branch first.", branch.getRefName()));
    }

    private void showJGitInternalError(JGitInternalException e) {
        Platform.runLater(() -> {
            if (e.getCause().toString().contains("LockFailedException")) {
                logger.warn("Lock failed warning.");
                this.notificationPaneController.addNotification("Cannot lock .git/index. If no other git processes are running, manually remove all .lock files.");
            } else {
                logger.warn("Generic jgit internal warning.");
                this.notificationPaneController.addNotification("Sorry, there was a Git error.");
            }
        });
    }

    private void showRefAlreadyExistsNotification() {
        logger.info("Branch already exists notification");
        this.notificationPaneController.addNotification("Looks like that branch already exists locally!");
    }

    private void showCheckoutConflictsNotification(List<String> conflictingPaths) {
        Platform.runLater(() -> {
            logger.warn("Checkout conflicts warning");
            this.notificationPaneController.addNotification("You can't switch to that branch because there would be a merge conflict. Stash your changes or resolve conflicts first.");
        });
    }
}

