/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import elegit.DirectoryRepoFile;
import elegit.FileStructurePanelView;
import elegit.RepoFile;
import elegit.StagedAndModifiedRepoFile;
import elegit.StagedRepoFile;
import elegit.controllers.SessionController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Callback;
import org.eclipse.jgit.api.errors.GitAPIException;

public class WorkingTreePanelView
extends FileStructurePanelView {
    public BooleanProperty isAnyFileSelectedProperty;
    public List<TreeItem<RepoFile>> displayedFiles;
    private CheckBoxTreeItem<RepoFile> checkBox;

    public WorkingTreePanelView() {
        this.init();
    }

    @Override
    public void init() {
        this.displayedFiles = new LinkedList<TreeItem<RepoFile>>();
        this.isAnyFileSelectedProperty = new SimpleBooleanProperty(false);
        this.isAnyFileSelectedProperty.addListener((observable, oldValue, newValue) -> SessionController.anythingChecked.set(newValue.booleanValue()));
        super.init();
    }

    @Override
    protected Callback<TreeView<RepoFile>, TreeCell<RepoFile>> getTreeCellFactory() {
        return arg -> {
            TreeCell cell = (TreeCell)CheckBoxTreeCell.forTreeView().call(arg);
            cell.setOnContextMenuRequested(event -> {
                if (cell.getTreeItem() != null) {
                    ((RepoFile)cell.getTreeItem().getValue()).showContextMenu((Node)cell, event.getScreenX(), event.getScreenY());
                }
            });
            return cell;
        };
    }

    @Override
    protected TreeItem<RepoFile> getRootTreeItem(DirectoryRepoFile rootDirectory) {
        CheckBoxTreeItem item = new CheckBoxTreeItem((Object)rootDirectory);
        this.initCheckBox();
        item.getChildren().add(this.checkBox);
        return item;
    }

    private void initCheckBox() {
        Text txt = new Text("select all");
        txt.setFont(new Font(10.0));
        this.checkBox = new CheckBoxTreeItem(null, (Node)txt);
        this.checkBox.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.setAllFilesSelected(true);
                txt.setText("deselect all");
            } else {
                this.setAllFilesSelected(false);
                txt.setText("select all");
            }
        });
    }

    @Override
    protected void addTreeItemsToRoot(List<RepoFile> repoFiles, TreeItem<RepoFile> root) {
        this.displayedFiles = new LinkedList<TreeItem<RepoFile>>();
        if (root.getChildren().size() == 0) {
            root.getChildren().add(this.checkBox);
        }
        SimpleBooleanProperty isSelectedPropertyHelper = new SimpleBooleanProperty(false);
        HashMap<Object, Boolean> shouldKeepChild = new HashMap<Object, Boolean>();
        for (int i = 1; i < root.getChildren().size(); ++i) {
            shouldKeepChild.put(root.getChildren().get(i), false);
        }
        for (RepoFile repoFile : repoFiles) {
            CheckBoxTreeItem newItem = new CheckBoxTreeItem((Object)repoFile, (Node)repoFile.diffButton);
            SimpleBooleanProperty oldHelper = isSelectedPropertyHelper;
            isSelectedPropertyHelper = new SimpleBooleanProperty();
            boolean foundMatchingItem = false;
            for (int i = 1; i < root.getChildren().size(); ++i) {
                CheckBoxTreeItem oldItem = (CheckBoxTreeItem)root.getChildren().get(i);
                if (((RepoFile)oldItem.getValue()).equals(repoFile)) {
                    isSelectedPropertyHelper.bind((ObservableValue)oldHelper.or((ObservableBooleanValue)oldItem.selectedProperty()));
                    this.displayedFiles.add((TreeItem<RepoFile>)oldItem);
                    foundMatchingItem = true;
                    shouldKeepChild.put(oldItem, true);
                    break;
                }
                if (!((RepoFile)oldItem.getValue()).getFilePath().equals(repoFile.getFilePath())) continue;
                newItem.setSelected(oldItem.isSelected());
                root.getChildren().set(i, (Object)newItem);
                isSelectedPropertyHelper.bind((ObservableValue)oldHelper.or((ObservableBooleanValue)newItem.selectedProperty()));
                this.displayedFiles.add((TreeItem<RepoFile>)newItem);
                foundMatchingItem = true;
                shouldKeepChild.put(newItem, true);
                break;
            }
            if (foundMatchingItem) continue;
            root.getChildren().add((Object)newItem);
            isSelectedPropertyHelper.bind((ObservableValue)oldHelper.or((ObservableBooleanValue)newItem.selectedProperty()));
            this.displayedFiles.add((TreeItem<RepoFile>)newItem);
            shouldKeepChild.put(newItem, true);
        }
        for (TreeItem item : shouldKeepChild.keySet()) {
            if (((Boolean)shouldKeepChild.get(item)).booleanValue()) continue;
            root.getChildren().remove((Object)item);
        }
        if (root.getChildren().size() < 2) {
            root.getChildren().remove(this.checkBox);
        }
        this.isAnyFileSelectedProperty.bind((ObservableValue)isSelectedPropertyHelper);
    }

    @Override
    public List<RepoFile> getFilesToDisplay() throws GitAPIException {
        return this.sessionModel.getAllChangedRepoFiles();
    }

    public ArrayList<RepoFile> getCheckedFilesInDirectory() {
        ArrayList<RepoFile> checkedFiles = new ArrayList<RepoFile>();
        for (TreeItem<RepoFile> fileLeaf : this.displayedFiles) {
            CheckBoxTreeItem checkBoxFile = (CheckBoxTreeItem)fileLeaf;
            if (!checkBoxFile.isSelected()) continue;
            checkedFiles.add((RepoFile)fileLeaf.getValue());
        }
        return checkedFiles;
    }

    public void setAllFilesSelected(boolean selected) {
        for (TreeItem<RepoFile> fileLeaf : this.displayedFiles) {
            CheckBoxTreeItem checkBoxFile = (CheckBoxTreeItem)fileLeaf;
            checkBoxFile.setSelected(selected);
        }
    }

    public boolean isAnyFileSelected() {
        return this.isAnyFileSelectedProperty.get();
    }

    public boolean isAnyFileStaged() {
        for (TreeItem<RepoFile> treeItem : this.displayedFiles) {
            if (!(treeItem.getValue() instanceof StagedAndModifiedRepoFile) && !(treeItem.getValue() instanceof StagedRepoFile)) continue;
            return true;
        }
        return false;
    }

    public boolean isAnyFileStagedSelected() {
        for (RepoFile treeItem : this.getCheckedFilesInDirectory()) {
            if (!(treeItem instanceof StagedRepoFile)) continue;
            return true;
        }
        return false;
    }
}

