/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import elegit.CommitHelper;
import elegit.RepoHelper;
import elegit.TagHelper;
import elegit.exceptions.MissingRepoException;
import elegit.exceptions.TagNameExistsException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidTagNameException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;

public class TagModel {
    private RepoHelper repoHelper;
    private List<TagHelper> upToDateTags;
    private List<TagHelper> unpushedTags;
    private List<String> tagsWithUnpushedCommits;
    private Map<String, TagHelper> tagIdMap;
    static final Logger logger = LogManager.getLogger();

    public TagModel(RepoHelper repoHelper) throws GitAPIException, IOException {
        this.repoHelper = repoHelper;
        this.unpushedTags = new ArrayList<TagHelper>();
        this.tagsWithUnpushedCommits = new ArrayList<String>();
        this.tagIdMap = new HashMap<String, TagHelper>();
        this.upToDateTags = this.getAllLocalTags();
    }

    public boolean updateTags() throws IOException, GitAPIException {
        List<String> oldTagNames = this.getAllTagNames();
        Map tagMap = this.repoHelper.getRepo().getTags();
        int oldSize = oldTagNames.size();
        for (String s : tagMap.keySet()) {
            if (oldTagNames.contains(s)) {
                String commitName = ((Ref)tagMap.get(s)).getPeeledObjectId() != null ? ((Ref)tagMap.get(s)).getPeeledObjectId().getName() : ((Ref)tagMap.get(s)).getObjectId().getName();
                if (!this.repoHelper.getCommit(commitName).hasTag(s)) {
                    this.repoHelper.getCommit(commitName).addTag(this.tagIdMap.get(s));
                }
                oldTagNames.remove(s);
                if (!this.tagsWithUnpushedCommits.contains(s)) continue;
                this.tagsWithUnpushedCommits.remove(s);
                continue;
            }
            Ref r = (Ref)tagMap.get(s);
            this.makeTagHelper(r, s);
        }
        if (oldTagNames.size() > 0) {
            for (String s : oldTagNames) {
                this.repoHelper.getCommit(this.tagIdMap.get(s).getCommitId()).removeTag(s);
                this.unpushedTags.remove(s);
                this.upToDateTags.remove(this.tagIdMap.get(s));
                this.tagsWithUnpushedCommits.remove(s);
                this.tagIdMap.remove(s);
            }
        }
        return oldSize != this.getAllTagNames().size() || oldTagNames.size() != 0;
    }

    public void tag(String tagName, String commitName) throws GitAPIException, MissingRepoException, IOException, TagNameExistsException, InvalidTagNameException {
        logger.info("Attempting tag");
        if (!this.repoHelper.exists()) {
            throw new MissingRepoException();
        }
        Git git = new Git(this.repoHelper.getRepo());
        CommitHelper c = this.repoHelper.getCommit(commitName);
        if (c.getTagNames().contains(tagName)) {
            throw new TagNameExistsException();
        }
        Ref r = git.tag().setName(tagName).setObjectId((RevObject)c.getCommit()).setAnnotated(false).call();
        git.close();
        TagHelper t = this.makeTagHelper(r, tagName);
        this.unpushedTags.add(t);
    }

    private TagHelper makeTagHelper(Ref r, String tagName) throws IOException, GitAPIException {
        TagHelper t;
        String commitName;
        boolean isAnnotated = false;
        if (r.getPeeledObjectId() != null) {
            commitName = r.getPeeledObjectId().getName();
            isAnnotated = true;
        } else {
            commitName = r.getObjectId().getName();
        }
        CommitHelper c = this.repoHelper.getCommit(commitName);
        if (c == null) {
            this.tagsWithUnpushedCommits.add(tagName);
            return null;
        }
        if (this.tagsWithUnpushedCommits.contains(tagName)) {
            this.tagsWithUnpushedCommits.remove(tagName);
        }
        if (!isAnnotated) {
            t = new TagHelper(tagName, c);
            c.addTag(t);
        } else {
            ObjectReader objectReader = this.repoHelper.getRepo().newObjectReader();
            ObjectLoader objectLoader = objectReader.open((AnyObjectId)r.getObjectId());
            RevTag tag = RevTag.parse((byte[])objectLoader.getBytes());
            objectReader.close();
            t = new TagHelper(tag, c);
            c.addTag(t);
        }
        if (!this.tagIdMap.containsKey(tagName)) {
            this.tagIdMap.put(tagName, t);
        }
        return t;
    }

    public void deleteTag(String tagName) throws MissingRepoException, GitAPIException {
        TagHelper tagToRemove = this.tagIdMap.get(tagName);
        if (!this.repoHelper.exists()) {
            throw new MissingRepoException();
        }
        Git git = new Git(this.repoHelper.getRepo());
        git.tagDelete().setTags(new String[]{tagToRemove.getRefName()}).call();
        git.close();
        tagToRemove.getCommit().removeTag(tagName);
        this.upToDateTags.remove(tagToRemove);
        this.tagIdMap.remove(tagName);
    }

    public TagHelper getTag(String tagName) {
        return this.tagIdMap.get(tagName);
    }

    public List<String> getAllTagNames() {
        return new ArrayList<String>(this.tagIdMap.keySet());
    }

    public List<TagHelper> getAllLocalTags() throws IOException, GitAPIException {
        Map tagMap = this.repoHelper.getRepo().getTags();
        ArrayList<TagHelper> tags = new ArrayList<TagHelper>();
        for (String s : tagMap.keySet()) {
            Ref r = (Ref)tagMap.get(s);
            tags.add(this.makeTagHelper(r, s));
        }
        return tags;
    }

    public List<TagHelper> getAllTags() {
        return new ArrayList<TagHelper>(this.tagIdMap.values());
    }

    public Map<CommitHelper, List<TagHelper>> getTagCommitMap() {
        HashMap<CommitHelper, List<TagHelper>> commitTagMap = new HashMap<CommitHelper, List<TagHelper>>();
        List<TagHelper> tags = this.getAllTags();
        for (TagHelper tag : tags) {
            CommitHelper head = tag.getCommit();
            if (commitTagMap.containsKey(head)) {
                ((List)commitTagMap.get(head)).add(tag);
                continue;
            }
            commitTagMap.put(head, Stream.of(tag).collect(Collectors.toList()));
        }
        return commitTagMap;
    }
}

