/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import elegit.CommitHelper;
import elegit.RefHelper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevTag;

public class TagHelper
extends RefHelper {
    private RevTag tag;
    private PersonIdent author;
    private String shortMessage;
    private String fullMessage;
    private boolean isAnnotated;

    TagHelper(RevTag t, CommitHelper c) {
        this.tag = t;
        this.author = t.getTaggerIdent();
        this.refName = t.getTagName();
        this.shortMessage = t.getShortMessage();
        this.fullMessage = t.getFullMessage();
        this.isAnnotated = true;
        this.commit = c;
    }

    TagHelper(String name, CommitHelper c) {
        this.refName = name;
        this.commit = c;
        this.isAnnotated = false;
    }

    public ObjectId getObjectId() {
        return this.tag.getId();
    }

    public int getType() {
        return this.tag.getType();
    }

    public String getMessage(boolean fullMessage) {
        if (fullMessage) {
            return this.fullMessage;
        }
        return this.shortMessage;
    }

    public String getAuthorName() {
        return this.author.getName();
    }

    public String getAuthorEmail() {
        return this.author.getEmailAddress();
    }

    public Date getWhen() {
        return this.author.getWhen();
    }

    public String getFormattedWhen() {
        SimpleDateFormat formatter = new SimpleDateFormat("MMM dd yyyy, h:mm a");
        return formatter.format(this.getWhen());
    }

    public void setCommit(CommitHelper c) {
        this.commit = c;
    }

    public String getCommitId() {
        return this.commit.getObjectId().getName();
    }

    public boolean isAnnotated() {
        return this.isAnnotated;
    }

    boolean presentDeleteDialog() {
        Dialog dialog = new Dialog();
        dialog.setTitle("Delete Tag");
        dialog.setHeaderText("Are you sure you want to delete tag " + this.refName + "?");
        ButtonType confirm = new ButtonType("Yes", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{confirm, ButtonType.CANCEL});
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == confirm) {
                return true;
            }
            return false;
        });
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            return (Boolean)result.get();
        }
        return false;
    }
}

