/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import elegit.DirectoryRepoFile;
import elegit.FileStructurePanelView;
import elegit.RepoFile;
import elegit.StagedAndModifiedRepoFile;
import elegit.StagedRepoFile;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.util.Callback;
import org.eclipse.jgit.api.errors.GitAPIException;

public class StagedTreePanelView
extends FileStructurePanelView {
    private Map<Path, TreeItem<RepoFile>> itemMap;

    public StagedTreePanelView() {
        this.init();
    }

    @Override
    public void init() {
        this.itemMap = new HashMap<Path, TreeItem<RepoFile>>();
        super.init();
    }

    @Override
    protected Callback<TreeView<RepoFile>, TreeCell<RepoFile>> getTreeCellFactory() {
        return arg -> new RepoFileTreeCell();
    }

    @Override
    protected TreeItem<RepoFile> getRootTreeItem(DirectoryRepoFile rootDirectory) {
        return new TreeItem((Object)rootDirectory);
    }

    @Override
    protected void addTreeItemsToRoot(List<RepoFile> repoFiles, TreeItem<RepoFile> root) {
        HashMap filesAtDepthMap = new HashMap();
        int maxDepth = 0;
        for (RepoFile repoFile : repoFiles) {
            int n = repoFile.getLevelInRepository();
            if (n > maxDepth) {
                maxDepth = n;
            }
            if (!filesAtDepthMap.containsKey(n)) {
                LinkedList<RepoFile> list = new LinkedList<RepoFile>();
                list.add(repoFile);
                filesAtDepthMap.put(n, list);
                continue;
            }
            ((List)filesAtDepthMap.get(n)).add(repoFile);
        }
        HashSet<TreeItem<RepoFile>> itemsToRemove = new HashSet<TreeItem<RepoFile>>();
        itemsToRemove.addAll(this.itemMap.values());
        for (int i = 0; i < maxDepth + 1; ++i) {
            List list = (List)filesAtDepthMap.get(i);
            if (list == null) continue;
            for (RepoFile repoFile : list) {
                Path pathToFile = repoFile.getFilePath();
                if (this.itemMap.containsKey(pathToFile)) {
                    TreeItem<RepoFile> oldItem = this.itemMap.get(pathToFile);
                    if (((RepoFile)oldItem.getValue()).equals(repoFile)) {
                        itemsToRemove.remove(oldItem);
                        continue;
                    }
                    TreeItem newItem = new TreeItem((Object)repoFile, (Node)repoFile.diffButton);
                    TreeItem parent = oldItem.getParent();
                    Platform.runLater(() -> {
                        newItem.setExpanded(oldItem.isExpanded());
                        newItem.getChildren().setAll((Collection)oldItem.getChildren());
                        parent.getChildren().set(parent.getChildren().indexOf((Object)oldItem), (Object)newItem);
                    });
                    itemsToRemove.remove(oldItem);
                    this.itemMap.put(pathToFile, (TreeItem<RepoFile>)newItem);
                    continue;
                }
                TreeItem newItem = new TreeItem((Object)repoFile, (Node)repoFile.diffButton);
                boolean foundParent = false;
                for (Path pathToParent = pathToFile.getParent(); pathToParent != null && !((RepoFile)root.getValue()).getFilePath().equals(pathToParent); pathToParent = pathToParent.getParent()) {
                    if (!this.itemMap.containsKey(pathToParent)) continue;
                    TreeItem<RepoFile> parent = this.itemMap.get(pathToParent);
                    Platform.runLater(() -> parent.getChildren().add((Object)newItem));
                    foundParent = true;
                    break;
                }
                if (!foundParent) {
                    Platform.runLater(() -> root.getChildren().add((Object)newItem));
                }
                this.itemMap.put(pathToFile, (TreeItem<RepoFile>)newItem);
                itemsToRemove.remove(newItem);
            }
        }
        for (TreeItem treeItem : itemsToRemove) {
            Platform.runLater(() -> {
                if (item.getParent() != null) {
                    item.getParent().getChildren().remove((Object)item);
                }
            });
            this.itemMap.remove(((RepoFile)treeItem.getValue()).getFilePath());
        }
    }

    @Override
    public List<RepoFile> getFilesToDisplay() throws GitAPIException, IOException {
        ArrayList<RepoFile> repoFiles = new ArrayList<RepoFile>();
        for (RepoFile file : this.sessionModel.getAllChangedRepoFiles()) {
            if (!(file instanceof StagedRepoFile) && !(file instanceof StagedAndModifiedRepoFile)) continue;
            repoFiles.add(file);
        }
        return repoFiles;
    }

    private class RepoFileTreeCell
    extends TreeCell<RepoFile> {
        private RepoFileTreeCell() {
        }

        protected void updateItem(RepoFile item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.setText(this.getItem() == null ? "" : ((RepoFile)this.getItem()).toString());
            this.setGraphic(this.getTreeItem() == null ? null : this.getTreeItem().getGraphic());
            this.setOnContextMenuRequested(event -> {
                if (this.getTreeItem() != null) {
                    ((RepoFile)this.getTreeItem().getValue()).showContextMenu((Node)this, event.getScreenX(), event.getScreenY());
                }
            });
        }
    }
}

