/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import elegit.AuthMethod;
import elegit.ConflictingFileWatcher;
import elegit.ConflictingRepoFile;
import elegit.ConflictingThenModifiedRepoFile;
import elegit.DirectoryRepoFile;
import elegit.ElegitUserInfoGUI;
import elegit.ExistingRepoHelper;
import elegit.IgnoredRepoFile;
import elegit.MissingRepoFile;
import elegit.ModifiedRepoFile;
import elegit.PrefObj;
import elegit.RepoFile;
import elegit.RepoHelper;
import elegit.StagedAndModifiedRepoFile;
import elegit.StagedRepoFile;
import elegit.UntrackedRepoFile;
import elegit.exceptions.CancelledAuthorizationException;
import elegit.exceptions.MissingRepoException;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Stream;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.xml.bind.DatatypeConverter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;

public class SessionModel {
    private static final String RECENT_REPOS_LIST_KEY = "RECENT_REPOS_LIST";
    private static final String LAST_OPENED_REPO_PATH_KEY = "LAST_OPENED_REPO_PATH";
    private static final String LAST_UUID_KEY = "LAST_UUID";
    private RepoHelper currentRepoHelper;
    public ObjectProperty<RepoHelper> currentRepoHelperProperty;
    List<RepoHelper> allRepoHelpers = new ArrayList<RepoHelper>();
    private static SessionModel sessionModel;
    Preferences preferences = Preferences.userNodeForPackage(this.getClass());
    static final Logger logger;

    public static SessionModel getSessionModel() {
        if (sessionModel == null) {
            sessionModel = new SessionModel();
        }
        return sessionModel;
    }

    private SessionModel() {
        this.currentRepoHelperProperty = new SimpleObjectProperty((Object)this.currentRepoHelper);
    }

    public void loadMostRecentRepoHelper() {
        try {
            String lastOpenedRepoPathString = (String)PrefObj.getObject(this.preferences, LAST_OPENED_REPO_PATH_KEY);
            if (lastOpenedRepoPathString != null) {
                Path path = Paths.get(lastOpenedRepoPathString, new String[0]);
                try {
                    ExistingRepoHelper existingRepoHelper = new ExistingRepoHelper(path, new ElegitUserInfoGUI());
                    this.openRepoFromHelper(existingRepoHelper);
                    return;
                }
                catch (IllegalArgumentException e) {
                    logger.warn("Recent repo not found in directory it used to be in");
                }
                catch (MissingRepoException | GitAPIException e) {
                    logger.error("Git error or missing repo exception");
                    logger.debug((Object)e.getStackTrace());
                    e.printStackTrace();
                }
                catch (CancelledAuthorizationException e) {
                    // empty catch block
                }
            }
            if (this.allRepoHelpers != null && this.allRepoHelpers.size() > 0) {
                RepoHelper helper = this.allRepoHelpers.get(0);
                try {
                    this.openRepoFromHelper(helper);
                }
                catch (MissingRepoException e) {
                    logger.error("Missing repo exception");
                    e.printStackTrace();
                }
            }
        }
        catch (IOException | ClassNotFoundException | BackingStoreException e) {
            logger.error("Some sort of error loading most recent repo helper");
            logger.debug((Object)e.getStackTrace());
            e.printStackTrace();
        }
    }

    public void loadRecentRepoHelpersFromStoredPathStrings() {
        try {
            ArrayList storedRepoPathStrings = (ArrayList)PrefObj.getObject(this.preferences, RECENT_REPOS_LIST_KEY);
            if (storedRepoPathStrings != null) {
                for (String pathString : storedRepoPathStrings) {
                    Path path = Paths.get(pathString, new String[0]);
                    try {
                        ExistingRepoHelper existingRepoHelper = new ExistingRepoHelper(path, new ElegitUserInfoGUI());
                        this.allRepoHelpers.add(existingRepoHelper);
                    }
                    catch (IllegalArgumentException e) {
                        logger.warn("Repository has been moved, we move along");
                    }
                    catch (GitAPIException e) {
                        logger.error("Git error loading recent repo helpers");
                        logger.debug((Object)e.getStackTrace());
                        e.printStackTrace();
                    }
                    catch (CancelledAuthorizationException cancelledAuthorizationException) {}
                }
            }
        }
        catch (IOException | ClassNotFoundException | BackingStoreException e) {
            logger.error("Some sort of exception loading recent repo helpers");
            logger.debug((Object)e.getStackTrace());
            e.printStackTrace();
        }
    }

    private void openRepo(RepoHelper repoHelper) throws BackingStoreException, IOException, ClassNotFoundException {
        if (!this.allRepoHelpers.contains(repoHelper)) {
            this.allRepoHelpers.add(repoHelper);
        }
        this.currentRepoHelper = repoHelper;
        this.currentRepoHelperProperty.set((Object)this.currentRepoHelper);
        this.saveListOfRepoPathStrings();
        this.saveMostRecentRepoPathString();
    }

    public void openRepoFromHelper(RepoHelper repoHelperToLoad) throws BackingStoreException, IOException, ClassNotFoundException, MissingRepoException {
        RepoHelper matchedRepoHelper = this.matchRepoWithAlreadyLoadedRepo(repoHelperToLoad);
        if (matchedRepoHelper == null) {
            this.allRepoHelpers.add(repoHelperToLoad);
            this.openRepo(repoHelperToLoad);
        } else if (matchedRepoHelper.exists()) {
            this.openRepo(matchedRepoHelper);
        } else {
            this.allRepoHelpers.remove(matchedRepoHelper);
            throw new MissingRepoException();
        }
    }

    private RepoHelper matchRepoWithAlreadyLoadedRepo(RepoHelper repoHelperCandidate) {
        if (repoHelperCandidate != null) {
            for (RepoHelper repoHelper : this.allRepoHelpers) {
                if (!repoHelper.getLocalPath().equals(repoHelperCandidate.getLocalPath())) continue;
                return repoHelper;
            }
        }
        return null;
    }

    public RepoHelper getCurrentRepoHelper() {
        return this.currentRepoHelper;
    }

    public Repository getCurrentRepo() {
        return this.currentRepoHelper.getRepo();
    }

    public List<RepoHelper> getAllRepoHelpers() {
        ArrayList<RepoHelper> tempList = new ArrayList<RepoHelper>(this.allRepoHelpers);
        for (RepoHelper r : tempList) {
            if (r.exists()) continue;
            this.allRepoHelpers.remove(r);
        }
        return this.allRepoHelpers;
    }

    public Set<String> getUntrackedFiles(Status status) throws GitAPIException {
        if (status == null) {
            status = new Git(this.getCurrentRepo()).status().call();
        }
        return status.getUntracked();
    }

    public Set<String> getIgnoredFiles(Status status) throws GitAPIException {
        if (status == null) {
            status = new Git(this.getCurrentRepo()).status().call();
        }
        return status.getIgnoredNotInIndex();
    }

    public Set<String> getConflictingFiles(Status status) throws GitAPIException {
        if (status == null) {
            status = new Git(this.getCurrentRepo()).status().call();
        }
        return status.getConflicting();
    }

    public Set<String> getMissingFiles(Status status) throws GitAPIException {
        if (status == null) {
            status = new Git(this.getCurrentRepo()).status().call();
        }
        return status.getMissing();
    }

    public Set<String> getModifiedFiles(Status status) throws GitAPIException {
        if (status == null) {
            status = new Git(this.getCurrentRepo()).status().call();
        }
        return status.getModified();
    }

    public Set<String> getStagedFiles(Status status) throws GitAPIException {
        if (status == null) {
            status = new Git(this.getCurrentRepo()).status().call();
        }
        HashSet<String> stagedFiles = new HashSet<String>();
        stagedFiles.addAll(status.getChanged());
        stagedFiles.addAll(status.getAdded());
        return stagedFiles;
    }

    public DirectoryRepoFile getParentDirectoryRepoFile() throws GitAPIException, IOException {
        Path fullPath = this.currentRepoHelper.getLocalPath();
        DirectoryRepoFile parentDirectoryRepoFile = new DirectoryRepoFile(fullPath, this.getCurrentRepoHelper());
        parentDirectoryRepoFile = this.populateDirectoryRepoFile(parentDirectoryRepoFile);
        return parentDirectoryRepoFile;
    }

    private DirectoryRepoFile populateDirectoryRepoFile(DirectoryRepoFile superDirectory) throws GitAPIException, IOException {
        try {
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(superDirectory.getFilePath());
            for (Path path : directoryStream) {
                if (path.equals(this.getCurrentRepo().getDirectory().toPath())) continue;
                if (Files.isDirectory(path, new LinkOption[0])) {
                    DirectoryRepoFile subdirectory = new DirectoryRepoFile(path, superDirectory.getRepo());
                    this.populateDirectoryRepoFile(subdirectory);
                    superDirectory.addChild(subdirectory);
                    continue;
                }
                Status status = new Git(this.getCurrentRepo()).status().call();
                Set<String> modifiedFiles = this.getModifiedFiles(status);
                Set<String> missingFiles = this.getMissingFiles(status);
                Set<String> untrackedFiles = this.getUntrackedFiles(status);
                Set<String> conflictingFiles = this.getConflictingFiles(status);
                Set<String> stagedFiles = this.getStagedFiles(status);
                Path repoDirectory = this.getCurrentRepo().getWorkTree().toPath();
                Path relativizedPath = repoDirectory.relativize(path);
                if (conflictingFiles.contains(relativizedPath.toString())) {
                    ConflictingRepoFile conflictingFile = new ConflictingRepoFile(path, this.getCurrentRepoHelper());
                    superDirectory.addChild(conflictingFile);
                    continue;
                }
                if (stagedFiles.contains(relativizedPath.toString())) {
                    StagedRepoFile stagedFile = new StagedRepoFile(path, this.getCurrentRepoHelper());
                    superDirectory.addChild(stagedFile);
                    continue;
                }
                if (modifiedFiles.contains(relativizedPath.toString())) {
                    ModifiedRepoFile modifiedFile = new ModifiedRepoFile(path, this.getCurrentRepoHelper());
                    superDirectory.addChild(modifiedFile);
                    continue;
                }
                if (missingFiles.contains(relativizedPath.toString())) {
                    MissingRepoFile missingFile = new MissingRepoFile(path, this.getCurrentRepoHelper());
                    superDirectory.addChild(missingFile);
                    continue;
                }
                if (untrackedFiles.contains(relativizedPath.toString())) {
                    UntrackedRepoFile untrackedFile = new UntrackedRepoFile(path, this.getCurrentRepoHelper());
                    superDirectory.addChild(untrackedFile);
                    continue;
                }
                RepoFile plainRepoFile = new RepoFile(path, this.getCurrentRepoHelper());
                superDirectory.addChild(plainRepoFile);
            }
        }
        catch (Exception e) {
            logger.error("Exception trying to populate directory repo file");
            logger.debug((Object)e.getStackTrace());
            e.printStackTrace();
        }
        return superDirectory;
    }

    public List<RepoFile> getAllChangedRepoFiles() throws GitAPIException {
        Status status = new Git(this.getCurrentRepo()).status().call();
        Set<String> modifiedFiles = this.getModifiedFiles(status);
        Set<String> missingFiles = this.getMissingFiles(status);
        Set<String> untrackedFiles = this.getUntrackedFiles(status);
        Set<String> conflictingFiles = this.getConflictingFiles(status);
        Set<String> stagedFiles = this.getStagedFiles(status);
        ArrayList<String> conflictingThenModifiedFiles = ConflictingFileWatcher.getConflictingThenModifiedFiles();
        ArrayList<RepoFile> changedRepoFiles = new ArrayList<RepoFile>();
        ArrayList<String> conflictingRepoFileStrings = new ArrayList<String>();
        for (String conflictingFileString : conflictingFiles) {
            if (conflictingThenModifiedFiles.contains(conflictingFileString)) {
                ConflictingThenModifiedRepoFile conflictingThenModifiedRepoFile = new ConflictingThenModifiedRepoFile(conflictingFileString, this.getCurrentRepoHelper());
                changedRepoFiles.add(conflictingThenModifiedRepoFile);
            } else {
                ConflictingRepoFile conflictingRepoFile = new ConflictingRepoFile(conflictingFileString, this.getCurrentRepoHelper());
                changedRepoFiles.add(conflictingRepoFile);
            }
            conflictingRepoFileStrings.add(conflictingFileString);
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String str : conflictingThenModifiedFiles) {
            if (conflictingFiles.contains(str)) continue;
            toRemove.add(str);
        }
        for (String str : toRemove) {
            ConflictingFileWatcher.removeFile(str);
        }
        for (String stagedFileString : stagedFiles) {
            if (!conflictingRepoFileStrings.contains(stagedFileString) && !modifiedFiles.contains(stagedFileString)) {
                StagedRepoFile stagedRepoFile = new StagedRepoFile(stagedFileString, this.getCurrentRepoHelper());
                changedRepoFiles.add(stagedRepoFile);
                continue;
            }
            if (conflictingRepoFileStrings.contains(stagedFileString)) continue;
            StagedAndModifiedRepoFile stagedAndModifiedRepoFile = new StagedAndModifiedRepoFile(stagedFileString, this.getCurrentRepoHelper());
            changedRepoFiles.add(stagedAndModifiedRepoFile);
        }
        for (String modifiedFileString : modifiedFiles) {
            if (conflictingRepoFileStrings.contains(modifiedFileString) || stagedFiles.contains(modifiedFileString)) continue;
            ModifiedRepoFile modifiedRepoFile = new ModifiedRepoFile(modifiedFileString, this.getCurrentRepoHelper());
            changedRepoFiles.add(modifiedRepoFile);
        }
        for (String missingFileString : missingFiles) {
            if (conflictingRepoFileStrings.contains(missingFileString)) continue;
            MissingRepoFile missingRepoFile = new MissingRepoFile(missingFileString, this.getCurrentRepoHelper());
            changedRepoFiles.add(missingRepoFile);
        }
        for (String untrackedFileString : untrackedFiles) {
            if (conflictingRepoFileStrings.contains(untrackedFileString)) continue;
            UntrackedRepoFile untrackedRepoFile = new UntrackedRepoFile(untrackedFileString, this.getCurrentRepoHelper());
            changedRepoFiles.add(untrackedRepoFile);
        }
        Collections.sort(changedRepoFiles);
        return changedRepoFiles;
    }

    public List<RepoFile> getAllRepoFiles() throws GitAPIException, IOException {
        List<RepoFile> allFiles = this.getAllChangedRepoFiles();
        Status status = new Git(this.getCurrentRepo()).status().call();
        for (String ignoredFileString : this.getIgnoredFiles(status)) {
            IgnoredRepoFile ignoredRepoFile = new IgnoredRepoFile(ignoredFileString, this.getCurrentRepoHelper());
            allFiles.add(ignoredRepoFile);
        }
        LinkedList allPaths = new LinkedList();
        Stream<Path> paths = Files.walk(this.currentRepoHelper.getLocalPath(), new FileVisitOption[0]).filter(path -> !path.toString().contains(File.separator + ".git" + File.separator) && !path.equals(this.currentRepoHelper.getLocalPath()) && !path.endsWith(".git"));
        Iterator iterator = null;
        try {
            paths.forEach(allPaths::add);
        }
        catch (Throwable throwable) {
            iterator = throwable;
            throw throwable;
        }
        finally {
            if (paths != null) {
                if (iterator != null) {
                    try {
                        paths.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)((Object)iterator)).addSuppressed(throwable);
                    }
                } else {
                    paths.close();
                }
            }
        }
        HashSet<Path> addedPaths = new HashSet<Path>();
        for (RepoFile file : allFiles) {
            addedPaths.add(file.getFilePath());
        }
        for (Path path2 : allPaths) {
            path2 = this.currentRepoHelper.getLocalPath().relativize(path2);
            if (addedPaths.contains(path2)) continue;
            RepoFile temp = path2.toFile().isDirectory() ? new DirectoryRepoFile(path2, this.currentRepoHelper) : new RepoFile(path2, this.currentRepoHelper);
            allFiles.add(temp);
            addedPaths.add(path2);
        }
        Collections.sort(allFiles);
        return allFiles;
    }

    private void saveListOfRepoPathStrings() throws BackingStoreException, IOException, ClassNotFoundException {
        ArrayList<String> repoPathStrings = new ArrayList<String>();
        for (RepoHelper repoHelper : this.allRepoHelpers) {
            Path path = repoHelper.getLocalPath();
            repoPathStrings.add(path.toString());
        }
        PrefObj.putObject(this.preferences, RECENT_REPOS_LIST_KEY, repoPathStrings);
    }

    private void saveMostRecentRepoPathString() throws BackingStoreException, IOException, ClassNotFoundException {
        String pathString = this.currentRepoHelper.getLocalPath().toString();
        PrefObj.putObject(this.preferences, LAST_OPENED_REPO_PATH_KEY, pathString);
    }

    public void clearStoredPreferences() throws BackingStoreException, IOException, ClassNotFoundException {
        PrefObj.putObject(this.preferences, RECENT_REPOS_LIST_KEY, null);
        PrefObj.putObject(this.preferences, LAST_OPENED_REPO_PATH_KEY, null);
        PrefObj.putObject(this.preferences, LAST_UUID_KEY, null);
    }

    public void setAuthPref(String pathname, AuthMethod authTechnique) {
        Preferences authPrefs = this.preferences.node("authentication");
        authPrefs.putInt(this.hashPathname(pathname), authTechnique.getEnumValue());
    }

    public AuthMethod getAuthPref(String pathname) {
        Preferences authPrefs = this.preferences.node("authentication");
        int enumValue = authPrefs.getInt(this.hashPathname(pathname), -1);
        if (enumValue == -1) {
            throw new NoSuchElementException("AuthPref not present");
        }
        return AuthMethod.getEnumFromValue(enumValue);
    }

    public void removeAuthPref(String pathname) {
        Preferences authPrefs = this.preferences.node("authentication");
        authPrefs.remove(this.hashPathname(pathname));
    }

    public String[] listAuthPaths() {
        Preferences authPrefs = this.preferences.node("authentication");
        try {
            return authPrefs.keys();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    String hashPathname(String pathname) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        md.update(pathname.getBytes());
        String prefKey = null;
        prefKey = DatatypeConverter.printHexBinary((byte[])md.digest());
        return prefKey;
    }

    public void removeRepoHelpers(List<RepoHelper> checkedItems) {
        for (RepoHelper item : checkedItems) {
            this.allRepoHelpers.remove(item);
        }
    }

    public void resetSessionModel() {
        try {
            this.clearStoredPreferences();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        sessionModel = new SessionModel();
    }

    public void setLastUUID(String uuid) throws BackingStoreException, ClassNotFoundException, IOException {
        PrefObj.putObject(this.preferences, LAST_UUID_KEY, uuid);
    }

    public String getLastUUID() throws BackingStoreException, ClassNotFoundException, IOException {
        return (String)PrefObj.getObject(this.preferences, LAST_UUID_KEY);
    }

    static {
        logger = LogManager.getLogger();
    }
}

