/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import elegit.BranchHelper;
import elegit.BranchModel;
import elegit.RepoHelper;
import elegit.SessionModel;
import elegit.controllers.SessionController;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;

public class RepositoryMonitor {
    public static final long REMOTE_CHECK_INTERVAL = 6000L;
    public static final long LOCAL_CHECK_INTERVAL = 5000L;
    public static BooleanProperty hasFoundNewRemoteChanges = new SimpleBooleanProperty(false);
    private static boolean ignoreNewRemoteChanges = false;
    private static boolean pauseLocalMonitor = false;
    private static int pauseCounter = 0;
    private static boolean ignoreUnpause = false;
    private static Thread th;
    private static boolean interrupted;
    private static SessionModel currentModel;
    private static boolean alreadyWatching;

    public static void setSessionModel(SessionModel model) {
        currentModel = model;
    }

    public static void startWatching(SessionModel model, SessionController controller) {
        RepositoryMonitor.setSessionModel(model);
        if (!alreadyWatching) {
            RepositoryMonitor.beginWatchingLocal(controller);
            RepositoryMonitor.beginWatchingRemote();
            alreadyWatching = true;
        }
    }

    private static void beginWatchingRemote() {
        RepositoryMonitor.currentModel.currentRepoHelperProperty.addListener((observable, oldValue, newValue) -> RepositoryMonitor.watchRepoForRemoteChanges(newValue));
        RepositoryMonitor.watchRepoForRemoteChanges(currentModel.getCurrentRepoHelper());
    }

    private static synchronized void watchRepoForRemoteChanges(RepoHelper repo) {
        RepositoryMonitor.pause();
        if (th != null) {
            interrupted = true;
            try {
                th.join();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                interrupted = false;
                th = null;
            }
        }
        if (repo == null || !repo.exists() || !repo.hasRemoteProperty.get()) {
            RepositoryMonitor.unpause();
            return;
        }
        th = new Thread(() -> {
            while (!interrupted) {
                block8: {
                    try {
                        List<BranchHelper> localOriginHeads = repo.getBranchModel().getBranchListUntyped(BranchModel.BranchType.REMOTE);
                        Collection<Ref> remoteHeads = repo.getRefsFromRemote(false);
                        if (localOriginHeads.size() >= remoteHeads.size()) {
                            for (Ref ref : remoteHeads) {
                                boolean hasFoundMatchingBranch = false;
                                boolean hasFoundNewChanges = false;
                                for (BranchHelper branch : localOriginHeads) {
                                    if (!ref.getName().equals("refs/heads/" + repo.getRepo().shortenRemoteBranchName(branch.getRefPathString()))) continue;
                                    hasFoundMatchingBranch = true;
                                    if (branch.getHeadId().equals((AnyObjectId)ref.getObjectId())) break;
                                    hasFoundNewChanges = true;
                                    break;
                                }
                                if (!hasFoundNewChanges && hasFoundMatchingBranch) continue;
                                RepositoryMonitor.setFoundNewChanges();
                                break block8;
                            }
                            break block8;
                        }
                        RepositoryMonitor.setFoundNewChanges();
                    }
                    catch (IOException | GitAPIException localOriginHeads) {
                        // empty catch block
                    }
                }
                try {
                    Thread.sleep(6000L);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        });
        th.setDaemon(true);
        th.setName("Remote monitor for repository \"" + repo + "\"");
        th.setPriority(2);
        th.start();
        RepositoryMonitor.unpause();
    }

    private static void setFoundNewChanges() {
        if (!ignoreNewRemoteChanges) {
            hasFoundNewRemoteChanges.set(true);
        }
    }

    public static synchronized void resetFoundNewChanges(boolean ignore) {
        if (ignore) {
            RepositoryMonitor.resetFoundNewChanges(-1L);
        } else {
            RepositoryMonitor.resetFoundNewChanges(12000L);
        }
    }

    public static synchronized void resetFoundNewChanges(long millis) {
        RepositoryMonitor.pauseWatchingRemote(millis);
        hasFoundNewRemoteChanges.set(false);
    }

    private static synchronized void beginWatchingLocal(SessionController controller) {
        Thread thread = new Thread(() -> {
            while (true) {
                if (!pauseLocalMonitor && currentModel.getCurrentRepoHelper() != null && currentModel.getCurrentRepoHelper().exists()) {
                    controller.gitStatus();
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        });
        thread.setDaemon(true);
        thread.setName("Local monitor");
        thread.setPriority(2);
        thread.start();
    }

    private static void pauseWatchingRemote(long millis) {
        ignoreNewRemoteChanges = true;
        if (millis < 0L) {
            ignoreUnpause = true;
            return;
        }
        ignoreUnpause = false;
        Thread waitThread = new Thread(() -> {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                ignoreNewRemoteChanges = false;
            }
        });
        waitThread.setDaemon(true);
        waitThread.setName("Remote monitor ignore timer");
        waitThread.setPriority(2);
        waitThread.start();
    }

    private static void pauseWatchingLocal(long millis) {
        pauseLocalMonitor = true;
        if (millis < 0L) {
            ignoreUnpause = true;
            return;
        }
        ignoreUnpause = false;
        Thread waitThread = new Thread(() -> {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                pauseLocalMonitor = false;
            }
        });
        waitThread.setDaemon(true);
        waitThread.setName("Local monitor pause timer");
        waitThread.setPriority(2);
        waitThread.start();
    }

    public static synchronized void pause(long millis) {
        RepositoryMonitor.pauseWatchingLocal(millis);
        RepositoryMonitor.pauseWatchingRemote(millis);
    }

    public static synchronized void pause() {
        if (pauseCounter == 0) {
            RepositoryMonitor.pause(-1L);
        }
        ++pauseCounter;
    }

    public static synchronized void unpause() {
        if (--pauseCounter == 0) {
            RepositoryMonitor.pause(0L);
        }
    }

    static {
        interrupted = false;
        alreadyWatching = false;
    }
}

