/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import elegit.AuthMethod;
import elegit.RepoHelper;
import elegit.SessionModel;
import elegit.exceptions.CancelledAuthorizationException;
import elegit.exceptions.NoRepoSelectedException;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogEvent;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jgit.api.errors.GitAPIException;

public abstract class RepoHelperBuilder {
    SessionModel sessionModel;
    private String defaultFilePickerStartFolder = System.getProperty("user.home");
    static final Logger logger = LogManager.getLogger();

    public RepoHelperBuilder(SessionModel sessionModel) {
        this.sessionModel = sessionModel;
    }

    public abstract RepoHelper getRepoHelperFromDialogs() throws GitAPIException, IOException, NoRepoSelectedException, CancelledAuthorizationException;

    public File getDirectoryPathFromChooser(String title, Window parent) {
        File path = new File(this.defaultFilePickerStartFolder);
        DirectoryChooser chooser = new DirectoryChooser();
        chooser.setTitle(title);
        chooser.setInitialDirectory(path);
        File returnFile = chooser.showDialog(parent);
        return returnFile;
    }

    public static AuthDialogResponse getAuthCredentialFromDialog() throws CancelledAuthorizationException {
        logger.info("Creating authorization dialog");
        Dialog dialog = new Dialog();
        dialog.setTitle("Authorize");
        dialog.setHeaderText("Please enter your remote repository authentication.");
        ButtonType loginButtonType = new ButtonType("Authorize", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{loginButtonType, ButtonType.CANCEL});
        dialog.setOnCloseRequest((EventHandler)new EventHandler<DialogEvent>(){

            public void handle(DialogEvent event) {
                logger.info("Closing authorization dialog");
            }
        });
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(20.0, 150.0, 10.0, 10.0));
        grid.add((Node)new Label("Protocol:"), 0, 0);
        ObservableList protocols = FXCollections.observableArrayList(AuthMethod.getStrings());
        ComboBox protocol = new ComboBox(protocols);
        protocol.setValue((Object)"HTTPS");
        grid.add((Node)protocol, 1, 0);
        grid.add((Node)new Label("Username:"), 0, 1);
        Object hashedUsername = null;
        String hashedPassword = null;
        final TextField username = new TextField();
        username.setPromptText("Username");
        grid.add((Node)username, 1, 1);
        grid.add((Node)new Label("Password:"), 0, 2);
        final PasswordField password = new PasswordField();
        final CheckBox remember = new CheckBox("Remember Password");
        if (hashedPassword != null) {
            password.setText(hashedPassword);
            remember.setSelected(true);
        }
        password.setPromptText("Password");
        grid.add((Node)password, 1, 2);
        Button editUsername = new Button();
        editUsername.setText("Edit");
        editUsername.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                username.setEditable(true);
                password.setText("");
                remember.setSelected(false);
            }
        });
        if (hashedUsername == null) {
            editUsername.setVisible(false);
        }
        grid.add((Node)editUsername, 2, 1);
        remember.setIndeterminate(false);
        grid.add((Node)remember, 1, 3);
        Node loginButton = dialog.getDialogPane().lookupButton(loginButtonType);
        if (hashedPassword == null || hashedUsername == null) {
            loginButton.setDisable(true);
        }
        password.textProperty().addListener((observable, oldValue, newValue) -> loginButton.setDisable(newValue.trim().isEmpty()));
        username.textProperty().addListener((observable, oldValue, newValue) -> loginButton.setDisable(newValue.trim().isEmpty()));
        dialog.getDialogPane().setContent((Node)grid);
        if (username.getText() != null) {
            Platform.runLater(() -> username.requestFocus());
        } else {
            Platform.runLater(() -> password.requestFocus());
        }
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == loginButtonType) {
                AuthMethod protocolEnum = AuthMethod.getEnumFromString((String)protocol.getValue());
                return new AuthDialogResponse(protocolEnum, username.getText(), password.getText(), remember.isSelected());
            }
            return null;
        });
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            UsernamePassword usernamePassword = new UsernamePassword();
            usernamePassword.username = ((AuthDialogResponse)result.get()).username;
            if (((AuthDialogResponse)result.get()).isSelected) {
                logger.info("Selected remember password");
                usernamePassword.password = ((AuthDialogResponse)result.get()).password;
            }
        } else {
            logger.info("Cancelled authorization dialog");
            throw new CancelledAuthorizationException();
        }
        logger.info("Entered authorization credentials");
        return (AuthDialogResponse)result.get();
    }

    public static class AuthDialogResponse {
        public AuthMethod protocol;
        public String username;
        public String password;
        public boolean isSelected;

        public AuthDialogResponse(AuthMethod protocol, String username, String password, boolean isSelected) {
            this.protocol = protocol;
            this.username = username;
            this.password = password;
            this.isSelected = isSelected;
        }
    }

    private static class UsernamePassword {
        public String username;
        public String password;

        private UsernamePassword() {
        }
    }
}

