/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import elegit.AuthMethod;
import elegit.BranchHelper;
import elegit.BranchModel;
import elegit.CommitHelper;
import elegit.ElegitCredentialsProvider;
import elegit.LocalBranchHelper;
import elegit.PopUpWindows;
import elegit.RefHelper;
import elegit.SimpleProgressMonitor;
import elegit.TagHelper;
import elegit.TagModel;
import elegit.exceptions.CancelledAuthorizationException;
import elegit.exceptions.ConflictingFilesException;
import elegit.exceptions.MissingRepoException;
import elegit.exceptions.NoCommitsToPushException;
import elegit.exceptions.NoFilesToStashException;
import elegit.exceptions.NoTrackingException;
import elegit.exceptions.PushToAheadRemoteError;
import elegit.treefx.Cell;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.RevertCommand;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.StashApplyCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.ignore.IgnoreNode;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BranchTrackingStatus;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revplot.PlotCommitList;
import org.eclipse.jgit.revplot.PlotLane;
import org.eclipse.jgit.revplot.PlotWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportGitSsh;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.FS;

public class RepoHelper {
    public String username;
    protected String password;
    protected Repository repo;
    public Path localPath;
    protected File credentialsFile;
    protected List<String> credentialsList;
    protected UserInfo userInfo;
    protected SshSessionFactory sshSessionFactory;
    private List<CommitHelper> localCommits;
    private List<CommitHelper> remoteCommits;
    private Map<String, CommitHelper> commitIdMap;
    private Map<ObjectId, String> idMap;
    private BranchModel branchModel;
    private TagModel tagModel;
    public BooleanProperty hasRemoteProperty;
    static final Logger logger = LogManager.getLogger();
    public UsernamePasswordCredentialsProvider ownerAuth;

    public RepoHelper(Path directoryPath) throws GitAPIException, IOException, CancelledAuthorizationException {
        this.username = null;
        this.localPath = directoryPath;
        this.setupSshSessionFactory();
    }

    public RepoHelper(Path directoryPath, UsernamePasswordCredentialsProvider ownerAuth) throws GitAPIException, IOException, CancelledAuthorizationException {
        this.localPath = directoryPath;
        this.ownerAuth = ownerAuth;
        this.password = null;
        this.setupSshSessionFactory();
    }

    public RepoHelper(Path directoryPath, String sshPassword) throws GitAPIException, IOException, CancelledAuthorizationException {
        this.localPath = directoryPath;
        this.ownerAuth = null;
        this.password = sshPassword;
        this.setupSshSessionFactory();
    }

    public RepoHelper(Path directoryPath, File credentialsFile) throws GitAPIException, IOException, CancelledAuthorizationException {
        this.localPath = directoryPath;
        this.ownerAuth = null;
        this.password = null;
        this.credentialsFile = credentialsFile;
        this.setupSshSessionFactory();
    }

    public RepoHelper(Path directoryPath, UserInfo userInfo) throws GitAPIException, IOException, CancelledAuthorizationException {
        this.localPath = directoryPath;
        this.ownerAuth = null;
        this.password = null;
        this.credentialsFile = null;
        this.userInfo = userInfo;
        this.setupSshSessionFactory();
    }

    public RepoHelper(Path directoryPath, String sshPassword, UserInfo userInfo) throws GitAPIException, IOException, CancelledAuthorizationException {
        this.localPath = directoryPath;
        this.ownerAuth = null;
        this.password = sshPassword;
        this.credentialsFile = null;
        this.userInfo = userInfo;
        this.setupSshSessionFactory();
    }

    public RepoHelper(String sshPassword) {
        this.password = sshPassword;
        this.setupSshSessionFactory();
    }

    public RepoHelper(UserInfo userInfo) {
        this.userInfo = userInfo;
        this.setupSshSessionFactory();
    }

    public void setupSshSessionFactory() {
        this.sshSessionFactory = new JschConfigSessionFactory(){

            protected void configure(OpenSshConfig.Host host, Session session) {
                session.setPassword(RepoHelper.this.password);
                session.setUserInfo(RepoHelper.this.userInfo);
            }

            protected JSch createDefaultJSch(FS fs) throws JSchException {
                JSch defaultJSch = super.createDefaultJSch(fs);
                defaultJSch.removeAllIdentity();
                return defaultJSch;
            }
        };
    }

    void wrapAuthentication(TransportCommand command, UsernamePasswordCredentialsProvider ownerAuth) {
        this.wrapAuthentication(command, ownerAuth, null, null, null, null);
    }

    void wrapAuthentication(TransportCommand command, String sshPassword) {
        this.wrapAuthentication(command, null, sshPassword, null, null, null);
    }

    void wrapAuthentication(TransportCommand command, UsernamePasswordCredentialsProvider ownerAuth, String sshPassword) {
        this.wrapAuthentication(command, ownerAuth, sshPassword, null, null, null);
    }

    void wrapAuthentication(TransportCommand command, File credentialsFile) {
        this.wrapAuthentication(command, null, null, credentialsFile, null, null);
    }

    void wrapAuthentication(TransportCommand command, List<String> credentialsList) {
        this.wrapAuthentication(command, null, null, null, credentialsList, null);
    }

    void wrapAuthentication(TransportCommand command, UserInfo userInfo) {
        this.wrapAuthentication(command, null, null, null, null, userInfo);
    }

    void wrapAuthentication(TransportCommand command) {
        this.wrapAuthentication(command, null, null, null, null, null);
    }

    void wrapAuthentication(TransportCommand command, UsernamePasswordCredentialsProvider ownerAuth, String sshPassword, File credentialsFile, List<String> credentialsList, UserInfo userInfo) {
        if (ownerAuth != null) {
            command.setCredentialsProvider((CredentialsProvider)ownerAuth);
        } else {
            command.setCredentialsProvider((CredentialsProvider)new ElegitCredentialsProvider(credentialsList));
        }
        command.setTransportConfigCallback(new TransportConfigCallback(){

            public void configure(Transport transport) {
                if (transport instanceof TransportGitSsh) {
                    SshTransport sshTransport = (SshTransport)transport;
                    sshTransport.setSshSessionFactory(RepoHelper.this.sshSessionFactory);
                }
            }
        });
    }

    protected void myWrapAuthentication(TransportCommand command) {
        this.wrapAuthentication(command, this.ownerAuth, this.password, this.credentialsFile, this.credentialsList, this.userInfo);
    }

    protected void setup() throws GitAPIException, IOException {
        this.username = null;
        this.commitIdMap = new HashMap<String, CommitHelper>();
        this.idMap = new HashMap<ObjectId, String>();
        this.branchModel = new BranchModel(this);
        this.localCommits = this.parseAllLocalCommits();
        this.remoteCommits = this.parseAllRemoteCommits();
        this.tagModel = new TagModel(this);
        this.hasRemoteProperty = new SimpleBooleanProperty(!this.getLinkedRemoteRepoURLs().isEmpty());
    }

    public void setUsernamePasswordCredentials(UsernamePasswordCredentialsProvider ownerAuth) {
        this.ownerAuth = ownerAuth;
    }

    public void updateModel() throws GitAPIException, IOException {
        this.commitIdMap = new HashMap<String, CommitHelper>();
        this.idMap = new HashMap<ObjectId, String>();
        this.branchModel.updateAllBranches();
        this.localCommits = this.parseAllLocalCommits();
        this.remoteCommits = this.parseAllRemoteCommits();
        this.tagModel.updateTags();
    }

    public boolean exists() {
        logger.debug("Checked if repo still exists");
        return this.localPath.toFile().exists() && this.localPath.toFile().list((dir, name) -> name.equals(".git")).length > 0;
    }

    public void addFilePathTest(Path filePath) throws GitAPIException {
        Git git = new Git(this.repo);
        Path relativizedFilePath = this.localPath.relativize(filePath);
        git.add().addFilepattern(relativizedFilePath.toString()).call();
        git.close();
    }

    public void addFilePathsTest(ArrayList<Path> filePaths) throws GitAPIException {
        Git git = new Git(this.repo);
        AddCommand adder = git.add();
        for (Path filePath : filePaths) {
            Path localizedFilePath = this.localPath.relativize(filePath);
            adder.addFilepattern(localizedFilePath.toString());
        }
        adder.call();
        git.close();
    }

    public void addFilePath(Path filePath) throws GitAPIException {
        Git git = new Git(this.repo);
        Path relativizedFilePath = this.localPath.relativize(filePath);
        git.add().addFilepattern(relativizedFilePath.toString()).call();
        git.close();
    }

    public void addFilePaths(ArrayList<Path> filePaths) throws GitAPIException {
        Git git = new Git(this.repo);
        AddCommand adder = git.add();
        for (Path filePath : filePaths) {
            adder.addFilepattern(filePath.toString());
        }
        adder.call();
        git.close();
    }

    public void checkoutFile(Path filePath) throws GitAPIException {
        Git git = new Git(this.repo);
        git.checkout().addPath(filePath.toString()).call();
        git.close();
    }

    public void checkoutFiles(List<Path> filePaths) throws GitAPIException {
        Git git = new Git(this.repo);
        CheckoutCommand checkout = git.checkout().setStartPoint("HEAD");
        for (Path filePath : filePaths) {
            checkout.addPath(filePath.toString());
        }
        checkout.call();
        git.close();
    }

    public void checkoutFile(String filePath, String startPoint) throws GitAPIException {
        Git git = new Git(this.repo);
        git.checkout().setStartPoint(startPoint).addPath(filePath).call();
        git.close();
    }

    public CheckoutResult checkoutFiles(List<String> filePaths, String startPoint) throws GitAPIException {
        Git git = new Git(this.repo);
        CheckoutCommand checkout = git.checkout().setStartPoint(startPoint);
        for (String filePath : filePaths) {
            checkout.addPath(filePath);
        }
        checkout.call();
        return checkout.getResult();
    }

    public void removeFilePath(Path filePath) throws GitAPIException {
        Git git = new Git(this.repo);
        git.rm().addFilepattern(filePath.toString()).call();
        git.close();
    }

    public void removeFilePaths(ArrayList<Path> filePaths) throws GitAPIException {
        Git git = new Git(this.repo);
        RmCommand remover = git.rm();
        for (Path filePath : filePaths) {
            remover.addFilepattern(filePath.toString());
        }
        remover.call();
        git.close();
    }

    public List<String> getLinkedRemoteRepoURLs() {
        StoredConfig storedConfig = this.repo.getConfig();
        Set remotes = storedConfig.getSubsections("remote");
        ArrayList<String> urls = new ArrayList<String>(remotes.size());
        for (String remote : remotes) {
            urls.add(storedConfig.getString("remote", remote, "url"));
        }
        return urls;
    }

    public boolean hasRemote() {
        return this.hasRemoteProperty.get();
    }

    public int getAheadCount() throws IOException {
        if (this.branchModel.getCurrentBranch().getStatus() != null) {
            return this.branchModel.getCurrentBranch().getStatus().getAheadCount();
        }
        return -1;
    }

    public int getAheadCountAll() throws IOException {
        int aheadCount = 0;
        for (BranchHelper branchHelper : this.branchModel.getLocalBranchesTyped()) {
            if (branchHelper.getStatus() == null) continue;
            aheadCount += branchHelper.getStatus().getAheadCount();
        }
        return aheadCount;
    }

    public int getBehindCount() throws IOException {
        if (this.branchModel.getCurrentBranch().getStatus() != null) {
            return this.branchModel.getCurrentBranch().getStatus().getBehindCount();
        }
        return -1;
    }

    public void commit(String commitMessage) throws GitAPIException, MissingRepoException {
        logger.info("Attempting commit");
        if (!this.exists()) {
            throw new MissingRepoException();
        }
        Git git = new Git(this.repo);
        git.commit().setMessage(commitMessage).call();
        git.close();
        try {
            this.localCommits = this.parseAllLocalCommits();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void commitAll(String message) throws MissingRepoException, GitAPIException, IOException {
        if (!this.exists()) {
            throw new MissingRepoException();
        }
        Git git = new Git(this.repo);
        git.commit().setMessage(message).setAll(true).call();
        git.close();
        this.localCommits = this.parseAllLocalCommits();
    }

    public PushCommand prepareToPushCurrentBranch(boolean isTest) throws MissingRepoException, GitAPIException, PushToAheadRemoteError, IOException, NoCommitsToPushException {
        BranchHelper branchToPush = this.getBranchModel().getCurrentBranch();
        logger.info("attempting to push current branch");
        if (!this.exists()) {
            throw new MissingRepoException();
        }
        if (!this.hasRemote()) {
            throw new InvalidRemoteException("No remote repository");
        }
        String remote = this.getRemote();
        if (remote.equals("cancel")) {
            throw new InvalidRemoteException("No remote selected.");
        }
        Git git = new Git(this.repo);
        PushCommand push = git.push().setRemote(remote).add(branchToPush.getRefPathString());
        SimpleProgressMonitor progress = new SimpleProgressMonitor();
        push.setProgressMonitor((ProgressMonitor)progress);
        if (this.getBranchModel().getCurrentRemoteBranch() == null) {
            if (isTest || PopUpWindows.trackCurrentBranchRemotely(branchToPush.getRefName())) {
                this.setUpstreamBranch(branchToPush, remote);
            } else {
                throw new NoCommitsToPushException();
            }
        }
        return push;
    }

    public void pushCurrentBranch(PushCommand push) throws GitAPIException, PushToAheadRemoteError, IOException {
        this.myWrapAuthentication((TransportCommand)push);
        Iterable pushResult = push.call();
        for (PushResult result : pushResult) {
            for (RemoteRefUpdate remoteRefUpdate : result.getRemoteUpdates()) {
                if (remoteRefUpdate.getStatus().equals((Object)RemoteRefUpdate.Status.OK)) continue;
                throw new PushToAheadRemoteError(false);
            }
        }
        push.getRepository().close();
        this.remoteCommits = this.parseAllRemoteCommits();
    }

    private void setUpstreamBranch(BranchHelper branch, String remote) throws IOException {
        Git git = new Git(this.repo);
        StoredConfig config = git.getRepository().getConfig();
        String branchName = branch.getRefName();
        config.setString("branch", branchName, "remote", remote);
        config.setString("branch", branchName, "merge", "refs/heads/" + branchName);
        config.save();
    }

    private String getRemote() {
        Git git = new Git(this.repo);
        StoredConfig config = git.getRepository().getConfig();
        Set remotes = config.getSubsections("remote");
        if (remotes.size() == 1) {
            return (String)remotes.toArray()[0];
        }
        return PopUpWindows.pickRemoteToPushTo(remotes);
    }

    public PushCommand prepareToPushAll() throws GitAPIException, MissingRepoException, PushToAheadRemoteError, IOException, NoCommitsToPushException {
        logger.info("Attempting push");
        if (!this.exists()) {
            throw new MissingRepoException();
        }
        if (!this.hasRemote()) {
            throw new InvalidRemoteException("No remote repository");
        }
        String remote = this.getRemote();
        if (remote.equals("cancel")) {
            throw new InvalidRemoteException("No remote selected.");
        }
        Git git = new Git(this.repo);
        PushCommand push = git.push().setRemote(remote);
        ArrayList<LocalBranchHelper> untrackedLocalBranches = new ArrayList<LocalBranchHelper>();
        ArrayList<Object> branchesToTrack = new ArrayList();
        for (LocalBranchHelper localBranchHelper : this.branchModel.getLocalBranchesTyped()) {
            if (BranchTrackingStatus.of((Repository)this.repo, (String)localBranchHelper.getRefName()) != null) {
                push.add(localBranchHelper.getRefPathString());
                continue;
            }
            untrackedLocalBranches.add(localBranchHelper);
        }
        if (untrackedLocalBranches.size() > 0) {
            branchesToTrack = PopUpWindows.getUntrackedBranchesToPush(untrackedLocalBranches);
            if (branchesToTrack != null) {
                for (LocalBranchHelper localBranchHelper : branchesToTrack) {
                    push.add(localBranchHelper.getRefPathString());
                    this.setUpstreamBranch(localBranchHelper, remote);
                }
            } else if (this.getAheadCountAll() < 1) {
                throw new NoCommitsToPushException();
            }
        }
        SimpleProgressMonitor progress = new SimpleProgressMonitor();
        push.setProgressMonitor((ProgressMonitor)progress);
        return push;
    }

    public void pushAll(PushCommand push) throws GitAPIException, PushToAheadRemoteError, IOException {
        this.myWrapAuthentication((TransportCommand)push);
        Iterable pushResult = push.call();
        boolean allPushesWereRejected = true;
        boolean anyPushWasRejected = false;
        for (PushResult result : pushResult) {
            for (RemoteRefUpdate remoteRefUpdate : result.getRemoteUpdates()) {
                if (remoteRefUpdate.getStatus() != RemoteRefUpdate.Status.REJECTED_NONFASTFORWARD) {
                    allPushesWereRejected = false;
                    continue;
                }
                anyPushWasRejected = true;
            }
        }
        if (allPushesWereRejected || anyPushWasRejected) {
            throw new PushToAheadRemoteError(allPushesWereRejected);
        }
        push.getRepository().close();
        this.remoteCommits = this.parseAllRemoteCommits();
    }

    public Iterable<PushResult> pushTags() throws GitAPIException, MissingRepoException, PushToAheadRemoteError, IOException {
        logger.info("Attempting push tags");
        if (!this.exists()) {
            throw new MissingRepoException();
        }
        if (!this.hasRemote()) {
            throw new InvalidRemoteException("No remote repository");
        }
        Git git = new Git(this.repo);
        PushCommand push = git.push();
        this.myWrapAuthentication((TransportCommand)push);
        SimpleProgressMonitor progress = new SimpleProgressMonitor();
        push.setProgressMonitor((ProgressMonitor)progress);
        Iterable pushResult = push.setPushTags().call();
        boolean allPushesWereRejected = true;
        boolean anyPushWasRejected = false;
        for (PushResult result : pushResult) {
            for (RemoteRefUpdate remoteRefUpdate : result.getRemoteUpdates()) {
                if (remoteRefUpdate.getStatus() != RemoteRefUpdate.Status.REJECTED_NONFASTFORWARD) {
                    allPushesWereRejected = false;
                    continue;
                }
                anyPushWasRejected = true;
                System.out.println(remoteRefUpdate);
            }
        }
        if (allPushesWereRejected || anyPushWasRejected) {
            throw new PushToAheadRemoteError(allPushesWereRejected);
        }
        git.close();
        this.tagModel.updateTags();
        return pushResult;
    }

    public boolean fetch(boolean prune) throws GitAPIException, MissingRepoException, IOException {
        logger.info("Attempting fetch");
        if (!this.exists()) {
            throw new MissingRepoException();
        }
        Git git = new Git(this.repo);
        StoredConfig config = this.repo.getConfig();
        if (prune) {
            config.setString("fetch", null, "prune", "true");
            config.save();
        }
        FetchCommand fetch = git.fetch().setTagOpt(TagOpt.AUTO_FOLLOW);
        this.myWrapAuthentication((TransportCommand)fetch);
        fetch.setCheckFetchedObjects(true);
        SimpleProgressMonitor progress = new SimpleProgressMonitor();
        fetch.setProgressMonitor((ProgressMonitor)progress);
        FetchResult result = fetch.call();
        git.close();
        try {
            this.remoteCommits = this.parseAllRemoteCommits();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.branchModel.updateRemoteBranches();
        if (prune) {
            config.unsetSection("fetch", null);
            config.save();
        }
        return !result.getTrackingRefUpdates().isEmpty();
    }

    public MergeResult.MergeStatus mergeFromFetch() throws IOException, GitAPIException, MissingRepoException, ConflictingFilesException, NoTrackingException {
        logger.info("Attempting merge from fetch");
        if (!this.exists()) {
            throw new MissingRepoException();
        }
        if (!this.hasRemote()) {
            throw new InvalidRemoteException("No remote repository");
        }
        StoredConfig config = this.repo.getConfig();
        if (!config.getSubsections("branch").contains(this.repo.getBranch())) {
            throw new NoTrackingException();
        }
        String remote22 = config.getString("branch", this.repo.getBranch(), "remote") + "/";
        String remote_tracking = config.getString("branch", this.repo.getBranch(), "merge");
        MergeResult result = this.branchModel.mergeWithBranch(this.branchModel.getBranchByName(BranchModel.BranchType.REMOTE, remote22 + Repository.shortenRefName((String)remote_tracking)));
        try {
            this.localCommits = this.parseAllLocalCommits();
        }
        catch (IOException remote22) {
            // empty catch block
        }
        MergeResult.MergeStatus status = result.getMergeStatus();
        if (status == MergeResult.MergeStatus.CONFLICTING) {
            throw new ConflictingFilesException(result.getConflicts());
        }
        return status;
    }

    public void revertHelpers(List<CommitHelper> commits) throws MissingRepoException, GitAPIException {
        ArrayList<AnyObjectId> commitIds = new ArrayList<AnyObjectId>();
        for (CommitHelper helper : commits) {
            commitIds.add((AnyObjectId)helper.getCommit());
        }
        this.revert(commitIds);
    }

    void revert(List<AnyObjectId> commits) throws MissingRepoException, GitAPIException {
        logger.info("Attempting reverts");
        if (!this.exists()) {
            throw new MissingRepoException();
        }
        Git git = new Git(this.repo);
        RevertCommand revertCommand = git.revert();
        for (AnyObjectId commit : commits) {
            revertCommand.include(commit);
        }
        revertCommand.call();
        git.close();
        try {
            this.localCommits = this.parseAllLocalCommits();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void revert(CommitHelper helper) throws MissingRepoException, GitAPIException {
        logger.info("Attempting revert");
        if (!this.exists()) {
            throw new MissingRepoException();
        }
        Git git = new Git(this.repo);
        git.revert().include((AnyObjectId)helper.getObjectId()).call();
        git.close();
        try {
            this.localCommits = this.parseAllLocalCommits();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void reset(Path path) throws MissingRepoException, GitAPIException {
        logger.info("Attempting reset file");
        if (!this.exists()) {
            throw new MissingRepoException();
        }
        Git git = new Git(this.repo);
        git.reset().addPath(this.localPath.relativize(path).toString()).call();
        git.close();
    }

    void reset(List<Path> paths) throws MissingRepoException, GitAPIException {
        logger.info("Attempting reset files");
        if (!this.exists()) {
            throw new MissingRepoException();
        }
        Git git = new Git(this.repo);
        ResetCommand resetCommand = git.reset();
        paths.forEach(path -> resetCommand.addPath(this.localPath.relativize((Path)path).toString()));
        resetCommand.call();
        git.close();
    }

    void reset(CommitHelper commit) throws MissingRepoException, GitAPIException {
        this.reset(commit.getId(), ResetCommand.ResetType.MIXED);
    }

    public void reset(String ref, ResetCommand.ResetType mode) throws MissingRepoException, GitAPIException {
        logger.info("Attempting reset");
        if (!this.exists()) {
            throw new MissingRepoException();
        }
        Git git = new Git(this.repo);
        git.reset().setRef(ref).setMode(mode).call();
        git.close();
    }

    public void stashSave(boolean includeUntracked) throws GitAPIException, NoFilesToStashException {
        logger.info("Attempting stash save");
        Git git = new Git(this.repo);
        RevCommit stash = git.stashCreate().setIncludeUntracked(includeUntracked).call();
        if (stash == null) {
            throw new NoFilesToStashException();
        }
    }

    public void stashSave(boolean includeUntracked, String wdMessage, String indexMessage) throws GitAPIException, NoFilesToStashException {
        logger.info("Attempting stash save with message");
        Git git = new Git(this.repo);
        RevCommit stash = git.stashCreate().setIncludeUntracked(includeUntracked).setWorkingDirectoryMessage(wdMessage).setIndexMessage(indexMessage).call();
        if (stash == null) {
            throw new NoFilesToStashException();
        }
    }

    public List<CommitHelper> stashList() throws GitAPIException, IOException {
        logger.info("Attempting stash list");
        Git git = new Git(this.repo);
        ArrayList<CommitHelper> stashCommitList = new ArrayList<CommitHelper>();
        for (RevCommit commit : git.stashList().call()) {
            stashCommitList.add(new CommitHelper(commit));
        }
        return stashCommitList;
    }

    public void stashApply(String stashRef, boolean force) throws GitAPIException {
        logger.info("Attempting stash apply");
        Git git = new Git(this.repo);
        git.stashApply().setStashRef(stashRef).ignoreRepositoryState(force).call();
    }

    void stashApply(String stashRef, boolean force, boolean applyIndex, boolean applyUntracked) throws GitAPIException {
        logger.info("Attempting stash apply with params");
        Git git = new Git(this.repo);
        StashApplyCommand stashApply = git.stashApply().setStashRef(stashRef).ignoreRepositoryState(force);
        stashApply.setApplyIndex(applyIndex);
        stashApply.setApplyUntracked(applyUntracked);
        stashApply.call();
    }

    public ObjectId stashClear() throws GitAPIException {
        logger.info("Attempting stash drop all");
        Git git = new Git(this.repo);
        return git.stashDrop().setAll(true).call();
    }

    public ObjectId stashDrop(int stashRef) throws GitAPIException {
        logger.info("Attempting stash drop");
        Git git = new Git(this.repo);
        return git.stashDrop().setStashRef(stashRef).call();
    }

    public boolean checkUnmergedCommits() {
        StoredConfig config = this.repo.getConfig();
        String remoteBranch = config.getString("branch", this.branchModel.getCurrentBranch().getRefName(), "merge");
        String remote = config.getString("branch", this.branchModel.getCurrentBranch().getRefName(), "remote");
        if (remoteBranch == null || remote == null) {
            return false;
        }
        remoteBranch = remote + "/" + Repository.shortenRefName((String)remoteBranch);
        try {
            if (this.branchModel.getBranchByName(BranchModel.BranchType.REMOTE, remoteBranch) != null && this.branchModel.getCurrentBranch() != null) {
                return !this.branchModel.getBranchByName(BranchModel.BranchType.REMOTE, remoteBranch).getHeadId().equals((AnyObjectId)this.branchModel.getCurrentBranch().getHeadId());
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void closeRepo() {
        this.repo.close();
    }

    public Repository getRepo() {
        return this.repo;
    }

    public Path getLocalPath() {
        return this.localPath;
    }

    public List<CommitHelper> getLocalCommits() {
        return this.localCommits;
    }

    public List<CommitHelper> getRemoteCommits() {
        return this.remoteCommits;
    }

    public List<CommitHelper> getAllCommits() {
        ArrayList<CommitHelper> allCommits = new ArrayList<CommitHelper>();
        allCommits.addAll(this.localCommits);
        allCommits.addAll(this.remoteCommits);
        return allCommits;
    }

    public String getCommitDescriptorString(CommitHelper commitHelper, boolean fullCommitMessage) {
        return "Commit ID: " + commitHelper.getId().substring(0, 8) + "\n\nAuthor: " + commitHelper.getAuthorName() + "\n\nTime: " + commitHelper.getFormattedWhen() + "\n\nMessage: " + commitHelper.getMessage(fullCommitMessage);
    }

    public String getCommitDescriptorString(String commitId, boolean fullCommitMessage) {
        return this.getCommitDescriptorString(this.getCommit(commitId), fullCommitMessage);
    }

    public static String getCommitId(CommitHelper commitHelper) {
        return commitHelper.getName();
    }

    public CommitHelper getCommit(String idOrRefString) {
        if (this.commitIdMap.containsKey(idOrRefString)) {
            return this.commitIdMap.get(idOrRefString);
        }
        try {
            return this.getCommit(this.repo.resolve(idOrRefString));
        }
        catch (IOException e) {
            logger.error("IOException during getCommit");
            logger.debug((Object)e.getStackTrace());
            return null;
        }
    }

    public CommitHelper getCommit(ObjectId id) {
        if (this.idMap.containsKey(id)) {
            return this.getCommit(this.idMap.get(id));
        }
        return null;
    }

    public Cell.CellType getCommitType(CommitHelper helper) {
        if (this.localCommits.contains(helper)) {
            if (this.remoteCommits.contains(helper)) {
                return Cell.CellType.BOTH;
            }
            return Cell.CellType.LOCAL;
        }
        return Cell.CellType.REMOTE;
    }

    public List<String> getAllCommitIDs() {
        return new ArrayList<String>(this.commitIdMap.keySet());
    }

    public boolean canPush() throws IOException {
        return this.branchModel.getCurrentRemoteBranch() == null || this.getAheadCount() > 0;
    }

    public List<CommitHelper> getNewLocalCommits(Map<String, BranchHelper> oldLocalBranches) throws GitAPIException, IOException {
        return this.getNewCommits(oldLocalBranches, this.branchModel.getBranchListTyped(BranchModel.BranchType.LOCAL));
    }

    public List<CommitHelper> getNewRemoteCommits(Map<String, BranchHelper> oldRemoteBranches) throws GitAPIException, IOException {
        return this.getNewCommits(oldRemoteBranches, this.branchModel.getBranchListTyped(BranchModel.BranchType.REMOTE));
    }

    private List<CommitHelper> getNewCommits(Map<String, BranchHelper> oldBranches, List<? extends BranchHelper> newBranches) throws GitAPIException, IOException {
        ArrayList<ObjectId> startPoints = new ArrayList<ObjectId>();
        ArrayList<ObjectId> stopPoints = new ArrayList<ObjectId>();
        for (BranchHelper branchHelper : newBranches) {
            if (oldBranches.containsKey(branchHelper.getRefName())) {
                ObjectId oldBranchHeadID;
                ObjectId newBranchHeadID = branchHelper.getHeadId();
                if (!newBranchHeadID.equals((AnyObjectId)(oldBranchHeadID = oldBranches.get(branchHelper.getRefName()).getHeadId()))) {
                    startPoints.add(newBranchHeadID);
                }
                stopPoints.add(oldBranchHeadID);
                continue;
            }
            startPoints.add(branchHelper.getHeadId());
        }
        PlotCommitList<PlotLane> newCommits = this.parseRawCommits(startPoints, stopPoints);
        return this.wrapRawCommits(newCommits);
    }

    private List<CommitHelper> parseAllLocalCommits() throws IOException, GitAPIException {
        PlotCommitList<PlotLane> commitList = this.parseAllRawLocalCommits();
        return this.wrapRawCommits(commitList);
    }

    private List<CommitHelper> parseAllRemoteCommits() throws IOException, GitAPIException {
        PlotCommitList<PlotLane> commitList = this.parseAllRawRemoteCommits();
        return this.wrapRawCommits(commitList);
    }

    private List<CommitHelper> wrapRawCommits(PlotCommitList<PlotLane> commitList) throws IOException {
        ArrayList<CommitHelper> commitHelperList = new ArrayList<CommitHelper>();
        ArrayList<ObjectId> wrappedIDs = new ArrayList<ObjectId>();
        ArrayList<CommitHelper> commitsWithMissingParents = new ArrayList<CommitHelper>();
        for (int i = commitList.size() - 1; i >= 0; --i) {
            RevCommit[] parents;
            RevCommit curCommit = (RevCommit)commitList.get(i);
            ObjectId curCommitID = curCommit.getId();
            if (wrappedIDs.contains(curCommitID)) continue;
            CommitHelper curCommitHelper = new CommitHelper(curCommit);
            String curCommitHelperID = curCommitHelper.getId();
            if (!this.commitIdMap.containsKey(curCommitHelperID)) {
                this.commitIdMap.put(curCommitHelper.getId(), curCommitHelper);
                this.idMap.put(curCommitID, curCommitHelper.getId());
            } else {
                curCommitHelper = this.commitIdMap.get(curCommitHelperID);
            }
            wrappedIDs.add(curCommitID);
            for (RevCommit p : parents = curCommit.getParents()) {
                CommitHelper parentCommitHelper = this.getCommit(p.getId());
                if (parentCommitHelper == null) {
                    commitsWithMissingParents.add(curCommitHelper);
                    continue;
                }
                curCommitHelper.addParent(parentCommitHelper);
            }
            commitHelperList.add(curCommitHelper);
        }
        while (!commitsWithMissingParents.isEmpty()) {
            RevCommit[] parents;
            CommitHelper curCommitHelper = (CommitHelper)commitsWithMissingParents.remove(0);
            for (RevCommit p : parents = curCommitHelper.commit.getParents()) {
                CommitHelper parentCommitHelper = this.getCommit(p.getId());
                if (parentCommitHelper == null) {
                    commitsWithMissingParents.add(curCommitHelper);
                    continue;
                }
                if (curCommitHelper.getParents().contains(parentCommitHelper)) continue;
                curCommitHelper.addParent(parentCommitHelper);
            }
        }
        return commitHelperList;
    }

    private PlotCommitList<PlotLane> parseAllRawLocalCommits() throws IOException, GitAPIException {
        ObjectId headId = this.repo.resolve("HEAD");
        if (headId == null) {
            return new PlotCommitList();
        }
        ArrayList<ObjectId> examinedCommitIDs = new ArrayList<ObjectId>();
        PlotCommitList<PlotLane> rawLocalCommits = this.parseRawCommits(headId, examinedCommitIDs);
        examinedCommitIDs.add(headId);
        List<LocalBranchHelper> branches = this.branchModel.getLocalBranchesTyped();
        for (BranchHelper branchHelper : branches) {
            ObjectId branchId = branchHelper.getHeadId();
            PlotCommitList<PlotLane> toAdd = this.parseRawCommits(branchId, examinedCommitIDs);
            if (toAdd.size() <= 0) continue;
            rawLocalCommits.addAll(toAdd);
            examinedCommitIDs.add(((PlotCommit)toAdd.get(0)).getId());
        }
        return rawLocalCommits;
    }

    private PlotCommitList<PlotLane> parseAllRawRemoteCommits() throws IOException, GitAPIException {
        ArrayList<ObjectId> examinedCommitIDs = new ArrayList<ObjectId>();
        PlotCommitList rawRemoteCommits = new PlotCommitList();
        for (BranchHelper branchHelper : this.branchModel.getRemoteBranchesTyped()) {
            ObjectId branchId = branchHelper.getHeadId();
            PlotCommitList<PlotLane> toAdd = this.parseRawCommits(branchId, examinedCommitIDs);
            if (toAdd.size() <= 0) continue;
            rawRemoteCommits.addAll(toAdd);
            examinedCommitIDs.add(((PlotCommit)toAdd.get(0)).getId());
        }
        return rawRemoteCommits;
    }

    private PlotCommitList<PlotLane> parseRawCommits(List<ObjectId> startPoints, List<ObjectId> stopPoints) throws IOException {
        PlotCommitList plotCommitList = new PlotCommitList();
        PlotWalk w = new PlotWalk(this.repo);
        for (ObjectId stopId : stopPoints) {
            w.markUninteresting(w.parseCommit((AnyObjectId)stopId));
        }
        for (ObjectId startId : startPoints) {
            w.markStart(w.parseCommit((AnyObjectId)startId));
            PlotCommitList temp = new PlotCommitList();
            temp.source((RevWalk)w);
            temp.fillTo(Integer.MAX_VALUE);
            plotCommitList.addAll((Collection)temp);
        }
        w.dispose();
        return plotCommitList;
    }

    private PlotCommitList<PlotLane> parseRawCommits(ObjectId startingID, List<ObjectId> stopPoints) throws IOException {
        ArrayList<ObjectId> asList = new ArrayList<ObjectId>(1);
        asList.add(startingID);
        return this.parseRawCommits(asList, stopPoints);
    }

    public RevCommit parseRawCommit(ObjectId id) throws IOException {
        RevWalk w = new RevWalk(this.repo);
        w.dispose();
        return w.parseCommit((AnyObjectId)id);
    }

    public Collection<String> getTrackedIgnoredFiles() throws IOException {
        IgnoreNode ignoreNode = new IgnoreNode();
        for (Path path : this.getGitIgnorePaths()) {
            ignoreNode.parse((InputStream)new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])));
        }
        RevWalk walk = new RevWalk(this.repo);
        RevCommit head = walk.parseCommit((AnyObjectId)this.repo.resolve("HEAD"));
        TreeWalk treeWalk = new TreeWalk(this.repo);
        treeWalk.addTree((AnyObjectId)head.getTree());
        treeWalk.setRecursive(false);
        Stack<Boolean> isParentAtDepthIgnored = new Stack<Boolean>();
        isParentAtDepthIgnored.push(false);
        HashSet<String> trackedIgnoredFiles = new HashSet<String>();
        while (treeWalk.next()) {
            boolean isIgnored;
            IgnoreNode.MatchResult result;
            String pathString = treeWalk.getPathString();
            while (treeWalk.getDepth() + 1 < isParentAtDepthIgnored.size()) {
                isParentAtDepthIgnored.pop();
            }
            boolean isParentIgnored = (Boolean)isParentAtDepthIgnored.peek();
            if (treeWalk.isSubtree()) {
                result = ignoreNode.isIgnored(pathString, true);
                if (result == IgnoreNode.MatchResult.IGNORED) {
                    isParentAtDepthIgnored.push(true);
                } else if (result == IgnoreNode.MatchResult.NOT_IGNORED) {
                    isParentAtDepthIgnored.push(false);
                } else {
                    isParentAtDepthIgnored.push((Boolean)isParentAtDepthIgnored.peek());
                }
                treeWalk.enterSubtree();
            } else {
                result = ignoreNode.isIgnored(pathString, false);
            }
            if (!(isIgnored = result == IgnoreNode.MatchResult.IGNORED || isParentIgnored && result == IgnoreNode.MatchResult.CHECK_PARENT)) continue;
            trackedIgnoredFiles.add(pathString);
        }
        return trackedIgnoredFiles;
    }

    public List<Path> getGitIgnorePaths() throws IOException {
        Path infoExclude;
        LinkedList<Path> gitIgnorePaths = new LinkedList<Path>();
        Path globalIgnore = this.getGlobalGitIgnorePath();
        if (globalIgnore != null) {
            gitIgnorePaths.add(globalIgnore);
        }
        if ((infoExclude = this.getInfoExcludePath()) != null) {
            gitIgnorePaths.add(infoExclude);
        }
        GitIgnoreFinder finder = new GitIgnoreFinder();
        Files.walkFileTree(this.localPath, finder);
        gitIgnorePaths.addAll(finder.getMatchedPaths());
        return gitIgnorePaths;
    }

    public Path getGlobalGitIgnorePath() {
        StoredConfig repoConfig = this.repo.getConfig();
        FS fs = this.repo.getFS();
        String globalIgnorePath = ((CoreConfig)repoConfig.get(CoreConfig.KEY)).getExcludesFile();
        if (globalIgnorePath != null) {
            if (globalIgnorePath.startsWith("~/")) {
                globalIgnorePath = fs.resolve(fs.userHome(), globalIgnorePath.substring(2)).getAbsolutePath();
            }
            return Paths.get(globalIgnorePath, new String[0]);
        }
        return null;
    }

    public Path getInfoExcludePath() {
        FS fs = this.repo.getFS();
        File repoExclude = fs.resolve(this.repo.getDirectory(), "info/exclude");
        return repoExclude.exists() ? repoExclude.toPath() : null;
    }

    public String toString() {
        return this.localPath.getFileName().toString();
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass().equals(this.getClass())) {
            RepoHelper other = (RepoHelper)o;
            return this.localPath.equals(other.localPath);
        }
        return false;
    }

    public Collection<Ref> getRefsFromRemote(boolean includeTags) throws GitAPIException {
        if (includeTags) {
            return new Git(this.repo).lsRemote().setHeads(true).setTags(includeTags).call();
        }
        return new Git(this.repo).lsRemote().setHeads(true).call();
    }

    public List<RefHelper> getRefsForCommit(CommitHelper helper) {
        Map<CommitHelper, List<TagHelper>> tagMap;
        ArrayList<RefHelper> helpers = new ArrayList<RefHelper>();
        if (this.branchModel.getBranchesWithHead(helper).size() > 0) {
            helpers.addAll((Collection)this.branchModel.getAllBranchHeads().get(helper));
        }
        if ((tagMap = this.tagModel.getTagCommitMap()).containsKey(helper)) {
            helpers.addAll((Collection<RefHelper>)tagMap.get(helper));
        }
        return helpers;
    }

    public BranchModel getBranchModel() {
        return this.branchModel;
    }

    public TagModel getTagModel() {
        return this.tagModel;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAuthCredentials(UsernamePasswordCredentialsProvider authCredentials) {
        this.ownerAuth = authCredentials;
    }

    public UsernamePasswordCredentialsProvider getOwnerAuthCredentials() throws CancelledAuthorizationException {
        return this.ownerAuth;
    }

    public AuthMethod getCompatibleAuthentication() {
        List protocols = TransportGitSsh.getTransportProtocols();
        List<String> repoURLs = this.getLinkedRemoteRepoURLs();
        String repoURL = repoURLs.get(0);
        for (TransportProtocol protocol : protocols) {
            String protocolName = protocol.getName();
            try {
                if (!protocol.canHandle(new URIish(repoURL))) continue;
                if (protocolName.equals("HTTP")) {
                    return AuthMethod.HTTP;
                }
                if (!protocolName.equals("SSH")) continue;
                return AuthMethod.SSH;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return AuthMethod.NONE;
    }

    private class GitIgnoreFinder
    extends SimpleFileVisitor<Path> {
        private final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:.gitignore");
        private List<Path> matchedPaths = new LinkedList<Path>();

        GitIgnoreFinder() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            Path name = file.getFileName();
            if (name != null && this.matcher.matches(name)) {
                this.matchedPaths.add(file);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException e) {
            e.printStackTrace();
            return FileVisitResult.CONTINUE;
        }

        public Collection<Path> getMatchedPaths() {
            return this.matchedPaths;
        }
    }
}

