/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import elegit.CommitTreeController;
import elegit.DiffHelper;
import elegit.GitIgnoreEditor;
import elegit.RepoHelper;
import elegit.controllers.SessionController;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.text.Font;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.PopOver;
import org.eclipse.jgit.api.errors.GitAPIException;

public class RepoFile
implements Comparable<RepoFile> {
    public Path filePath;
    RepoHelper repo;
    static final Logger logger = LogManager.getLogger();
    protected ArrayList<RepoFile> children;
    Button diffButton;
    boolean showPopover;
    PopOver diffPopover;
    ContextMenu contextMenu;

    public RepoFile(Path filePath, RepoHelper repo) {
        this.repo = repo;
        this.filePath = filePath.isAbsolute() ? repo.getLocalPath().relativize(filePath) : filePath;
        this.showPopover = false;
        this.diffButton = new Button("UNCHANGED");
        this.diffButton.getStyleClass().add((Object)"diffButton");
        this.diffPopover = new PopOver();
        this.diffButton.setOnAction(e -> {
            try {
                this.showDiffPopover((Node)this.diffButton);
            }
            catch (IOException e1) {
                logger.error("IOException in creating repo file");
                logger.debug((Object)e1.getStackTrace());
                e1.printStackTrace();
            }
            catch (GitAPIException e1) {
                logger.error("GitAPIException in creating repo file");
                logger.debug((Object)e1.getStackTrace());
                e1.printStackTrace();
            }
        });
        this.contextMenu = new ContextMenu();
        MenuItem addToIgnoreItem = new MenuItem("Add to .gitignore...");
        addToIgnoreItem.setOnAction(event -> GitIgnoreEditor.show(this.repo, this.filePath));
        MenuItem checkoutItem = new MenuItem("Checkout...");
        SessionController controller = CommitTreeController.sessionController;
        checkoutItem.setOnAction(event -> controller.handleCheckoutButton(filePath));
        this.contextMenu.getItems().addAll((Object[])new MenuItem[]{addToIgnoreItem, checkoutItem});
    }

    public RepoFile(String filePathString, RepoHelper repo) {
        this(Paths.get(filePathString, new String[0]), repo);
    }

    public boolean canAdd() throws GitAPIException, IOException {
        return false;
    }

    public boolean canRemove() {
        return true;
    }

    public String toString() {
        return this.filePath.getFileName().toString();
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public RepoHelper getRepo() {
        return this.repo;
    }

    public int getLevelInRepository() {
        int depth = 0;
        for (Path p = this.filePath.getParent(); p != null; p = p.getParent()) {
            ++depth;
        }
        return depth;
    }

    public ArrayList<RepoFile> getChildren() {
        return this.children;
    }

    public void addChild(RepoFile repoFile) {
        System.err.println("Can't add children to this type of RepoFile.");
    }

    public void showDiffPopover(Node owner) throws IOException, GitAPIException {
        if (this.showPopover) {
            this.contextMenu.hide();
            DiffHelper diffHelper = new DiffHelper(this.filePath, this.repo);
            this.diffPopover.setContentNode((Node)diffHelper.getDiffScrollPane());
            this.diffPopover.setTitle("File Diffs");
            this.diffPopover.show(owner);
        }
    }

    public void showContextMenu(Node owner, double x, double y) {
        this.diffPopover.hide();
        this.contextMenu.show(owner, x, y);
    }

    protected Tooltip getToolTip(String message) {
        Tooltip tooltip = new Tooltip(message);
        tooltip.setFont(new Font(10.0));
        return tooltip;
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass().equals(this.getClass())) {
            RepoFile other = (RepoFile)o;
            return this.filePath.equals(other.filePath) && other.getRepo().getLocalPath().equals(this.getRepo().getLocalPath());
        }
        return false;
    }

    @Override
    public int compareTo(RepoFile other) {
        return this.toString().compareToIgnoreCase(other.toString());
    }
}

