/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import elegit.BranchHelper;
import elegit.RepoHelper;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;

public class RemoteBranchHelper
extends BranchHelper {
    public RemoteBranchHelper(Ref ref, RepoHelper repo) {
        super(ref.getName(), repo);
    }

    @Override
    public String getRefName() {
        return this.repoHelper.repo.getRemoteName(this.refPathString) + "/" + super.getRefName();
    }

    @Override
    public String getAbbrevName() {
        String name = this.getRefName();
        if (name.length() > 25) {
            name = name.substring(0, 24) + "...";
        }
        return name;
    }

    @Override
    protected String parseBranchName() {
        String[] slashSplit = this.refPathString.split("/");
        CharSequence[] removedFirstThreeDirectoriesInPath = Arrays.copyOfRange(slashSplit, 3, slashSplit.length);
        String branchName = String.join((CharSequence)"/", removedFirstThreeDirectoriesInPath);
        return branchName;
    }

    @Override
    public void checkoutBranch() throws GitAPIException, IOException {
    }
}

