/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class PrefObj {
    private static final int pieceLength = 6144;

    private static byte[] object2Bytes(Object o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(o);
        return baos.toByteArray();
    }

    private static byte[][] breakIntoPieces(byte[] raw) {
        int numPieces = (raw.length + 6144 - 1) / 6144;
        byte[][] pieces = new byte[numPieces][];
        for (int i = 0; i < numPieces; ++i) {
            int startByte = i * 6144;
            int endByte = startByte + 6144;
            if (endByte > raw.length) {
                endByte = raw.length;
            }
            int length = endByte - startByte;
            pieces[i] = new byte[length];
            System.arraycopy(raw, startByte, pieces[i], 0, length);
        }
        return pieces;
    }

    private static void writePieces(Preferences prefs, String key, byte[][] pieces) throws BackingStoreException {
        Preferences node = prefs.node(key);
        node.clear();
        for (int i = 0; i < pieces.length; ++i) {
            node.putByteArray("" + i, pieces[i]);
        }
    }

    private static byte[][] readPieces(Preferences prefs, String key) throws BackingStoreException {
        Preferences node = prefs.node(key);
        String[] keys = node.keys();
        int numPieces = keys.length;
        byte[][] pieces = new byte[numPieces][];
        for (int i = 0; i < numPieces; ++i) {
            pieces[i] = node.getByteArray("" + i, null);
        }
        return pieces;
    }

    private static byte[] combinePieces(byte[][] pieces) {
        int length = 0;
        for (int i = 0; i < pieces.length; ++i) {
            length += pieces[i].length;
        }
        byte[] raw = new byte[length];
        int cursor = 0;
        for (int i = 0; i < pieces.length; ++i) {
            System.arraycopy(pieces[i], 0, raw, cursor, pieces[i].length);
            cursor += pieces[i].length;
        }
        return raw;
    }

    private static Object bytes2Object(byte[] raw) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(raw);
        if (raw.length == 0) {
            return null;
        }
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object o = ois.readObject();
        return o;
    }

    public static void putObject(Preferences prefs, String key, Object o) throws IOException, BackingStoreException, ClassNotFoundException {
        byte[] raw = PrefObj.object2Bytes(o);
        byte[][] pieces = PrefObj.breakIntoPieces(raw);
        PrefObj.writePieces(prefs, key, pieces);
    }

    public static Object getObject(Preferences prefs, String key) throws IOException, BackingStoreException, ClassNotFoundException {
        byte[][] pieces = PrefObj.readPieces(prefs, key);
        byte[] raw = PrefObj.combinePieces(pieces);
        Object o = PrefObj.bytes2Object(raw);
        return o;
    }

    public static void removeObject(Preferences prefs, String key) throws BackingStoreException {
        Preferences node = prefs.node(key);
        node.removeNode();
    }

    public static String[] keys(Preferences prefs) throws BackingStoreException {
        return prefs.keys();
    }
}

