/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import elegit.LocalBranchHelper;
import elegit.RemoteBranchHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.CheckListView;

public class PopUpWindows {
    static final Logger logger = LogManager.getLogger();

    public static String showCommittingConflictingFileAlert() {
        String resultType;
        Alert alert = new Alert(Alert.AlertType.WARNING);
        ButtonType resolveButton = new ButtonType("Open Editor");
        ButtonType addButton = new ButtonType("Add");
        ButtonType cancelButton = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        ButtonType helpButton = new ButtonType("Help", ButtonBar.ButtonData.HELP);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{helpButton, resolveButton, addButton, cancelButton});
        alert.setResizable(true);
        alert.getDialogPane().setPrefSize(450.0, 200.0);
        alert.setTitle("Warning: conflicting file");
        alert.setHeaderText("You're adding a conflicting file");
        alert.setContentText("You can open an editor to resolve the conflicts, or add the changes anyways. What do you want to do?");
        ImageView img = new ImageView(new Image("/elegit/images/conflict.png"));
        img.setFitHeight(40.0);
        img.setFitWidth(80.0);
        img.setPreserveRatio(true);
        alert.setGraphic((Node)img);
        Optional result = alert.showAndWait();
        if (result.get() == resolveButton) {
            logger.info("Chose to resolve conflicts");
            resultType = "resolve";
        } else if (result.get() == addButton) {
            logger.info("Chose to add file");
            resultType = "add";
        } else if (result.get() == helpButton) {
            logger.info("Chose to get help");
            resultType = "help";
        } else {
            logger.info("Cancelled dialog");
            resultType = "cancel";
        }
        return resultType;
    }

    public static boolean getLoggingPermissions() {
        Alert window = new Alert(Alert.AlertType.INFORMATION);
        ButtonType okButton = new ButtonType("Share");
        ButtonType buttonTypeCancel = new ButtonType("Don't Share", ButtonBar.ButtonData.CANCEL_CLOSE);
        window.getButtonTypes().setAll((Object[])new ButtonType[]{okButton, buttonTypeCancel});
        window.setResizable(true);
        window.getDialogPane().setPrefSize(300.0, 200.0);
        window.setTitle("Usage Data");
        window.setHeaderText("Share anonymous usage data");
        window.setContentText("Click Share if you want to share anonymous usage data with us, which helps us improve this tool. This can be changed at any time with the preferences menu.");
        Optional result = window.showAndWait();
        return result.get() == okButton;
    }

    public static void showConflictingHelpAlert() {
        Platform.runLater(() -> {
            Alert window = new Alert(Alert.AlertType.INFORMATION);
            window.setResizable(true);
            window.getDialogPane().setPrefSize(550.0, 350.0);
            window.setTitle("How to fix conflicting files");
            window.setHeaderText("How to fix conflicting files");
            window.setContentText("1. First, open up the file that is marked as conflicting.\n2. In the file, you should see something like this:\n\n\t<<<<<< <branch_name>\n\tChanges being made on the branch that is being merged into.\n\tIn most cases, this is the branch that you currently have checked out (i.e. HEAD).\n\t=======\n\tChanges made on the branch that is being merged in.\n\t>>>>>>> <branch name>\n\n3. Delete the contents you don't want to keep after the merge\n4. Remove the markers (<<<<<<<, =======, >>>>>>>) git put in the file\n5. Done! You can now safely add and commit the file");
            window.showAndWait();
        });
    }

    public static void showResetHelpAlert() {
        Platform.runLater(() -> {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.getDialogPane().setPrefSize(300.0, 300.0);
            alert.setTitle("Reset Help");
            alert.setHeaderText("What is reset?");
            ImageView img = new ImageView(new Image("/elegit/images/undo.png"));
            img.setFitHeight(60.0);
            img.setFitWidth(60.0);
            alert.setGraphic((Node)img);
            alert.setContentText("Move the current branch tip backward to the selected commit, reset the staging area to match, but leave the working directory alone. All changes made since the selected commit will reside in the working directory.");
            alert.showAndWait();
        });
    }

    public static void showRevertHelpAlert() {
        Platform.runLater(() -> {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.getDialogPane().setPrefWidth(500.0);
            alert.setTitle("Revert Help");
            alert.setHeaderText("What is revert?");
            ImageView img = new ImageView(new Image("/elegit/images/undo.png"));
            img.setFitHeight(60.0);
            img.setFitWidth(60.0);
            alert.setGraphic((Node)img);
            alert.setContentText("Basically, git revert takes your current files, and deletes any changes from the commit(s) you give it, making a new commit. See\n\nhttp://dmusican.github.io/Elegit/jekyll/update/2016/08/04/what-is-revert.html\n\nfor more information");
            alert.showAndWait();
        });
    }

    public static boolean showCheckoutAlert() {
        Alert alert = new Alert(Alert.AlertType.WARNING);
        ButtonType checkout = new ButtonType("Checkout");
        ButtonType cancel = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{checkout, cancel});
        alert.setTitle("Checkout Warning");
        alert.setContentText("Are you sure you want to checkout the selected files?\nThis will discard all changes that have not been added (staged).");
        Optional result = alert.showAndWait();
        if (result.isPresent()) {
            return result.get() == checkout;
        }
        return false;
    }

    public static String showAddingingConflictingThenModifiedFileAlert() {
        String resultType;
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        ButtonType commitButton = new ButtonType("Add");
        ButtonType buttonTypeCancel = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{commitButton, buttonTypeCancel});
        alert.setResizable(true);
        alert.getDialogPane().setPrefSize(300.0, 200.0);
        alert.setTitle("Adding previously conflicting file");
        alert.setHeaderText("You are adding a conflicting file that was recently modified to the commit");
        alert.setContentText("If the file is what you want it to be, you should commit. Otherwise, modify the file accordingly.");
        Optional result = alert.showAndWait();
        if (result.get() == commitButton) {
            logger.info("Chose to add");
            resultType = "add";
        } else {
            logger.info("Cancelled dialog");
            resultType = "cancel";
        }
        return resultType;
    }

    public static void showTrackingIgnoredFilesWarning(Collection<String> trackedIgnoredFiles) {
        Platform.runLater(() -> {
            if (trackedIgnoredFiles.size() > 0) {
                String fileStrings = "";
                for (String s : trackedIgnoredFiles) {
                    fileStrings = fileStrings + "\n" + s;
                }
                Alert alert = new Alert(Alert.AlertType.WARNING, "The following files are being tracked by Git, but also match an ignore pattern. If you want to ignore these files, remove them from Git.\n" + fileStrings, new ButtonType[0]);
                alert.showAndWait();
            }
        });
    }

    public static void showCheckoutConflictsAlert(List<String> conflictingPaths) {
        logger.warn("Checkout conflicts warning");
        String conflictList = "";
        for (String pathName : conflictingPaths) {
            conflictList = conflictList + "\n" + pathName;
        }
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Conflicting files");
        alert.setHeaderText("Can't checkout that branch");
        alert.setContentText("You can't switch to that branch because of the following conflicting files between that branch and your current branch: " + conflictList);
        alert.showAndWait();
    }

    public static void showMergeConflictsAlert(List<String> conflictingPaths) {
        logger.warn("Merge conflicts warning");
        String conflictList = "";
        for (String pathName : conflictingPaths) {
            conflictList = conflictList + "\n" + pathName;
        }
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Conflicting files");
        alert.setHeaderText("Can't complete merge");
        alert.setContentText("There were conflicts in the following files: " + conflictList);
        alert.showAndWait();
    }

    public static RemoteBranchHelper showTrackDifRemoteBranchDialog(ObservableList<RemoteBranchHelper> remoteBranches) {
        Dialog dialog = new Dialog();
        dialog.getDialogPane().setPrefSize(320.0, 100.0);
        dialog.setTitle("Track a remote branch locally");
        Text trackText = new Text("Track ");
        Text localText = new Text(" locally.");
        ComboBox dropdown = new ComboBox(remoteBranches);
        dropdown.setPromptText("select a remote branch...");
        HBox hBox = new HBox(new Node[]{trackText, dropdown, localText});
        hBox.setSpacing(10.0);
        hBox.setAlignment(Pos.CENTER);
        dialog.getDialogPane().setContent((Node)hBox);
        ButtonType trackButton = new ButtonType("Track");
        ButtonType cancelButton = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{trackButton, cancelButton});
        Optional result = dialog.showAndWait();
        if (result.get() == trackButton) {
            dialog.close();
            return (RemoteBranchHelper)dropdown.getSelectionModel().getSelectedItem();
        }
        return null;
    }

    public static boolean showForceDeleteBranchAlert() {
        Alert alert = new Alert(Alert.AlertType.WARNING);
        alert.setTitle("Deleting unmerged branch");
        alert.setHeaderText("The branch you are trying to delete is unmerged");
        alert.setContentText("The work done on this branch is not represented in any other local branch. If you delete it, you will lose any local work done on this branch. What would you like to do?");
        ButtonType deleteButton = new ButtonType("Force delete branch");
        ButtonType cancelButton = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        alert.getButtonTypes().clear();
        alert.getButtonTypes().addAll((Object[])new ButtonType[]{deleteButton, cancelButton});
        Optional result = alert.showAndWait();
        return result.get() == deleteButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String pickRemoteToPushTo(Set<String> remotes) {
        ReentrantLock lock = new ReentrantLock();
        Condition finishedAlert = lock.newCondition();
        String[] result = new String[1];
        Platform.runLater(() -> {
            try {
                lock.lock();
                Alert alert = new Alert(Alert.AlertType.NONE);
                alert.setTitle("Multiple remotes found");
                alert.setHeaderText("There are multiple remote repositories associated with this repository.\nPick one to push to.");
                ComboBox remoteRepos = new ComboBox();
                remoteRepos.setPromptText("Choose a remote...");
                remoteRepos.setItems(FXCollections.observableArrayList((Collection)remotes));
                ButtonType okButton = new ButtonType("OK", ButtonBar.ButtonData.OK_DONE);
                ButtonType cancelButton = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
                alert.getDialogPane().setContent((Node)remoteRepos);
                alert.getButtonTypes().addAll((Object[])new ButtonType[]{cancelButton, okButton});
                Optional alertResult = alert.showAndWait();
                if (alertResult.isPresent() && alertResult.get() == okButton) {
                    result[0] = (String)remoteRepos.getSelectionModel().getSelectedItem();
                }
                finishedAlert.signal();
            }
            finally {
                lock.unlock();
            }
        });
        lock.lock();
        try {
            finishedAlert.await();
            if (result[0] != null) {
                String string = result[0];
                return string;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            lock.unlock();
        }
        return "cancel";
    }

    public static String getCommitMessage() {
        Alert alert = new Alert(Alert.AlertType.NONE);
        alert.setTitle("Commit message");
        alert.setResizable(true);
        TextArea textArea = new TextArea();
        textArea.setPromptText("Commit Message...");
        textArea.setWrapText(true);
        textArea.setPrefSize(250.0, 150.0);
        textArea.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        HBox hBox = new HBox(new Node[]{textArea});
        hBox.setAlignment(Pos.CENTER);
        ButtonType okButton = new ButtonType("Commit", ButtonBar.ButtonData.OK_DONE);
        ButtonType cancelButton = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        alert.getDialogPane().setContent((Node)hBox);
        alert.getButtonTypes().addAll((Object[])new ButtonType[]{cancelButton, okButton});
        Optional alertResult = alert.showAndWait();
        if (alertResult.isPresent() && alertResult.get() == okButton && !textArea.getText().equals("")) {
            return textArea.getText();
        }
        return "cancel";
    }

    public static ArrayList<LocalBranchHelper> getUntrackedBranchesToPush(ArrayList<LocalBranchHelper> branches) {
        ArrayList<LocalBranchHelper> result = new ArrayList<LocalBranchHelper>(branches.size());
        Alert alert = new Alert(Alert.AlertType.NONE);
        alert.setTitle("Untracked local branches");
        alert.setHeaderText("The branches below are not tracked remotely.\nSelect the branches you want to create an upstream remote branch for.");
        CheckListView untrackedBranches = new CheckListView(FXCollections.observableArrayList(branches));
        ButtonType okButton = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        ButtonType trackButton = new ButtonType("Track Branches", ButtonBar.ButtonData.APPLY);
        alert.getDialogPane().setContent((Node)untrackedBranches);
        alert.getButtonTypes().addAll((Object[])new ButtonType[]{trackButton, okButton});
        Optional alertResult = alert.showAndWait();
        if (alertResult.isPresent() && alertResult.get() == trackButton) {
            result.addAll((Collection<LocalBranchHelper>)untrackedBranches.getCheckModel().getCheckedItems());
        }
        if (result.size() > 0) {
            return result;
        }
        return null;
    }

    public static boolean trackCurrentBranchRemotely(String branchName) {
        boolean[] result = new boolean[]{false};
        Alert alert = new Alert(Alert.AlertType.NONE);
        alert.setTitle("push -u");
        Label branchLabel = new Label(branchName);
        HBox branchBox = new HBox(new Node[]{branchLabel});
        branchBox.setStyle("    -fx-background-color: #1E90FF;\n    -fx-background-radius: 5;\n    -fx-padding: 0 3 0 3;");
        branchLabel.setStyle("    -fx-text-fill: #FFFFFF;\n    -fx-font-size: 14px;\n    -fx-font-weight: bold;\n    -fx-text-align: center;");
        Text txt1 = new Text(" is not currently tracked remotely.");
        Text txt2 = new Text("Would you like to create an upstream remote branch?");
        txt1.setFont(new Font(14.0));
        txt2.setFont(new Font(14.0));
        HBox hBox = new HBox(new Node[]{branchBox, txt1});
        VBox vBox = new VBox(new Node[]{hBox, txt2});
        vBox.setSpacing(10.0);
        vBox.setAlignment(Pos.CENTER);
        ButtonType okButton = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        ButtonType trackButton = new ButtonType("Yes", ButtonBar.ButtonData.APPLY);
        alert.getDialogPane().setContent((Node)vBox);
        alert.getButtonTypes().addAll((Object[])new ButtonType[]{trackButton, okButton});
        Optional alertResult = alert.showAndWait();
        if (alertResult.isPresent() && alertResult.get() == trackButton) {
            result[0] = true;
        }
        return result[0];
    }
}

