/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import com.apple.eawt.Application;
import elegit.BusyWindow;
import elegit.RepositoryMonitor;
import elegit.controllers.SessionController;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Main
extends javafx.application.Application {
    private Path logPath;
    public static boolean isAppClosed;
    public static final CountDownLatch startLatch;
    public static SessionController sessionController;

    public static void main(String[] args) {
        if (args.length == 0) {
            Main.launch((String[])args);
        } else if (args[0].equals("clearprefs")) {
            Main.clearPreferences();
        } else {
            System.out.println("Invalid option.");
        }
    }

    public void start(Stage primaryStage) throws Exception {
        this.logPath = Paths.get("logs", new String[0]);
        String s = this.logPath.toAbsolutePath().toString();
        System.setProperty("logFolder", s);
        Logger logger = LogManager.getLogger();
        RepositoryMonitor.pause();
        BusyWindow.setParentWindow((Window)primaryStage);
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/elegit/fxml/MainView.fxml"));
        fxmlLoader.load();
        BorderPane root = (BorderPane)fxmlLoader.getRoot();
        sessionController = (SessionController)fxmlLoader.getController();
        sessionController.loadLogging();
        javafx.scene.image.Image img = new javafx.scene.image.Image(((Object)((Object)this)).getClass().getResourceAsStream("/elegit/images/elegit_icon.png"));
        primaryStage.getIcons().add((Object)img);
        if (SystemUtils.IS_OS_MAC) {
            BufferedImage dock_img = ImageIO.read(((Object)((Object)this)).getClass().getResourceAsStream("/elegit/images/elegit_icon.png"));
            Application.getApplication().setDockIconImage((Image)dock_img);
        }
        Rectangle2D primScreenBounds = Screen.getPrimary().getVisualBounds();
        int screenWidth = (int)primScreenBounds.getWidth();
        int screenHeight = (int)primScreenBounds.getHeight();
        Scene scene = new Scene((Parent)root, (double)(screenWidth * 4 / 5), (double)(screenHeight * 4 / 5));
        primaryStage.setOnCloseRequest(event -> {
            logger.info("Closed");
            isAppClosed = true;
        });
        primaryStage.setTitle("Elegit");
        primaryStage.setScene(scene);
        sessionController.setStage(primaryStage);
        startLatch.countDown();
        primaryStage.show();
        RepositoryMonitor.unpause();
    }

    private static void clearPreferences() {
        Preferences prefs = Preferences.userNodeForPackage(Main.class);
        try {
            System.out.print("Are you sure you want to clear all prefs (yes/no)?");
            Scanner inp = new Scanner(System.in);
            String response = inp.next();
            if (response.equals("yes")) {
                prefs.removeNode();
                System.out.println("Preferences cleared.");
            }
        }
        catch (BackingStoreException e) {
            System.out.println("Error: can't access preferences.");
        }
    }

    static {
        startLatch = new CountDownLatch(1);
    }
}

