/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import elegit.BranchHelper;
import elegit.RepoHelper;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;

public class LocalBranchHelper
extends BranchHelper {
    public LocalBranchHelper(String refPathString, RepoHelper repo) throws IOException {
        super(refPathString, repo);
    }

    public LocalBranchHelper(Ref branchRef, RepoHelper repo) throws IOException {
        this(branchRef.getName(), repo);
    }

    @Override
    protected String parseBranchName() {
        String[] slashSplit = this.refPathString.split("/");
        if (slashSplit.length >= 2) {
            CharSequence[] removedFirstTwoDirectoriesInPath = Arrays.copyOfRange(slashSplit, 2, slashSplit.length);
            String branchName = String.join((CharSequence)"/", removedFirstTwoDirectoriesInPath);
            return branchName;
        }
        return this.refPathString;
    }

    @Override
    public void checkoutBranch() throws GitAPIException, IOException {
        new Git(this.repoHelper.getRepo()).checkout().setName(this.refName).call();
        this.repoHelper.getBranchModel().refreshCurrentBranch();
    }
}

