/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import elegit.PopUpWindows;
import elegit.RepoHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Separator;
import javafx.scene.control.TextArea;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;

public class GitIgnoreEditor {
    private static Stage window;
    private static RepoHelper repoHelper;
    private static Path gitIgnoreFile;
    private static String addedPath;

    private static Stage initWindow() {
        Stage window = new Stage();
        Rectangle2D primaryScreenBounds = Screen.getPrimary().getVisualBounds();
        window.setMaxHeight(primaryScreenBounds.getHeight());
        window.setMaxWidth(primaryScreenBounds.getWidth());
        window.setMinHeight(400.0);
        window.setMinWidth(450.0);
        window.initModality(Modality.APPLICATION_MODAL);
        window.setScene(new Scene(GitIgnoreEditor.getRootOfScene()));
        window.setTitle(gitIgnoreFile.toString());
        return window;
    }

    private static Parent getRootOfScene() {
        TextArea textArea = new TextArea();
        textArea.setStyle("-fx-focus-color: transparent; -fx-faint-focus-color: transparent;");
        Button okButton = new Button("Save");
        okButton.setOnAction(event -> GitIgnoreEditor.handleConfirmation(textArea.getText(), true));
        Button cancelButton = new Button("Cancel");
        cancelButton.setOnAction(event -> GitIgnoreEditor.handleConfirmation(textArea.getText(), false));
        HBox buttonArea = new HBox(new Node[]{cancelButton, okButton});
        buttonArea.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        buttonArea.setSpacing(5.0);
        buttonArea.setAlignment(Pos.BOTTOM_RIGHT);
        VBox parent = new VBox(new Node[]{textArea, new Separator(Orientation.HORIZONTAL), buttonArea});
        VBox.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
        parent.setStyle("-fx-border-color: #3498DB");
        textArea.setText(GitIgnoreEditor.getTextFromGitIgnoreFile());
        return parent;
    }

    private static void handleConfirmation(String newText, boolean saveChanges) {
        if (saveChanges) {
            try (BufferedReader br = new BufferedReader(new StringReader(newText));
                 BufferedWriter bw = Files.newBufferedWriter(gitIgnoreFile, new OpenOption[0]);){
                String line = br.readLine();
                while (line != null) {
                    bw.write(line);
                    bw.newLine();
                    line = br.readLine();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            PopUpWindows.showTrackingIgnoredFilesWarning(repoHelper.getTrackedIgnoredFiles());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        window.close();
    }

    private static String getTextFromGitIgnoreFile() {
        String returnText = addedPath.length() > 0 ? "\n" + addedPath + "\n" : "";
        try {
            returnText = new String(Files.readAllBytes(gitIgnoreFile)) + returnText;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return returnText;
    }

    public static void show(RepoHelper repo, Path pathToAdd) {
        repoHelper = repo;
        gitIgnoreFile = repoHelper.getLocalPath().resolve(".gitignore");
        addedPath = pathToAdd == null ? "" : pathToAdd.toString().replaceAll("\\\\", "/");
        window = GitIgnoreEditor.initWindow();
        Platform.runLater(() -> ((Stage)window).show());
    }
}

