/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import elegit.DirectoryRepoFile;
import elegit.RepoFile;
import elegit.SessionModel;
import java.io.IOException;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.Region;
import javafx.util.Callback;
import org.eclipse.jgit.api.errors.GitAPIException;

public abstract class FileStructurePanelView
extends Region {
    protected TreeView<RepoFile> directoryTreeView;
    private TreeItem<RepoFile> treeRoot;
    public SessionModel sessionModel;

    public FileStructurePanelView() {
        this.init();
        this.getChildren().clear();
        this.getChildren().add(this.directoryTreeView);
    }

    public void init() {
        this.directoryTreeView = new TreeView();
        this.directoryTreeView.setCellFactory(this.getTreeCellFactory());
        if (this.sessionModel != null) {
            DirectoryRepoFile rootDirectory = new DirectoryRepoFile("", this.sessionModel.getCurrentRepoHelper());
            this.treeRoot = this.getRootTreeItem(rootDirectory);
            this.treeRoot.setExpanded(true);
            this.directoryTreeView.setRoot(this.treeRoot);
        }
        this.directoryTreeView.setShowRoot(false);
        Platform.runLater(() -> {
            this.getChildren().clear();
            this.getChildren().add(this.directoryTreeView);
        });
    }

    public void drawDirectoryView() throws GitAPIException, IOException {
        if (this.sessionModel.getCurrentRepoHelper() == null) {
            return;
        }
        if (this.treeRoot == null || !((RepoFile)this.treeRoot.getValue()).getRepo().equals(this.sessionModel.getCurrentRepoHelper())) {
            this.init();
        }
        List<RepoFile> filesToShow = this.getFilesToDisplay();
        this.addTreeItemsToRoot(filesToShow, this.treeRoot);
    }

    public void resetFileStructurePanelView() {
        this.directoryTreeView = new TreeView();
        this.directoryTreeView.setCellFactory(this.getTreeCellFactory());
        this.getChildren().clear();
        this.getChildren().add(this.directoryTreeView);
    }

    protected Callback<TreeView<RepoFile>, TreeCell<RepoFile>> getTreeCellFactory() {
        return null;
    }

    protected abstract void addTreeItemsToRoot(List<RepoFile> var1, TreeItem<RepoFile> var2);

    protected abstract TreeItem<RepoFile> getRootTreeItem(DirectoryRepoFile var1);

    protected abstract List<RepoFile> getFilesToDisplay() throws GitAPIException, IOException;

    public void setSessionModel(SessionModel sessionModel) {
        this.sessionModel = sessionModel;
    }
}

