/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import elegit.ElegitUserInfoGUI;
import elegit.ExistingRepoHelper;
import elegit.RepoHelper;
import elegit.RepoHelperBuilder;
import elegit.SessionModel;
import elegit.exceptions.CancelledAuthorizationException;
import elegit.exceptions.NoRepoSelectedException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.eclipse.jgit.api.errors.GitAPIException;

public class ExistingRepoHelperBuilder
extends RepoHelperBuilder {
    public ExistingRepoHelperBuilder(SessionModel sessionModel) {
        super(sessionModel);
    }

    @Override
    public RepoHelper getRepoHelperFromDialogs() throws GitAPIException, IOException, NoRepoSelectedException, CancelledAuthorizationException {
        File existingRepoDirectoryFile = this.getDirectoryPathFromChooser("Choose existing repository directory", null);
        if (existingRepoDirectoryFile == null) {
            throw new NoRepoSelectedException();
        }
        Path directoryPath = existingRepoDirectoryFile.toPath();
        ExistingRepoHelper existingRepoHelper = new ExistingRepoHelper(directoryPath, new ElegitUserInfoGUI());
        return existingRepoHelper;
    }
}

