/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import com.jcraft.jsch.UserInfo;
import elegit.SessionModel;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.PasswordField;
import javafx.scene.layout.GridPane;

public class ElegitUserInfoGUI
implements UserInfo {
    private Optional<String> password = Optional.empty();
    private Optional<String> passphrase = Optional.empty();

    public String getPassphrase() {
        return this.passphrase.get();
    }

    public String getPassword() {
        return this.password.get();
    }

    public boolean promptPassword(String s) {
        this.password = this.prompt(s, "SSH password authentication", "SSH password authentication", "Enter your password:");
        return this.password.isPresent();
    }

    public boolean promptPassphrase(String s) {
        this.passphrase = this.prompt(s, "SSH public key authentication", "SSH public key authentication", "Enter your passphrase:");
        return this.passphrase.isPresent();
    }

    private Optional<String> prompt(final String s, final String title, String headerText, String contentText) {
        FutureTask<Optional<String>> futureTask = new FutureTask<Optional<String>>(new Callable<Optional<String>>(){

            @Override
            public Optional<String> call() throws Exception {
                System.out.println(s);
                Dialog dialog = new Dialog();
                GridPane grid = new GridPane();
                grid.setHgap(10.0);
                grid.setVgap(10.0);
                grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
                PasswordField passwordField = new PasswordField();
                grid.add((Node)passwordField, 2, 0);
                dialog.getDialogPane().setContent((Node)grid);
                dialog.setTitle(title);
                dialog.setHeaderText(s);
                dialog.setContentText(s);
                dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
                dialog.setResultConverter(dialogButton -> {
                    if (dialogButton == ButtonType.OK) {
                        return passwordField.getText();
                    }
                    return null;
                });
                Optional result = dialog.showAndWait();
                return result;
            }
        });
        Platform.runLater(futureTask);
        Optional<String> result = Optional.of("");
        try {
            return futureTask.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean promptYesNo(String s) {
        System.out.println(s);
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("SSH yes/no confirmation");
        alert.setHeaderText("SSH yes/no question.");
        alert.setContentText(s);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.NO});
        Optional result = alert.showAndWait();
        if (result.get() == ButtonType.YES) {
            return true;
        }
        if (result.get() == ButtonType.NO) {
            return false;
        }
        SessionModel.logger.error("Internal error with SSH yes/no prompt.");
        return false;
    }

    public void showMessage(String s) {
        System.out.println(s);
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("SSH message");
        alert.setHeaderText("SSH message");
        alert.setContentText(s);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK});
        alert.showAndWait();
    }
}

