/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;

public class ElegitCredentialsProvider
extends CredentialsProvider {
    private List<String> userCredentials;

    public ElegitCredentialsProvider() {
        this.userCredentials = null;
    }

    public ElegitCredentialsProvider(List<String> userCredentials) {
        this.userCredentials = userCredentials;
    }

    public boolean isInteractive() {
        return true;
    }

    public boolean supports(CredentialItem ... credentialItems) {
        for (CredentialItem item : credentialItems) {
            System.out.println("Supports: " + item);
        }
        return true;
    }

    public boolean get(URIish urIish, CredentialItem ... credentialItems) throws UnsupportedCredentialItem {
        if (this.userCredentials != null) {
            Iterator<String> userCredentialsIterator = this.userCredentials.iterator();
            for (CredentialItem item : credentialItems) {
                String nextValue = userCredentialsIterator.next();
                if (item instanceof CredentialItem.Username) {
                    ((CredentialItem.Username)item).setValue(nextValue);
                    continue;
                }
                if (item instanceof CredentialItem.Password) {
                    ((CredentialItem.Password)item).setValue(nextValue.toCharArray());
                    continue;
                }
                if (item instanceof CredentialItem.StringType) {
                    ((CredentialItem.StringType)item).setValue(nextValue);
                    continue;
                }
                System.out.println(item);
                System.out.println(item.getPromptText());
                throw new UnsupportedCredentialItem(urIish, "Case not covered in ElegitCredentialsProvider");
            }
        }
        return true;
    }
}

