/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import elegit.RepoHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class DiffHelper {
    Repository repo;
    String pathFilter;

    public DiffHelper(Path relativeFilePath, RepoHelper repo) throws IOException {
        this.repo = repo.getRepo();
        this.pathFilter = relativeFilePath.toString();
    }

    private String getDiffString() throws GitAPIException, IOException {
        ObjectId head = this.repo.resolve("HEAD");
        if (head == null) {
            return "";
        }
        ByteArrayOutputStream diffOutputStream = new ByteArrayOutputStream();
        DiffFormatter formatter = new DiffFormatter((OutputStream)diffOutputStream);
        formatter.setRepository(this.repo);
        formatter.setPathFilter((TreeFilter)PathFilter.create((String)this.pathFilter.replaceAll("\\\\", "/")));
        AbstractTreeIterator commitTreeIterator = DiffHelper.prepareTreeParser(this.repo, head.getName());
        FileTreeIterator workTreeIterator = new FileTreeIterator(this.repo);
        formatter.format(commitTreeIterator, (AbstractTreeIterator)workTreeIterator);
        return diffOutputStream.toString();
    }

    private ArrayList<Text> getColoredDiffList() throws GitAPIException, IOException {
        String[] lines;
        String diffText = this.getDiffString();
        ArrayList<Text> coloredDiffList = new ArrayList<Text>();
        for (String line : lines = diffText.split("\n")) {
            Text text = new Text(line);
            text.getStyleClass().add((Object)"diffText");
            if (line.length() > 0 && line.charAt(0) == '+') {
                text.setId("addedDiffText");
            } else if (line.length() > 0 && line.charAt(0) == '-') {
                text.setId("deletedDiffText");
            } else if (line.length() > 1 && line.charAt(0) == '@' && line.charAt(1) == '@') {
                text.setId("gitAnnotationDiffText");
            } else {
                text.setText(" " + text.getText());
                text.setId("unchangedDiffText");
            }
            coloredDiffList.add(text);
        }
        return coloredDiffList;
    }

    public ScrollPane getDiffScrollPane() throws GitAPIException, IOException {
        ScrollPane scrollPane = new ScrollPane();
        VBox verticalListOfColoredDiffs = new VBox();
        verticalListOfColoredDiffs.getChildren().setAll(this.getColoredDiffList());
        scrollPane.setContent((Node)verticalListOfColoredDiffs);
        scrollPane.setFitToHeight(true);
        scrollPane.setFitToWidth(true);
        scrollPane.setMaxWidth(800.0);
        scrollPane.setMaxHeight(400.0);
        scrollPane.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        return scrollPane;
    }

    private static AbstractTreeIterator prepareTreeParser(Repository repository, String objectId) throws IOException {
        try (RevWalk walk = new RevWalk(repository);){
            RevCommit commit = walk.parseCommit((AnyObjectId)ObjectId.fromString((String)objectId));
            RevTree tree = walk.parseTree((AnyObjectId)commit.getTree().getId());
            CanonicalTreeParser oldTreeParser = new CanonicalTreeParser();
            try (ObjectReader oldReader = repository.newObjectReader();){
                oldTreeParser.reset(oldReader, (AnyObjectId)tree.getId());
            }
            walk.dispose();
            CanonicalTreeParser canonicalTreeParser = oldTreeParser;
            return canonicalTreeParser;
        }
    }
}

