/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataSubmitter {
    private static final String submitUrl = "http://elegit.mathcs.carleton.edu/logging/upload.php";
    private static final Logger logger = LogManager.getLogger();
    private static final String LOG_FILE_NAME = "elegit.log";

    public String submitData(String uuid) {
        logger.info("Submit data called");
        String logPath = Paths.get("logs", new String[0]).toString();
        File logDirectory = new File(logPath);
        File[] logsToUpload = logDirectory.listFiles();
        String lastUUID = "";
        if (uuid == null || uuid.equals("")) {
            uuid = UUID.randomUUID().toString();
            logger.info("Making a new uuid.");
        }
        for (File logFile : logsToUpload) {
            if ((!logFile.isFile() || logFile.getName().equals(LOG_FILE_NAME)) && logsToUpload.length == 1) {
                logger.info("No new logs to upload today");
                break;
            }
            try {
                logFile = Files.copy(logFile.toPath(), logFile.toPath().resolveSibling(uuid + ".log"), new CopyOption[0]).toFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            logger.info("Attempting to upload log: {}", new Object[]{logFile.getName()});
            CloseableHttpClient httpclient = HttpClients.createDefault();
            try {
                HttpPost httppost = new HttpPost(submitUrl);
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
                FileBody fileBody = new FileBody(logFile);
                builder.addPart("fileToUpload", (ContentBody)fileBody);
                HttpEntity builtEntity = builder.build();
                httppost.setEntity(builtEntity);
                logger.info((Object)httppost.getRequestLine());
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
                try {
                    logger.info("Executing request: " + response.getStatusLine());
                    logger.info(EntityUtils.toString((HttpEntity)response.getEntity()));
                    lastUUID = uuid;
                }
                catch (Exception e) {
                    logger.error("Response status check failed.");
                    response.close();
                    return null;
                }
            }
            catch (Exception e) {
                logger.error("Failed to execute request. Attempting to close client.");
                try {
                    httpclient.close();
                }
                catch (Exception f) {
                    logger.error("Failed to close client.");
                    return null;
                }
                return null;
            }
            logFile.delete();
        }
        for (File file : logDirectory.listFiles()) {
            if (file.getName().equals(LOG_FILE_NAME)) continue;
            file.delete();
        }
        return lastUUID;
    }
}

