/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import elegit.PopUpWindows;
import elegit.RepoFile;
import elegit.RepoHelper;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javafx.application.Platform;
import org.eclipse.jgit.api.errors.GitAPIException;

public class ConflictingThenModifiedRepoFile
extends RepoFile {
    private String resultType;

    public ConflictingThenModifiedRepoFile(Path filePath, RepoHelper repo) {
        super(filePath, repo);
        this.diffButton.setText("CONFLICTING\nMODIFIED");
        this.diffButton.setId("conflictingThenModifiedDiffButton");
        this.diffButton.setTooltip(this.getToolTip("This file was conflicting, but was recently modified.\nCommit if the changes are finalized."));
    }

    public ConflictingThenModifiedRepoFile(String filePathString, RepoHelper repo) {
        this(Paths.get(filePathString, new String[0]), repo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canAdd() throws GitAPIException {
        ReentrantLock lock = new ReentrantLock();
        Condition finishedAlert = lock.newCondition();
        Platform.runLater(() -> {
            logger.warn("Notification about conflicting the modified file");
            lock.lock();
            try {
                this.resultType = PopUpWindows.showAddingingConflictingThenModifiedFileAlert();
                finishedAlert.signal();
            }
            finally {
                lock.unlock();
            }
        });
        lock.lock();
        try {
            finishedAlert.await();
            if (this.resultType.equals("add")) {
                boolean bl = true;
                return bl;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            lock.unlock();
        }
        return false;
    }

    @Override
    public boolean canRemove() {
        return true;
    }
}

