/*
 * Decompiled with CFR 0.152.
 */
package elegit;

import elegit.PopUpWindows;
import elegit.RepoFile;
import elegit.RepoHelper;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javafx.application.Platform;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jgit.api.errors.GitAPIException;

public class ConflictingRepoFile
extends RepoFile {
    private String resultType;
    static final Logger logger = LogManager.getLogger();

    public ConflictingRepoFile(Path filePath, RepoHelper repo) {
        super(filePath, repo);
        this.diffButton.setText("CONFLICTING");
        this.diffButton.setId("conflictingDiffButton");
        this.diffButton.setTooltip(this.getToolTip("This file caused a merge conflict.\nEdit the file to fix the conflict."));
    }

    public ConflictingRepoFile(String filePathString, RepoHelper repo) {
        this(Paths.get(filePathString, new String[0]), repo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean canAdd() throws GitAPIException, IOException {
        ReentrantLock lock = new ReentrantLock();
        Condition finishedAlert = lock.newCondition();
        Platform.runLater(() -> {
            logger.warn("Notification about conflicting file");
            lock.lock();
            try {
                this.resultType = PopUpWindows.showCommittingConflictingFileAlert();
                finishedAlert.signal();
            }
            finally {
                lock.unlock();
            }
        });
        lock.lock();
        try {
            finishedAlert.await();
            switch (this.resultType) {
                case "resolve": {
                    Desktop desktop = Desktop.getDesktop();
                    File workingDirectory = this.repo.getRepo().getWorkTree();
                    File unrelativized = new File(workingDirectory, this.filePath.toString());
                    desktop.open(unrelativized);
                    return false;
                }
                case "add": {
                    boolean bl = true;
                    return bl;
                }
                case "help": {
                    PopUpWindows.showConflictingHelpAlert();
                    return false;
                }
            }
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean canRemove() {
        return true;
    }
}

